/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.VolumeInfo;

public class ListVolumesPublisher
implements SdkPublisher<ListVolumesResponse> {
    private final StorageGatewayAsyncClient client;
    private final ListVolumesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVolumesPublisher(StorageGatewayAsyncClient client, ListVolumesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVolumesPublisher(StorageGatewayAsyncClient client, ListVolumesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVolumesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVolumesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VolumeInfo> volumeInfos() {
        Function<ListVolumesResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumeInfos() != null) {
                return response.volumeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVolumesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListVolumesPublisher resume(ListVolumesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVolumesPublisher(this.client, (ListVolumesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListVolumesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListVolumesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListVolumesResponseFetcher
    implements AsyncPageFetcher<ListVolumesResponse> {
        private ListVolumesResponseFetcher() {
        }

        public boolean hasNextPage(ListVolumesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListVolumesResponse> nextPage(ListVolumesResponse previousPage) {
            if (previousPage == null) {
                return ListVolumesPublisher.this.client.listVolumes(ListVolumesPublisher.this.firstRequest);
            }
            return ListVolumesPublisher.this.client.listVolumes((ListVolumesRequest)((Object)ListVolumesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

