/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.AnswerReason;
import software.amazon.awssdk.services.wellarchitected.model.Choice;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswerSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ChoiceAnswerSummary;
import software.amazon.awssdk.services.wellarchitected.model.ChoicesCopier;
import software.amazon.awssdk.services.wellarchitected.model.QuestionType;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerStatus;
import software.amazon.awssdk.services.wellarchitected.model.SelectedChoicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewTemplateAnswerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewTemplateAnswerSummary> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::questionId)).setter(ReviewTemplateAnswerSummary.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::pillarId)).setter(ReviewTemplateAnswerSummary.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionTitle").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::questionTitle)).setter(ReviewTemplateAnswerSummary.setter(Builder::questionTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()}).build();
    private static final SdkField<List<Choice>> CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Choices").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::choices)).setter(ReviewTemplateAnswerSummary.setter(Builder::choices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Choices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Choice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedChoices").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::selectedChoices)).setter(ReviewTemplateAnswerSummary.setter(Builder::selectedChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ChoiceAnswerSummary>> CHOICE_ANSWER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChoiceAnswerSummaries").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::choiceAnswerSummaries)).setter(ReviewTemplateAnswerSummary.setter(Builder::choiceAnswerSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceAnswerSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChoiceAnswerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsApplicable").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::isApplicable)).setter(ReviewTemplateAnswerSummary.setter(Builder::isApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()}).build();
    private static final SdkField<String> ANSWER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnswerStatus").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::answerStatusAsString)).setter(ReviewTemplateAnswerSummary.setter(Builder::answerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerStatus").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::reasonAsString)).setter(ReviewTemplateAnswerSummary.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<String> QUESTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionType").getter(ReviewTemplateAnswerSummary.getter(ReviewTemplateAnswerSummary::questionTypeAsString)).setter(ReviewTemplateAnswerSummary.setter(Builder::questionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, CHOICES_FIELD, SELECTED_CHOICES_FIELD, CHOICE_ANSWER_SUMMARIES_FIELD, IS_APPLICABLE_FIELD, ANSWER_STATUS_FIELD, REASON_FIELD, QUESTION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final String pillarId;
    private final String questionTitle;
    private final List<Choice> choices;
    private final List<String> selectedChoices;
    private final List<ChoiceAnswerSummary> choiceAnswerSummaries;
    private final Boolean isApplicable;
    private final String answerStatus;
    private final String reason;
    private final String questionType;

    private ReviewTemplateAnswerSummary(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.choices = builder.choices;
        this.selectedChoices = builder.selectedChoices;
        this.choiceAnswerSummaries = builder.choiceAnswerSummaries;
        this.isApplicable = builder.isApplicable;
        this.answerStatus = builder.answerStatus;
        this.reason = builder.reason;
        this.questionType = builder.questionType;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String questionTitle() {
        return this.questionTitle;
    }

    public final boolean hasChoices() {
        return this.choices != null && !(this.choices instanceof SdkAutoConstructList);
    }

    public final List<Choice> choices() {
        return this.choices;
    }

    public final boolean hasSelectedChoices() {
        return this.selectedChoices != null && !(this.selectedChoices instanceof SdkAutoConstructList);
    }

    public final List<String> selectedChoices() {
        return this.selectedChoices;
    }

    public final boolean hasChoiceAnswerSummaries() {
        return this.choiceAnswerSummaries != null && !(this.choiceAnswerSummaries instanceof SdkAutoConstructList);
    }

    public final List<ChoiceAnswerSummary> choiceAnswerSummaries() {
        return this.choiceAnswerSummaries;
    }

    public final Boolean isApplicable() {
        return this.isApplicable;
    }

    public final ReviewTemplateAnswerStatus answerStatus() {
        return ReviewTemplateAnswerStatus.fromValue(this.answerStatus);
    }

    public final String answerStatusAsString() {
        return this.answerStatus;
    }

    public final AnswerReason reason() {
        return AnswerReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public final QuestionType questionType() {
        return QuestionType.fromValue(this.questionType);
    }

    public final String questionTypeAsString() {
        return this.questionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChoices() ? this.choices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedChoices() ? this.selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChoiceAnswerSummaries() ? this.choiceAnswerSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplateAnswerSummary)) {
            return false;
        }
        ReviewTemplateAnswerSummary other = (ReviewTemplateAnswerSummary)obj;
        return Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.questionTitle(), other.questionTitle()) && this.hasChoices() == other.hasChoices() && Objects.equals(this.choices(), other.choices()) && this.hasSelectedChoices() == other.hasSelectedChoices() && Objects.equals(this.selectedChoices(), other.selectedChoices()) && this.hasChoiceAnswerSummaries() == other.hasChoiceAnswerSummaries() && Objects.equals(this.choiceAnswerSummaries(), other.choiceAnswerSummaries()) && Objects.equals(this.isApplicable(), other.isApplicable()) && Objects.equals(this.answerStatusAsString(), other.answerStatusAsString()) && Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.questionTypeAsString(), other.questionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewTemplateAnswerSummary").add("QuestionId", (Object)this.questionId()).add("PillarId", (Object)this.pillarId()).add("QuestionTitle", (Object)this.questionTitle()).add("Choices", this.hasChoices() ? this.choices() : null).add("SelectedChoices", this.hasSelectedChoices() ? this.selectedChoices() : null).add("ChoiceAnswerSummaries", this.hasChoiceAnswerSummaries() ? this.choiceAnswerSummaries() : null).add("IsApplicable", (Object)this.isApplicable()).add("AnswerStatus", (Object)this.answerStatusAsString()).add("Reason", (Object)this.reasonAsString()).add("QuestionType", (Object)this.questionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "QuestionTitle": {
                return Optional.ofNullable(clazz.cast(this.questionTitle()));
            }
            case "Choices": {
                return Optional.ofNullable(clazz.cast(this.choices()));
            }
            case "SelectedChoices": {
                return Optional.ofNullable(clazz.cast(this.selectedChoices()));
            }
            case "ChoiceAnswerSummaries": {
                return Optional.ofNullable(clazz.cast(this.choiceAnswerSummaries()));
            }
            case "IsApplicable": {
                return Optional.ofNullable(clazz.cast(this.isApplicable()));
            }
            case "AnswerStatus": {
                return Optional.ofNullable(clazz.cast(this.answerStatusAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "QuestionType": {
                return Optional.ofNullable(clazz.cast(this.questionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplateAnswerSummary, T> g) {
        return obj -> g.apply((ReviewTemplateAnswerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private String pillarId;
        private String questionTitle;
        private List<Choice> choices = DefaultSdkAutoConstructList.getInstance();
        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();
        private List<ChoiceAnswerSummary> choiceAnswerSummaries = DefaultSdkAutoConstructList.getInstance();
        private Boolean isApplicable;
        private String answerStatus;
        private String reason;
        private String questionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplateAnswerSummary model) {
            this.questionId(model.questionId);
            this.pillarId(model.pillarId);
            this.questionTitle(model.questionTitle);
            this.choices(model.choices);
            this.selectedChoices(model.selectedChoices);
            this.choiceAnswerSummaries(model.choiceAnswerSummaries);
            this.isApplicable(model.isApplicable);
            this.answerStatus(model.answerStatus);
            this.reason(model.reason);
            this.questionType(model.questionType);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getQuestionTitle() {
            return this.questionTitle;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final List<Choice.Builder> getChoices() {
            List<Choice.Builder> result = ChoicesCopier.copyToBuilder(this.choices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoices(Collection<Choice.BuilderImpl> choices) {
            this.choices = ChoicesCopier.copyFromBuilder(choices);
        }

        @Override
        public final Builder choices(Collection<Choice> choices) {
            this.choices = ChoicesCopier.copy(choices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Choice ... choices) {
            this.choices(Arrays.asList(choices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Consumer<Choice.Builder> ... choices) {
            this.choices(Stream.of(choices).map(c -> (Choice)((Choice.Builder)Choice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedChoices() {
            if (this.selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedChoices;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String ... selectedChoices) {
            this.selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final List<ChoiceAnswerSummary.Builder> getChoiceAnswerSummaries() {
            List<ChoiceAnswerSummary.Builder> result = ChoiceAnswerSummariesCopier.copyToBuilder(this.choiceAnswerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChoiceAnswerSummaries(Collection<ChoiceAnswerSummary.BuilderImpl> choiceAnswerSummaries) {
            this.choiceAnswerSummaries = ChoiceAnswerSummariesCopier.copyFromBuilder(choiceAnswerSummaries);
        }

        @Override
        public final Builder choiceAnswerSummaries(Collection<ChoiceAnswerSummary> choiceAnswerSummaries) {
            this.choiceAnswerSummaries = ChoiceAnswerSummariesCopier.copy(choiceAnswerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswerSummaries(ChoiceAnswerSummary ... choiceAnswerSummaries) {
            this.choiceAnswerSummaries(Arrays.asList(choiceAnswerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choiceAnswerSummaries(Consumer<ChoiceAnswerSummary.Builder> ... choiceAnswerSummaries) {
            this.choiceAnswerSummaries(Stream.of(choiceAnswerSummaries).map(c -> (ChoiceAnswerSummary)((ChoiceAnswerSummary.Builder)ChoiceAnswerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsApplicable() {
            return this.isApplicable;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final String getAnswerStatus() {
            return this.answerStatus;
        }

        public final void setAnswerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
        }

        @Override
        public final Builder answerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
            return this;
        }

        @Override
        public final Builder answerStatus(ReviewTemplateAnswerStatus answerStatus) {
            this.answerStatus(answerStatus == null ? null : answerStatus.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(AnswerReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getQuestionType() {
            return this.questionType;
        }

        public final void setQuestionType(String questionType) {
            this.questionType = questionType;
        }

        @Override
        public final Builder questionType(String questionType) {
            this.questionType = questionType;
            return this;
        }

        @Override
        public final Builder questionType(QuestionType questionType) {
            this.questionType(questionType == null ? null : questionType.toString());
            return this;
        }

        public ReviewTemplateAnswerSummary build() {
            return new ReviewTemplateAnswerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewTemplateAnswerSummary> {
        public Builder questionId(String var1);

        public Builder pillarId(String var1);

        public Builder questionTitle(String var1);

        public Builder choices(Collection<Choice> var1);

        public Builder choices(Choice ... var1);

        public Builder choices(Consumer<Choice.Builder> ... var1);

        public Builder selectedChoices(Collection<String> var1);

        public Builder selectedChoices(String ... var1);

        public Builder choiceAnswerSummaries(Collection<ChoiceAnswerSummary> var1);

        public Builder choiceAnswerSummaries(ChoiceAnswerSummary ... var1);

        public Builder choiceAnswerSummaries(Consumer<ChoiceAnswerSummary.Builder> ... var1);

        public Builder isApplicable(Boolean var1);

        public Builder answerStatus(String var1);

        public Builder answerStatus(ReviewTemplateAnswerStatus var1);

        public Builder reason(String var1);

        public Builder reason(AnswerReason var1);

        public Builder questionType(String var1);

        public Builder questionType(QuestionType var1);
    }
}

