/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse;

public class ListAnswersPublisher
implements SdkPublisher<ListAnswersResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListAnswersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnswersPublisher(WellArchitectedAsyncClient client, ListAnswersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnswersPublisher(WellArchitectedAsyncClient client, ListAnswersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnswersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnswersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAnswersResponseFetcher
    implements AsyncPageFetcher<ListAnswersResponse> {
        private ListAnswersResponseFetcher() {
        }

        public boolean hasNextPage(ListAnswersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnswersResponse> nextPage(ListAnswersResponse previousPage) {
            if (previousPage == null) {
                return ListAnswersPublisher.this.client.listAnswers(ListAnswersPublisher.this.firstRequest);
            }
            return ListAnswersPublisher.this.client.listAnswers((ListAnswersRequest)((Object)ListAnswersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

