/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.logger;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.cloudwatchlogs.emf.environment.Environment;
import software.amazon.cloudwatchlogs.emf.environment.EnvironmentProvider;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.model.Unit;
import software.amazon.cloudwatchlogs.emf.sinks.ISink;

public class MetricsLogger {
    private static final Logger log = LoggerFactory.getLogger(MetricsLogger.class);
    private MetricsContext context;
    private CompletableFuture<Environment> environmentFuture;
    private EnvironmentProvider environmentProvider;

    public MetricsLogger() {
        this(new EnvironmentProvider());
    }

    public MetricsLogger(EnvironmentProvider environmentProvider) {
        this(environmentProvider, new MetricsContext());
    }

    public MetricsLogger(EnvironmentProvider environmentProvider, MetricsContext metricsContext) {
        this.context = metricsContext;
        this.environmentFuture = environmentProvider.resolveEnvironment();
        this.environmentProvider = environmentProvider;
    }

    public void flush() {
        Environment environment;
        try {
            environment = this.environmentFuture.join();
        }
        catch (Exception ex) {
            log.info("Failed to resolve environment. Fallback to default environment: ", (Throwable)ex);
            environment = this.environmentProvider.getDefaultEnvironment();
        }
        ISink sink = environment.getSink();
        this.configureContextForEnvironment(this.context, environment);
        sink.accept(this.context);
        this.context = this.context.createCopyWithContext();
    }

    public MetricsLogger putProperty(String key, Object value) {
        this.context.putProperty(key, value);
        return this;
    }

    public MetricsLogger putDimensions(DimensionSet dimensions) {
        this.context.putDimension(dimensions);
        return this;
    }

    public MetricsLogger setDimensions(DimensionSet ... dimensionSets) {
        this.context.setDimensions(dimensionSets);
        return this;
    }

    public MetricsLogger putMetric(String key, double value, Unit unit) {
        this.context.putMetric(key, value, unit);
        return this;
    }

    public MetricsLogger putMetric(String key, double value) {
        this.context.putMetric(key, value, Unit.NONE);
        return this;
    }

    public MetricsLogger putMetadata(String key, Object value) {
        this.context.putMetadata(key, value);
        return this;
    }

    public MetricsLogger setNamespace(String namespace) {
        this.context.setNamespace(namespace);
        return this;
    }

    public MetricsLogger setTimestamp(Instant timestamp) {
        this.context.setTimestamp(timestamp);
        return this;
    }

    private void configureContextForEnvironment(MetricsContext context, Environment environment) {
        if (context.hasDefaultDimensions()) {
            return;
        }
        DimensionSet defaultDimension = new DimensionSet();
        defaultDimension.addDimension("LogGroup", environment.getLogGroupName());
        defaultDimension.addDimension("ServiceName", environment.getName());
        defaultDimension.addDimension("ServiceType", environment.getType());
        context.setDefaultDimensions(defaultDimension);
        environment.configureContext(context);
    }
}

