/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryCompressionFactory;
import com.amazonaws.services.schemaregistry.exception.GlueSchemaRegistryIncompatibleDataException;
import java.nio.ByteBuffer;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlueSchemaRegistryDeserializerDataParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistryDeserializerDataParser.class);
    private GlueSchemaRegistryCompressionFactory compressionFactory;

    private GlueSchemaRegistryDeserializerDataParser(GlueSchemaRegistryCompressionFactory glueSchemaRegistryCompressionFactory) {
        this.compressionFactory = glueSchemaRegistryCompressionFactory;
    }

    public static GlueSchemaRegistryDeserializerDataParser getInstance() {
        return DataParserHelper.INSTANCE;
    }

    public UUID getSchemaVersionId(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        this.validateData(slicedBuffer);
        slicedBuffer.get();
        slicedBuffer.get();
        long mostSigBits = slicedBuffer.getLong();
        long leastSigBits = slicedBuffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public boolean isDataCompatible(ByteBuffer byteBuffer, StringBuilder errorBuilder) {
        byteBuffer.rewind();
        ByteBuffer toValidate = byteBuffer.slice();
        if (toValidate.limit() < 18) {
            String message = String.format("%s size: %d", "Data is not compatible with schema registry", toValidate.limit());
            errorBuilder.append(message);
            log.debug(message);
            return false;
        }
        Byte headerVersionByte = toValidate.get();
        if (!headerVersionByte.equals((byte)3)) {
            String message = "Invalid schema registry header version byte in data";
            errorBuilder.append(message);
            log.debug(message);
            return false;
        }
        Byte compressionByte = toValidate.get();
        if (!compressionByte.equals((byte)5) && !compressionByte.equals((byte)0)) {
            String message = "Invalid schema registry compression byte in data";
            errorBuilder.append(message);
            log.debug(message);
            return false;
        }
        return true;
    }

    public byte[] getPlainData(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        this.validateData(slicedBuffer);
        slicedBuffer.get();
        Byte compressionByte = slicedBuffer.get();
        slicedBuffer.getLong();
        slicedBuffer.getLong();
        byte[] plainData = new byte[slicedBuffer.remaining()];
        slicedBuffer.get(plainData);
        boolean isCompressionEnabled = this.isCompressionByteSet(compressionByte);
        if (!isCompressionEnabled) {
            return plainData;
        }
        int dataStart = this.getSchemaRegistryHeaderLength();
        int dataEnd = slicedBuffer.limit() - dataStart;
        return this.decompressData(compressionByte, slicedBuffer, dataStart, dataEnd);
    }

    private byte[] decompressData(Byte compressionByte, ByteBuffer compressedData, int start, int end) {
        return this.compressionFactory.getCompressionHandler(compressionByte.byteValue()).decompress(compressedData.array(), start, end);
    }

    private void validateData(@NonNull ByteBuffer buffer) throws GlueSchemaRegistryIncompatibleDataException {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked non-null but is null");
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (!this.isDataCompatible(buffer, errorMessageBuilder)) {
            throw new GlueSchemaRegistryIncompatibleDataException(errorMessageBuilder.toString());
        }
    }

    public boolean isCompressionEnabled(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        slicedBuffer.get();
        Byte compressionByte = slicedBuffer.get();
        return this.isCompressionByteSet(compressionByte);
    }

    private boolean isCompressionByteSet(Byte compressionByte) {
        return !compressionByte.equals((byte)0);
    }

    public Byte getCompressionByte(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        slicedBuffer.get();
        return slicedBuffer.get();
    }

    public Byte getHeaderVersionByte(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        return slicedBuffer.get();
    }

    private int getSchemaRegistryHeaderLength() {
        return 18;
    }

    private static class DataParserHelper {
        private static final GlueSchemaRegistryDeserializerDataParser INSTANCE = new GlueSchemaRegistryDeserializerDataParser(new GlueSchemaRegistryCompressionFactory());

        private DataParserHelper() {
        }
    }
}

