/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.json;

import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonValidator {
    public void validateDataWithSchema(JsonNode schemaNode, JsonNode dataNode) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JSONObject rawSchema = new JSONObject(mapper.writeValueAsString((Object)schemaNode));
            Schema schema = SchemaLoader.load((JSONObject)rawSchema, (SchemaClient)new ReferenceDisabledSchemaClient());
            switch (dataNode.getNodeType()) {
                case OBJECT: 
                case POJO: {
                    JSONObject rawObjectJson = new JSONObject(mapper.writeValueAsString((Object)dataNode));
                    schema.validate((Object)rawObjectJson);
                    break;
                }
                case ARRAY: {
                    JSONArray rawArrayJson = new JSONArray(mapper.writeValueAsString((Object)dataNode));
                    schema.validate((Object)rawArrayJson);
                    break;
                }
                case STRING: {
                    schema.validate((Object)dataNode.textValue());
                    break;
                }
                case NUMBER: {
                    schema.validate((Object)dataNode.numberValue());
                    break;
                }
                case NULL: {
                    schema.validate(JSONObject.NULL);
                    break;
                }
                case BOOLEAN: {
                    schema.validate((Object)dataNode.booleanValue());
                    break;
                }
                case BINARY: {
                    schema.validate((Object)dataNode.toString());
                    break;
                }
                default: {
                    throw new AWSSchemaRegistryException("JsonNodeType is unknown or unsupported: " + dataNode.getNodeType());
                }
            }
        }
        catch (Exception e) {
            throw new AWSSchemaRegistryException("JSON data validation against schema failed.", (Throwable)e);
        }
    }

    public class ReferenceDisabledSchemaClient
    implements SchemaClient {
        public InputStream get(String url) {
            throw new ValidationException("Remote or local reference is not allowed: " + url);
        }
    }
}

