/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import java.util.function.Consumer;
import software.xdev.vaadin.maps.leaflet.map.LMap;
import software.xdev.vaadin.maps.leaflet.registry.LComponentManagementRegistry;

@NpmPackage(value="leaflet", version="1.9.4")
@Tag(value="leaflet-map")
@JsModule(value="leaflet/dist/leaflet.js")
@CssImport(value="leaflet/dist/leaflet.css")
public class MapContainer
extends Composite<Div>
implements HasSize,
HasStyle,
HasComponents,
HasText {
    private final LMap lMap;
    private Consumer<LMap> afterInitialResize;

    public MapContainer(LComponentManagementRegistry reg) {
        this(reg, null);
    }

    public MapContainer(LComponentManagementRegistry reg, Consumer<LMap> afterInitialResize) {
        this.afterInitialResize = afterInitialResize;
        ((Div)this.getContent()).setSizeFull();
        this.fixZIndex();
        this.lMap = new LMap(reg, (Div)this.getContent());
        this.fixInitialSizeAfterCreation();
    }

    protected String ensureId() {
        return (String)((Div)this.getContent()).getId().orElseThrow();
    }

    protected void fixZIndex() {
        LMap.fixZIndex((Div)this.getContent());
    }

    protected void fixInitialSizeAfterCreation() {
        this.lMap.fixInvalidSizeAfterCreation(this.afterInitialResize != null ? "document.getElementById('" + this.ensureId() + "').$server.onInitialResize();" : null);
    }

    @ClientCallable
    public void onInitialResize() {
        if (this.afterInitialResize == null) {
            return;
        }
        this.afterInitialResize.accept(this.getlMap());
        this.afterInitialResize = null;
    }

    public LMap getlMap() {
        return this.lMap;
    }
}

