/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet.layer.vector;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.xdev.vaadin.maps.leaflet.base.LBaseComponent;
import software.xdev.vaadin.maps.leaflet.basictypes.LLatLng;
import software.xdev.vaadin.maps.leaflet.layer.vector.LPath;
import software.xdev.vaadin.maps.leaflet.layer.vector.LPolylineOptions;
import software.xdev.vaadin.maps.leaflet.registry.LComponentManagementRegistry;

public class LPolyline
extends LPath<LPolyline> {
    protected LPolyline(LComponentManagementRegistry compReg, String jsConstructorCallExpression, Serializable ... parameters) {
        super(compReg, jsConstructorCallExpression, parameters);
    }

    protected LPolyline(LComponentManagementRegistry compReg, String constructorMethod, Collection<?> latLngs, LPolylineOptions options) {
        super(compReg, constructorMethod + "(" + LPolyline.convertMultiLatLngs(latLngs) + compReg.writeOptionsOptionalParameter(options) + ")", new Serializable[0]);
    }

    public LPolyline(LComponentManagementRegistry compReg, Collection<?> latLngs, LPolylineOptions options) {
        this(compReg, "L.polyline", latLngs, options);
    }

    public LPolyline(LComponentManagementRegistry compReg, Collection<?> latLngs) {
        this(compReg, latLngs, null);
    }

    public LPolyline(LComponentManagementRegistry compReg, LLatLng ... latLngs) {
        this(compReg, List.of(latLngs), null);
    }

    protected static String convertMultiLatLngs(Collection<?> latLngsData) {
        Object peekedElement = latLngsData.stream().findFirst().orElse(null);
        if (peekedElement instanceof LLatLng) {
            return LPolyline.convertLatLngs(latLngsData.stream().filter(LLatLng.class::isInstance).map(LLatLng.class::cast).toList());
        }
        return "[" + latLngsData.stream().filter(Collection.class::isInstance).map(Collection.class::cast).map(c -> {
            if (c.isEmpty()) {
                return "[]";
            }
            return LPolyline.convertMultiLatLngs(c);
        }).collect(Collectors.joining(",")) + "]";
    }

    protected static String convertLatLngs(Collection<LLatLng> latLngs) {
        return "[" + latLngs.stream().map(LBaseComponent::clientComponentJsAccessor).collect(Collectors.joining(",")) + "]";
    }

    public LPolyline setLatLngs(LLatLng ... latLngs) {
        return this.setLatLngs(List.of(latLngs));
    }

    public LPolyline setLatLngs(Collection<LLatLng> latLngs) {
        this.invokeSelf(".setLatLngs([" + latLngs.stream().map(LBaseComponent::clientComponentJsAccessor).collect(Collectors.joining(",")) + "])", new Serializable[0]);
        return (LPolyline)this.self();
    }

    public LPolyline addLatLng(LLatLng latLng, Collection<LLatLng> latLngs) {
        this.invokeSelf(".addLatLng(" + latLng.clientComponentJsAccessor() + (String)(latLngs != null ? "," + LPolyline.convertMultiLatLngs(latLngs) : "") + ")", new Serializable[0]);
        return (LPolyline)this.self();
    }
}

