/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components;

import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.components.AbstractTableViewComponent;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.util.ComponentAddress;

public class TablePages
extends AbstractTableViewComponent {
    private static final int DEFAULT_PAGE_COUNT = 7;
    private IBinding m_objPagesDisplayedBinding = null;
    private int m_nDisplayPage;

    public IBinding getPagesDisplayedBinding() {
        return this.m_objPagesDisplayedBinding;
    }

    public void setPagesDisplayedBinding(IBinding PagesDisplayedBinding) {
        this.m_objPagesDisplayedBinding = PagesDisplayedBinding;
    }

    public int getPagesDisplayed() {
        IBinding objBinding = this.getPagesDisplayedBinding();
        if (objBinding == null || objBinding.getObject() == null) {
            return 7;
        }
        return objBinding.getInt();
    }

    public int getDisplayPage() {
        return this.m_nDisplayPage;
    }

    public void setDisplayPage(int displayPage) {
        this.m_nDisplayPage = displayPage;
    }

    public int getCurrentPage() {
        return this.getTableModelSource().getTableModel().getPagingState().getCurrentPage() + 1;
    }

    public int getPageCount() {
        return this.getTableModelSource().getTableModel().getPageCount();
    }

    public boolean getCondBack() {
        return this.getCurrentPage() > 1;
    }

    public boolean getCondFwd() {
        return this.getCurrentPage() < this.getPageCount();
    }

    public boolean getCondCurrent() {
        return this.getDisplayPage() == this.getCurrentPage();
    }

    public int getStartPage() {
        int nFirstPage;
        int nLeftMargin;
        int nStart;
        int nCurrent = this.getCurrentPage();
        int nPagesDisplayed = this.getPagesDisplayed();
        int nRightMargin = nPagesDisplayed / 2;
        int nStop = nCurrent + nRightMargin;
        int nLastPage = this.getPageCount();
        int nLeftAddon = 0;
        if (nStop > nLastPage) {
            nLeftAddon = nStop - nLastPage;
        }
        if ((nStart = nCurrent - (nLeftMargin = (nPagesDisplayed - 1) / 2 + nLeftAddon)) < (nFirstPage = 1)) {
            nStart = nFirstPage;
        }
        return nStart;
    }

    public int getStopPage() {
        int nLastPage;
        int nRightMargin;
        int nStop;
        int nCurrent = this.getCurrentPage();
        int nPagesDisplayed = this.getPagesDisplayed();
        int nLeftMargin = (nPagesDisplayed - 1) / 2;
        int nStart = nCurrent - nLeftMargin;
        int nFirstPage = 1;
        int nRightAddon = 0;
        if (nStart < nFirstPage) {
            nRightAddon = nFirstPage - nStart;
        }
        if ((nStop = nCurrent + (nRightMargin = nPagesDisplayed / 2 + nRightAddon)) > (nLastPage = this.getPageCount())) {
            nStop = nLastPage;
        }
        return nStop;
    }

    public Integer[] getPageList() {
        int nStart = this.getStartPage();
        int nStop = this.getStopPage();
        Integer[] arrPages = new Integer[nStop - nStart + 1];
        int i = nStart;
        while (i <= nStop) {
            arrPages[i - nStart] = new Integer(i);
            ++i;
        }
        return arrPages;
    }

    public Object[] getFirstPageContext() {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(1)};
    }

    public Object[] getLastPageContext() {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.getPageCount())};
    }

    public Object[] getBackPageContext() {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.getCurrentPage() - 1)};
    }

    public Object[] getFwdPageContext() {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.getCurrentPage() + 1)};
    }

    public Object[] getDisplayPageContext() {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.m_nDisplayPage)};
    }

    public void changePage(IRequestCycle objCycle) {
        Object[] arrParameters = objCycle.getServiceParameters();
        if (arrParameters.length != 2 && !(arrParameters[0] instanceof ComponentAddress) && !(arrParameters[1] instanceof Integer)) {
            return;
        }
        ComponentAddress objAddress = (ComponentAddress)arrParameters[0];
        ITableModelSource objSource = (ITableModelSource)objAddress.findComponent(objCycle);
        this.setCurrentPage(objSource, (Integer)arrParameters[1]);
        objSource.fireObservedStateChange();
    }

    public void setCurrentPage(ITableModelSource objSource, int nPage) {
        objSource.getTableModel().getPagingState().setCurrentPage(nPage - 1);
    }
}

