/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.simple;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.contrib.table.model.common.AbstractTableColumn;
import org.apache.tapestry.contrib.table.model.simple.ITableColumnEvaluator;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnRendererSource;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableValueRendererSource;

public class SimpleTableColumn
extends AbstractTableColumn {
    private String m_strDisplayName;
    private ITableColumnEvaluator m_objEvaluator;

    public SimpleTableColumn(String strColumnName) {
        this(strColumnName, strColumnName);
    }

    public SimpleTableColumn(String strColumnName, boolean bSortable) {
        this(strColumnName, strColumnName, bSortable);
    }

    public SimpleTableColumn(String strColumnName, ITableColumnEvaluator objEvaluator, boolean bSortable) {
        this(strColumnName, strColumnName, objEvaluator, bSortable);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName) {
        this(strColumnName, strDisplayName, false);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName, boolean bSortable) {
        this(strColumnName, strDisplayName, null, bSortable);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName, ITableColumnEvaluator objEvaluator, boolean bSortable) {
        super(strColumnName, bSortable, null);
        this.setComparator(new DefaultComparator());
        this.setDisplayName(strDisplayName);
        this.setColumnRendererSource(new SimpleTableColumnRendererSource());
        this.setValueRendererSource(new SimpleTableValueRendererSource());
        this.setEvaluator(objEvaluator);
    }

    public String getDisplayName() {
        return this.m_strDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.m_strDisplayName = displayName;
    }

    public ITableColumnEvaluator getEvaluator() {
        return this.m_objEvaluator;
    }

    public void setEvaluator(ITableColumnEvaluator evaluator) {
        this.m_objEvaluator = evaluator;
    }

    public Object getColumnValue(Object objRow) {
        ITableColumnEvaluator objEvaluator = this.getEvaluator();
        if (objEvaluator != null) {
            return objEvaluator.getColumnValue(this, objRow);
        }
        return objRow.toString();
    }

    private class DefaultComparator
    implements Comparator,
    Serializable {
        private DefaultComparator() {
        }

        public int compare(Object objRow1, Object objRow2) {
            Object objValue1 = SimpleTableColumn.this.getColumnValue(objRow1);
            Object objValue2 = SimpleTableColumn.this.getColumnValue(objRow2);
            if (!(objValue1 instanceof Comparable) || !(objValue2 instanceof Comparable)) {
                return 0;
            }
            return ((Comparable)objValue1).compareTo(objValue2);
        }
    }
}

