/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.sql;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITablePagingState;
import org.apache.tapestry.contrib.table.model.ITableSortingState;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;
import org.apache.tapestry.contrib.table.model.sql.ISqlTableDataSource;
import org.apache.tapestry.contrib.table.model.sql.ResultSetIterator;
import org.apache.tapestry.contrib.table.model.sql.SqlTableColumnModel;

public class SqlTableModel
implements ITableModel,
Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel == null ? (class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel = SqlTableModel.class$("org.apache.tapestry.contrib.table.model.sql.SqlTableModel")) : class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel));
    private ISqlTableDataSource m_objDataSource;
    private SqlTableColumnModel m_objColumnModel;
    private SimpleTableState m_objTableState;
    static /* synthetic */ Class class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel;

    public SqlTableModel(ISqlTableDataSource objDataSource, SqlTableColumnModel objColumnModel) {
        this(objDataSource, objColumnModel, new SimpleTableState());
    }

    public SqlTableModel(ISqlTableDataSource objDataSource, SqlTableColumnModel objColumnModel, SimpleTableState objState) {
        this.m_objDataSource = objDataSource;
        this.m_objColumnModel = objColumnModel;
        this.m_objTableState = objState;
    }

    public ITableColumnModel getColumnModel() {
        return this.m_objColumnModel;
    }

    public SqlTableColumnModel getSqlColumnModel() {
        return this.m_objColumnModel;
    }

    public Iterator getCurrentPageRows() {
        try {
            ResultSet objResultSet = this.getSqlDataSource().getCurrentRows(this.getSqlColumnModel(), this.getState());
            return new ResultSetIterator(objResultSet){

                protected void notifyEnd() {
                    SqlTableModel.this.getSqlDataSource().closeResultSet(this.getResultSet());
                }
            };
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot get current page rows", (Throwable)e);
            return new ResultSetIterator(null);
        }
    }

    public int getPageCount() {
        try {
            int nPageCount = (this.m_objDataSource.getRowCount() - 1) / this.getPagingState().getPageSize() + 1;
            if (nPageCount < 1) {
                nPageCount = 1;
            }
            return nPageCount;
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot get row count", (Throwable)e);
            return 1;
        }
    }

    public ITablePagingState getPagingState() {
        return this.getState().getPagingState();
    }

    public ITableSortingState getSortingState() {
        return this.getState().getSortingState();
    }

    public SimpleTableState getState() {
        return this.m_objTableState;
    }

    public ISqlTableDataSource getSqlDataSource() {
        return this.m_objDataSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

