/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.link;

import org.apache.hivemind.HiveMind;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.link.DefaultLinkRenderer;

public class PopupLinkRenderer
extends DefaultLinkRenderer {
    private String _windowName;
    private String _features;
    private static final String QUOTE = "\"";

    public PopupLinkRenderer() {
    }

    public PopupLinkRenderer(String windowName, String features) {
        this._windowName = windowName;
        this._features = features;
    }

    protected String constructURL(ILink link, String anchor, IRequestCycle cycle) {
        String url = link.getURL(anchor, true);
        PageRenderSupport support = (PageRenderSupport)cycle.getAttribute("org.apache.tapestry.PageRenderSupport");
        String functionName = support.getUniqueString("popup_window");
        BodyBuilder builder = new BodyBuilder();
        builder.addln("function {0}()", (Object)functionName);
        builder.begin();
        builder.addln("var newWindow = window.open({0}, {1}, {2});", (Object)PopupLinkRenderer.normalizeString(url), (Object)PopupLinkRenderer.normalizeString(this.getWindowName()), (Object)PopupLinkRenderer.normalizeString(this.getFeatures()));
        builder.addln("newWindow.focus();");
        builder.end();
        support.addBodyScript(builder.toString());
        return "javascript:" + functionName + "();";
    }

    static String normalizeString(String str) {
        if (HiveMind.isBlank((String)str)) {
            return "\"\"";
        }
        int length = str.length();
        StringBuffer buffer = new StringBuffer(length + 2);
        buffer.append(QUOTE);
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\"' || ch == '\\') {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        buffer.append(QUOTE);
        return buffer.toString();
    }

    public String getWindowName() {
        return this._windowName;
    }

    public void setWindowName(String windowName) {
        this._windowName = windowName;
    }

    public String getFeatures() {
        return this._features;
    }

    public void setFeatures(String features) {
        this._features = features;
    }
}

