/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FieldInfo
extends ClassFileStruct
implements AttributeNamesConstants,
IBinaryField,
Comparable,
TypeIds {
    private Constant constant;
    private boolean isDeprecated;
    private boolean isSynthetic;
    private int[] constantPoolOffsets;
    private int accessFlags;
    private char[] name;
    private char[] signature;
    private int attributeBytes;
    private Object wrappedConstantValue;

    public FieldInfo(byte[] classFileBytes, int[] offsets, int offset) {
        super(classFileBytes, offset);
        this.constantPoolOffsets = offsets;
        this.accessFlags = -1;
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public Constant getConstant() {
        if (this.constant == null) {
            this.readConstantAttribute();
        }
        return this.constant;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readDeprecatedAndSyntheticAttributes();
            if (this.isDeprecated) {
                this.accessFlags |= 0x100000;
            }
            if (this.isSynthetic) {
                this.accessFlags |= 0x1000;
            }
        }
        return this.accessFlags;
    }

    public char[] getName() {
        if (this.name == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.name = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.name;
    }

    public char[] getTypeName() {
        if (this.signature == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(4)] - this.structOffset;
            this.signature = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.signature;
    }

    public Object getWrappedConstantValue() {
        if (this.wrappedConstantValue == null && this.hasConstant()) {
            Constant fieldConstant = this.getConstant();
            switch (fieldConstant.typeID()) {
                case 10: {
                    this.wrappedConstantValue = new Integer(fieldConstant.intValue());
                    break;
                }
                case 3: {
                    this.wrappedConstantValue = new Byte(fieldConstant.byteValue());
                    break;
                }
                case 4: {
                    this.wrappedConstantValue = new Short(fieldConstant.shortValue());
                    break;
                }
                case 2: {
                    this.wrappedConstantValue = new Character(fieldConstant.charValue());
                    break;
                }
                case 9: {
                    this.wrappedConstantValue = new Float(fieldConstant.floatValue());
                    break;
                }
                case 8: {
                    this.wrappedConstantValue = new Double(fieldConstant.doubleValue());
                    break;
                }
                case 5: {
                    this.wrappedConstantValue = Util.toBoolean(fieldConstant.booleanValue());
                    break;
                }
                case 7: {
                    this.wrappedConstantValue = new Long(fieldConstant.longValue());
                    break;
                }
                case 11: {
                    this.wrappedConstantValue = fieldConstant.stringValue();
                }
            }
        }
        return this.wrappedConstantValue;
    }

    public boolean hasConstant() {
        return this.getConstant() != Constant.NotAConstant;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private void readConstantAttribute() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        boolean isConstant = false;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (CharOperation.equals(attributeName, AttributeNamesConstants.ConstantValueName)) {
                isConstant = true;
                int relativeOffset = this.constantPoolOffsets[this.u2At(readOffset + 6)] - this.structOffset;
                block0 : switch (this.u1At(relativeOffset)) {
                    case 3: {
                        char[] sign = this.getTypeName();
                        if (sign.length == 1) {
                            switch (sign[0]) {
                                case 'Z': {
                                    this.constant = new BooleanConstant(this.i4At(relativeOffset + 1) == 1);
                                    break block0;
                                }
                                case 'I': {
                                    this.constant = new IntConstant(this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                                case 'C': {
                                    this.constant = new CharConstant((char)this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                                case 'B': {
                                    this.constant = new ByteConstant((byte)this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                                case 'S': {
                                    this.constant = new ShortConstant((short)this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                            }
                            this.constant = Constant.NotAConstant;
                            break;
                        }
                        this.constant = Constant.NotAConstant;
                        break;
                    }
                    case 4: {
                        this.constant = new FloatConstant(this.floatAt(relativeOffset + 1));
                        break;
                    }
                    case 6: {
                        this.constant = new DoubleConstant(this.doubleAt(relativeOffset + 1));
                        break;
                    }
                    case 5: {
                        this.constant = new LongConstant(this.i8At(relativeOffset + 1));
                        break;
                    }
                    case 8: {
                        utf8Offset = this.constantPoolOffsets[this.u2At(relativeOffset + 1)] - this.structOffset;
                        this.constant = new StringConstant(String.valueOf(this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1))));
                    }
                }
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
        if (!isConstant) {
            this.constant = Constant.NotAConstant;
        }
    }

    private void readDeprecatedAndSyntheticAttributes() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (CharOperation.equals(attributeName, AttributeNamesConstants.DeprecatedName)) {
                this.isDeprecated = true;
            } else if (CharOperation.equals(attributeName, AttributeNamesConstants.SyntheticName)) {
                this.isSynthetic = true;
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public void throwFormatException() throws ClassFormatException {
        throw new ClassFormatException(17);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        int modifiers = this.getModifiers();
        return buffer.append("{").append(String.valueOf((modifiers & 0x100000) != 0 ? "deprecated " : "") + ((modifiers & 1) == 1 ? "public " : "") + ((modifiers & 2) == 2 ? "private " : "") + ((modifiers & 4) == 4 ? "protected " : "") + ((modifiers & 8) == 8 ? "static " : "") + ((modifiers & 0x10) == 16 ? "final " : "") + ((modifiers & 0x40) == 64 ? "volatile " : "") + ((modifiers & 0x80) == 128 ? "transient " : "")).append(this.getTypeName()).append(" ").append(this.getName()).append(" ").append(this.getConstant()).append("}").toString();
    }

    public int compareTo(Object o) {
        if (!(o instanceof FieldInfo)) {
            throw new ClassCastException();
        }
        return new String(this.getName()).compareTo(new String(((FieldInfo)o).getName()));
    }

    void initialize() {
        this.getModifiers();
        this.getName();
        this.getConstant();
        this.getTypeName();
        this.reset();
    }

    protected void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }
}

