/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public class UriTemplate {
    private static final Pattern URI_NO_ESCAPE = Pattern.compile("\\{uri\\}", 2);
    private static final Pattern URI_ESCAPE = Pattern.compile("\\{%uri\\}", 2);
    private final String template;

    public UriTemplate(String template) {
        this.template = template.trim();
    }

    public URI map(URI uri) {
        String encodedUri;
        try {
            encodedUri = URLEncoder.encode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("could not encode URI " + uri.toASCIIString(), e);
        }
        String uriMap = this.template;
        uriMap = URI_ESCAPE.matcher(uriMap).replaceAll(encodedUri);
        uriMap = URI_NO_ESCAPE.matcher(uriMap).replaceAll(uri.toString());
        return URI.create(uriMap);
    }
}

