/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.hybrid;

import com.google.step2.hybrid.HybridOauthRequest;
import com.google.step2.hybrid.HybridOauthResponse;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.MessageExtensionFactory;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;

public class HybridOauthMessage
implements MessageExtension,
MessageExtensionFactory {
    protected ParameterList parameters = new ParameterList();
    public static final String OPENID_NS_OAUTH = "http://specs.openid.net/extensions/oauth/1.0";
    static final String SCOPE = "scope";
    static final String OAUTH_TOKEN = "request_token";
    private static Log log = LogFactory.getLog(HybridOauthMessage.class);

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        if (isRequest) {
            return new HybridOauthRequest(parameterList);
        }
        return new HybridOauthResponse(parameterList);
    }

    public String getParameter(String name) {
        return this.parameters.getParameterValue(name);
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public String getTypeUri() {
        return OPENID_NS_OAUTH;
    }

    public boolean providesIdentifier() {
        return false;
    }

    public void setParameters(ParameterList params) {
        this.parameters = params;
    }

    public boolean signRequired() {
        return true;
    }

    protected boolean isValid(List<String> requiredFields, List<String> optionalFields) {
        for (String required : requiredFields) {
            if (this.parameters.hasParameter(required)) continue;
            return false;
        }
        List params = this.parameters.getParameters();
        for (Parameter p : params) {
            if (requiredFields.contains(p.getKey()) || optionalFields.contains(p.getKey())) continue;
            return false;
        }
        return true;
    }

    public String getScope() {
        return this.parameters.getParameterValue(SCOPE);
    }
}

