/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.xmlsimplesign;

import com.google.step2.util.EncodingUtil;
import com.google.step2.util.Preconditions;
import com.google.step2.util.RandUtil;
import com.google.step2.util.XmlUtil;
import com.google.step2.xmlsimplesign.Constants;
import com.google.step2.xmlsimplesign.SignatureResult;
import com.google.step2.xmlsimplesign.XmlSimpleSignException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Signer {
    private byte[] document;
    private PrivateKey privateKey;
    private X509Certificate signingCert;
    private List<X509Certificate> certificateChain = new ArrayList<X509Certificate>();
    private String signatureFilePrefix;

    public Signer setDocument(byte[] document) {
        this.document = document;
        return this;
    }

    public Signer setSigningKey(X509Certificate signingCert, PrivateKey privateKey) {
        this.signingCert = signingCert;
        this.privateKey = privateKey;
        return this;
    }

    public Signer setSignatureFilePrefix(String signatureFilePrefix) {
        this.signatureFilePrefix = signatureFilePrefix;
        return this;
    }

    public Signer addIntermediateCert(X509Certificate intermediate) {
        this.certificateChain.add(intermediate);
        return this;
    }

    public SignatureResult sign() throws XmlSimpleSignException {
        Preconditions.checkNotNull(this.document);
        Preconditions.checkNotNull(this.signingCert);
        Preconditions.checkNotNull(this.certificateChain);
        try {
            String signatureLocation = this.signatureFilePrefix == null ? null : this.signatureFilePrefix + RandUtil.getRandomString(8);
            Document xml = XmlUtil.getJdomDocument(new ByteArrayInputStream(this.document));
            xml.getRootElement().addContent(0, (Content)this.createSignatureElement(signatureLocation));
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            String textDoc = outputter.outputString(xml);
            byte[] docBytes = EncodingUtil.getUtf8Bytes(textDoc);
            String sig = this.signDoc(docBytes);
            return new SignatureResult(docBytes, signatureLocation, sig);
        }
        catch (JDOMException e) {
            throw new XmlSimpleSignException("Can't parse input XML", e);
        }
        catch (IOException e) {
            throw new XmlSimpleSignException("Can't parse input XML", e);
        }
        catch (GeneralSecurityException e) {
            throw new XmlSimpleSignException("Can't sign document", e);
        }
    }

    private Element createSignatureElement(String location) throws GeneralSecurityException {
        Element sig = new Element("Signature", Constants.XML_DSIG_NS);
        Element signedInfo = this.dsigElement("SignedInfo");
        Element c14n = this.dsigElement("CanonicalizationMethod");
        c14n.setAttribute("Algorithm", "http://docs.oasis-open.org/xri/xrd/2009/01#canonicalize-raw-octets");
        Element signatureMethod = this.dsigElement("SignatureMethod");
        signatureMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Element signatureLocation = null;
        if (location != null) {
            signatureLocation = this.simpleSigElement("SignatureLocation");
            signatureLocation.setText(location);
        }
        Element keyInfo = this.dsigElement("KeyInfo");
        Element x509Data = this.dsigElement("X509Data");
        x509Data.addContent((Content)this.certificateElement(this.signingCert));
        for (X509Certificate cert : this.certificateChain) {
            x509Data.addContent((Content)this.certificateElement(cert));
        }
        sig.addContent((Content)signedInfo);
        signedInfo.addContent((Content)c14n);
        signedInfo.addContent((Content)signatureMethod);
        if (signatureLocation != null) {
            sig.addContent((Content)signatureLocation);
        }
        sig.addContent((Content)keyInfo);
        keyInfo.addContent((Content)x509Data);
        return sig;
    }

    private Element certificateElement(X509Certificate cert) throws GeneralSecurityException {
        Element e = this.dsigElement("X509Certificate");
        e.setText(this.getCertAsString(cert));
        return e;
    }

    private String getCertAsString(X509Certificate cert) throws GeneralSecurityException {
        byte[] der = cert.getEncoded();
        return EncodingUtil.encodeBase64(der);
    }

    private String signDoc(byte[] docBytes) throws GeneralSecurityException {
        Signature signer = Signature.getInstance("SHA1withRSA");
        signer.initSign(this.privateKey);
        signer.update(docBytes);
        return EncodingUtil.encodeBase64(signer.sign());
    }

    private Element dsigElement(String name) {
        return new Element(name, Constants.XML_DSIG_NS);
    }

    private Element simpleSigElement(String name) {
        return new Element(name, Constants.SIMPLE_SIGN_NS);
    }
}

