/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepHandler;
import com.tonicsystems.jarjar.NullClassVisitor;
import com.tonicsystems.jarjar.NullMethodVisitor;
import com.tonicsystems.jarjar.NullSignatureVisitor;
import com.tonicsystems.jarjar.PathClass;
import com.tonicsystems.jarjar.WrappedIOException;
import com.tonicsystems.jarjar.asm.FieldVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.MethodVisitor;
import com.tonicsystems.jarjar.asm.Type;
import com.tonicsystems.jarjar.asm.signature.SignatureReader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;

class DepFindVisitor
extends NullClassVisitor {
    private Map classes;
    private String source;
    private String curName;
    private MethodVisitor code = new DepFindMethodVisitor();
    private DepHandler handler;
    private PathClass curPathClass;

    public DepFindVisitor(Map classes, Object source, DepHandler handler) throws IOException {
        this.classes = classes;
        this.source = this.getSourceName(source);
        this.handler = handler;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.curName = name;
        this.curPathClass = new PathClass(this.source, this.curName);
        this.checkSignature(signature, false);
        this.checkName(superName);
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.checkName(interfaces[i]);
            }
        }
    }

    private void checkSignature(String signature, boolean type) {
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            SignatureChecker checker = new SignatureChecker();
            if (type) {
                reader.acceptType(checker);
            } else {
                reader.accept(checker);
            }
        }
    }

    private void checkDesc(String desc) {
        int index = desc.indexOf(76);
        if (index >= 0) {
            this.checkName(desc.substring(index + 1, desc.length() - 1));
        }
    }

    private void checkMethodDesc(String methodDesc) {
        this.checkDesc(Type.getReturnType(methodDesc).getDescriptor());
        Type[] args = Type.getArgumentTypes(methodDesc);
        for (int i = 0; i < args.length; ++i) {
            this.checkDesc(args[i].getDescriptor());
        }
    }

    private String getSourceName(Object source) throws IOException {
        if (source instanceof ZipFile) {
            return ((ZipFile)source).getName();
        }
        return ((File)source).getCanonicalPath();
    }

    private void checkName(String name) {
        try {
            String otherSource;
            if (this.classes.containsKey(name) && !this.source.equals(otherSource = this.getSourceName(this.classes.get(name)))) {
                this.handler.handle(this.curPathClass, new PathClass(otherSource, name));
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.checkMethodDesc(desc);
        this.checkSignature(signature, false);
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                this.checkName(exceptions[i]);
            }
        }
        return this.code;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.checkDesc(desc);
        this.checkSignature(signature, true);
        return null;
    }

    private class DepFindMethodVisitor
    extends NullMethodVisitor {
        private DepFindMethodVisitor() {
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (desc.charAt(0) == '[') {
                DepFindVisitor.this.checkDesc(desc);
            } else {
                DepFindVisitor.this.checkName(desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DepFindVisitor.this.checkName(owner);
            DepFindVisitor.this.checkDesc(desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            DepFindVisitor.this.checkName(owner);
            DepFindVisitor.this.checkMethodDesc(desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            DepFindVisitor.this.checkDesc(desc);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            DepFindVisitor.this.checkName(type);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            DepFindVisitor.this.checkDesc(desc);
            DepFindVisitor.this.checkSignature(signature, true);
        }
    }

    private class SignatureChecker
    extends NullSignatureVisitor {
        private SignatureChecker() {
        }

        public void visitTypeVariable(String name) {
            DepFindVisitor.this.checkName(name);
        }

        public void visitClassType(String name) {
            DepFindVisitor.this.checkName(name);
        }

        public void visitInnerClassType(String name) {
            DepFindVisitor.this.checkName(name);
        }
    }
}

