/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.apache.cassandra.auth.Action;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthority;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.ConfigurationException;

public class SimpleAuthority
implements IAuthority {
    public static final String ACCESS_FILENAME_PROPERTY = "access.properties";
    public static final String KEYSPACES_WRITE_PROPERTY = "<modify-keyspaces>";
    private Properties accessProperties = null;

    @Override
    public EnumSet<Permission> authorize(AuthenticatedUser user, List<Object> resource, Action action) {
        String keyspace;
        if (resource.size() < 2 || !"cassandra".equals(resource.get(0)) || !"keyspaces".equals(resource.get(1))) {
            return Permission.NONE;
        }
        String columnFamily = null;
        EnumSet<Permission> authorized = Permission.NONE;
        if (resource.size() == 2) {
            keyspace = KEYSPACES_WRITE_PROPERTY;
            authorized = EnumSet.of(Permission.READ);
        } else if (resource.size() == 3) {
            keyspace = (String)resource.get(2);
        } else if (resource.size() == 4) {
            keyspace = (String)resource.get(2);
            columnFamily = (String)resource.get(3);
        } else {
            throw new UnsupportedOperationException();
        }
        String accessFilename = System.getProperty(ACCESS_FILENAME_PROPERTY);
        try {
            if (this.accessProperties == null) {
                FileInputStream in = new FileInputStream(accessFilename);
                this.accessProperties = new Properties();
                this.accessProperties.load(in);
                in.close();
            }
            if (keyspace == KEYSPACES_WRITE_PROPERTY) {
                String kspAdmins = this.accessProperties.getProperty(KEYSPACES_WRITE_PROPERTY);
                for (String admin : kspAdmins.split(",")) {
                    if (!admin.equals(user.username)) continue;
                    return Permission.ALL;
                }
            }
            boolean canRead = false;
            boolean canWrite = false;
            String readers = null;
            String writers = null;
            if (columnFamily == null) {
                readers = this.accessProperties.getProperty(keyspace + ".<ro>");
                writers = this.accessProperties.getProperty(keyspace + ".<rw>");
            } else {
                readers = this.accessProperties.getProperty(keyspace + "." + columnFamily + ".<ro>");
                writers = this.accessProperties.getProperty(keyspace + "." + columnFamily + ".<rw>");
            }
            if (readers != null) {
                for (String reader : readers.split(",")) {
                    if (!reader.equals(user.username)) continue;
                    canRead = true;
                    break;
                }
            }
            if (writers != null) {
                for (String writer : writers.split(",")) {
                    if (!writer.equals(user.username)) continue;
                    canWrite = true;
                    break;
                }
            }
            if (canWrite) {
                authorized = Permission.ALL;
            } else if (canRead) {
                authorized = EnumSet.of(Permission.READ);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Authorization table file '%s' could not be opened: %s", accessFilename, e.getMessage()));
        }
        return authorized;
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
        String afilename = System.getProperty(ACCESS_FILENAME_PROPERTY);
        if (afilename == null) {
            throw new ConfigurationException(String.format("When using %s, '%s' property must be defined.", this.getClass().getCanonicalName(), ACCESS_FILENAME_PROPERTY));
        }
    }
}

