/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class AsciiType
extends BytesType {
    public static final AsciiType instance = new AsciiType();

    AsciiType() {
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.string(bytes, Charsets.US_ASCII);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return ByteBuffer.wrap(source.getBytes(Charsets.US_ASCII));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        for (int i = 0; i < bytes.remaining(); ++i) {
            byte b = bytes.array()[bytes.arrayOffset() + bytes.position() + i];
            if (b >= 0 && b <= 127) continue;
            throw new MarshalException("Invalid byte for ascii: " + Byte.toString(b));
        }
    }
}

