/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Mx4jTool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraDaemon
implements CassandraDaemon {
    private static Logger logger = LoggerFactory.getLogger(AbstractCassandraDaemon.class);
    protected InetAddress listenAddr;
    protected int listenPort;
    public static final int MIN_WORKER_THREADS = 64;

    protected void setup() throws IOException {
        logger.info("Heap size: {}/{}", (Object)Runtime.getRuntime().totalMemory(), (Object)Runtime.getRuntime().maxMemory());
        CLibrary.tryMlockall();
        this.listenPort = DatabaseDescriptor.getRpcPort();
        this.listenAddr = DatabaseDescriptor.getRpcAddress();
        if (this.listenAddr == null) {
            this.listenAddr = FBUtilities.getLocalAddress();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error("Fatal exception in thread " + t, e);
                if (e instanceof OutOfMemoryError) {
                    System.exit(100);
                }
            }
        });
        for (CFMetaData cfm : DatabaseDescriptor.getTableMetaData("system").values()) {
            ColumnFamilyStore.scrubDataDirectories("system", cfm.cfName);
        }
        try {
            SystemTable.checkHealth();
        }
        catch (ConfigurationException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        try {
            DatabaseDescriptor.loadSchemas();
        }
        catch (IOException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        for (String table : DatabaseDescriptor.getTables()) {
            for (CFMetaData cfm : DatabaseDescriptor.getTableMetaData(table).values()) {
                ColumnFamilyStore.scrubDataDirectories(table, cfm.cfName);
            }
        }
        for (String table : DatabaseDescriptor.getTables()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace " + table);
            }
            Table.open(table);
        }
        CommitLog.recover();
        CompactionManager.instance.checkAllColumnFamilies();
        UUID currentMigration = DatabaseDescriptor.getDefsVersion();
        UUID lastMigration = Migration.getLastMigrationId();
        if (lastMigration != null && lastMigration.timestamp() > currentMigration.timestamp()) {
            MigrationManager.applyMigrations(currentMigration, lastMigration);
        }
        SystemTable.purgeIncompatibleHints();
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException e) {
            logger.error("Fatal error: " + e.getMessage());
            System.err.println("Bad configuration; unable to start server");
            System.exit(1);
        }
        Mx4jTool.maybeLoad();
    }

    @Override
    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    @Override
    public abstract void start() throws IOException;

    @Override
    public abstract void stop();

    @Override
    public void destroy() {
    }

    @Override
    public void activate() {
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            this.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
        }
        catch (Throwable e) {
            String msg = "Exception encountered during startup.";
            logger.error(msg, e);
            System.out.println(msg);
            e.printStackTrace();
            System.exit(3);
        }
    }

    @Override
    public void deactivate() {
        this.stop();
        this.destroy();
    }

    public static class CleaningThreadPool
    extends ThreadPoolExecutor
    implements ThreadPool {
        private ThreadLocal<ClientState> state;

        public CleaningThreadPool(ThreadLocal<ClientState> state, int minWorkerThread, int maxWorkerThreads) {
            super(minWorkerThread, maxWorkerThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.state = state;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.state.get().logout();
        }

        public boolean dispatch(Runnable job) {
            try {
                this.execute(job);
                return true;
            }
            catch (RejectedExecutionException e) {
                logger.error("Failed to dispatch thread:", (Throwable)e);
                return false;
            }
        }

        public int getIdleThreads() {
            return this.getPoolSize() - this.getActiveCount();
        }

        public int getThreads() {
            return this.getPoolSize();
        }

        public boolean isLowOnThreads() {
            return this.getActiveCount() >= this.getMaximumPoolSize();
        }

        public void join() throws InterruptedException {
            this.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
    }
}

