/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.Action;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static Logger logger = LoggerFactory.getLogger(ClientState.class);
    private AuthenticatedUser user;
    private String keyspace;
    private String qualifiedKeyspace;
    private String prefix;
    private final List<Object> resource = new ArrayList<Object>();

    public ClientState() {
        this.reset();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String ks) {
        this.keyspace = ks;
        this.setQualifiedKeyspace();
    }

    public String getSchedulingValue() {
        switch (DatabaseDescriptor.getRequestSchedulerId()) {
            case keyspace: {
                return this.keyspace;
            }
        }
        return "default";
    }

    public void login(Map<? extends CharSequence, ? extends CharSequence> credentials) throws AuthenticationException {
        AuthenticatedUser user = DatabaseDescriptor.getAuthenticator().authenticate(credentials);
        if (logger.isDebugEnabled()) {
            logger.debug("logged in: {}", (Object)user);
        }
        this.user = user;
        this.setQualifiedKeyspace();
    }

    public void logout() {
        if (logger.isDebugEnabled()) {
            logger.debug("logged out: {}", (Object)this.user);
        }
        this.reset();
    }

    private void resourceClear() {
        this.resource.clear();
        this.resource.add("cassandra");
        this.resource.add("keyspaces");
    }

    public void reset() {
        this.user = DatabaseDescriptor.getAuthenticator().defaultUser();
        this.keyspace = null;
        this.qualifiedKeyspace = null;
        this.prefix = null;
        this.resourceClear();
    }

    public void hasKeyspaceListAccess(Permission perm, Action action) throws InvalidRequestException {
        this.validateLogin();
        this.resourceClear();
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource, action);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public void hasColumnFamilyListAccess(Permission perm, Action action) throws InvalidRequestException {
        this.validateLogin();
        this.validateKeyspace();
        this.resourceClear();
        this.resource.add(this.keyspace);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource, action);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public void hasColumnFamilyAccess(String columnFamily, Permission perm, Action action) throws InvalidRequestException {
        this.validateLogin();
        this.validateKeyspace();
        this.resourceClear();
        this.resource.add(this.keyspace);
        this.resource.add(columnFamily);
        EnumSet<Permission> perms = DatabaseDescriptor.getAuthority().authorize(this.user, this.resource, action);
        ClientState.hasAccess(this.user, perms, perm, this.resource);
    }

    public String getResolvedKeyspace() {
        return this.qualifiedKeyspace == null ? this.keyspace : this.qualifiedKeyspace;
    }

    public String resolveKeyspace(String keyspaceTobeResolved) {
        return this.prefix == null || keyspaceTobeResolved.startsWith(this.prefix) ? keyspaceTobeResolved : this.prefix + keyspaceTobeResolved;
    }

    public String getDomainNameLessKeyspace(String keyspaceWithDomainName) {
        return this.prefix == null || !keyspaceWithDomainName.startsWith(this.prefix) ? keyspaceWithDomainName : keyspaceWithDomainName.substring(this.prefix.length());
    }

    private void validateLogin() throws InvalidRequestException {
        if (this.user == null) {
            throw new InvalidRequestException("You have not logged in");
        }
    }

    private void validateKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    private static void hasAccess(AuthenticatedUser user, Set<Permission> perms, Permission perm, List<Object> resource) throws InvalidRequestException {
        if (perms.contains((Object)perm)) {
            return;
        }
        throw new InvalidRequestException(String.format("%s does not have permission %s for %s", new Object[]{user, perm, Resources.toString(resource)}));
    }

    private void setQualifiedKeyspace() {
        if (this.user != null && this.user.domainName != null) {
            if (this.prefix == null) {
                this.prefix = this.user.domainName + "_";
                this.prefix = this.prefix.replace(".", "_");
            }
            if (this.keyspace != null) {
                this.qualifiedKeyspace = this.prefix + this.keyspace;
            }
        }
    }
}

