/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationManager
implements IEndpointStateChangeSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(MigrationManager.class);

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (state != ApplicationState.SCHEMA) {
            return;
        }
        UUID theirVersion = UUID.fromString(value.value);
        MigrationManager.rectify(theirVersion, endpoint);
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
        VersionedValue value = state.getApplicationState(ApplicationState.SCHEMA);
        if (value != null) {
            UUID theirVersion = UUID.fromString(value.value);
            MigrationManager.rectify(theirVersion, endpoint);
        }
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
    }

    public static void rectify(UUID theirVersion, InetAddress endpoint) {
        UUID myVersion = DatabaseDescriptor.getDefsVersion();
        if (theirVersion.timestamp() == myVersion.timestamp()) {
            return;
        }
        if (theirVersion.timestamp() > myVersion.timestamp()) {
            logger.debug("My data definitions are old. Asking for updates since {}", (Object)myVersion.toString());
            MigrationManager.announce(myVersion, Collections.singleton(endpoint));
        } else {
            logger.debug("Their data definitions are old. Sending updates since {}", (Object)theirVersion.toString());
            MigrationManager.pushMigrations(theirVersion, myVersion, endpoint);
        }
    }

    public static void announce(UUID version, Set<InetAddress> hosts) {
        Message msg = MigrationManager.makeVersionMessage(version);
        for (InetAddress host : hosts) {
            MessagingService.instance.sendOneWay(msg, host);
        }
        if (!StorageService.instance.isClientMode()) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.SCHEMA, StorageService.valueFactory.migration(version));
        }
    }

    public static void applyMigrations(UUID from, UUID to) throws IOException {
        ArrayList updates = new ArrayList();
        Collection<IColumn> migrations = Migration.getLocalMigrations(from, to);
        for (IColumn iColumn : migrations) {
            final Migration migration = Migration.deserialize(iColumn.value());
            Future<?> update = StageManager.getStage(Stage.MIGRATION).submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        migration.apply();
                    }
                    catch (ConfigurationException ex) {
                        logger.debug("Migration not applied " + ex.getMessage());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            updates.add(update);
        }
        for (Future future : updates) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    public static void pushMigrations(UUID from, UUID to, InetAddress host) {
        Collection<IColumn> migrations = Migration.getLocalMigrations(from, to);
        try {
            Message msg = MigrationManager.makeMigrationMessage(migrations);
            MessagingService.instance.sendOneWay(msg, host);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    private static Message makeVersionMessage(UUID version) {
        byte[] body = version.toString().getBytes();
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.DEFINITIONS_ANNOUNCE, body);
    }

    private static Message makeMigrationMessage(Collection<IColumn> migrations) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(migrations.size());
        for (IColumn col : migrations) {
            assert (col instanceof Column);
            dout.writeInt(col.name().remaining());
            dout.write(col.name().array(), col.name().position() + col.name().arrayOffset(), col.name().remaining());
            dout.writeInt(col.value().remaining());
            dout.write(col.value().array(), col.value().position() + col.value().arrayOffset(), col.value().remaining());
        }
        dout.close();
        byte[] body = bout.toByteArray();
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.DEFINITIONS_UPDATE_RESPONSE, body);
    }

    public static Collection<Column> makeColumns(Message msg) throws IOException {
        ArrayList<Column> cols = new ArrayList<Column>();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(msg.getMessageBody()));
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            byte[] name = new byte[in.readInt()];
            in.readFully(name);
            byte[] value = new byte[in.readInt()];
            in.readFully(value);
            cols.add(new Column(ByteBuffer.wrap(name), ByteBuffer.wrap(value)));
        }
        in.close();
        return cols;
    }
}

