/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.vfs2.RandomAccessContent;

public class RACRandomAccessFile
extends RandomAccessFile
implements RandomAccessContent {
    private RandomAccessContent rac;
    protected final byte[] singleByteBuf = new byte[1];

    private static File createTempFile() throws IOException {
        return File.createTempFile("fraf", "");
    }

    private void deleteTempFile(File tempFile) {
        try {
            super.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            tempFile.delete();
        }
    }

    public RACRandomAccessFile(RandomAccessContent rac) throws IOException {
        this(RACRandomAccessFile.createTempFile());
        this.rac = rac;
    }

    private RACRandomAccessFile(File tempFile) throws IOException {
        super(tempFile, "r");
        this.deleteTempFile(tempFile);
    }

    public long getFilePointer() throws IOException {
        return this.rac.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.rac.seek(pos);
    }

    public int skipBytes(int n) throws IOException {
        return this.rac.skipBytes(n);
    }

    public long length() throws IOException {
        return this.rac.length();
    }

    public void setLength(long newLength) throws IOException {
        throw new IOException("Underlying RandomAccessContent instance length cannot be modified.");
    }

    public InputStream getInputStream() throws IOException {
        return this.rac.getInputStream();
    }

    public void close() throws IOException {
        this.rac.close();
    }

    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final int read() throws IOException {
        byte[] buf = this.singleByteBuf;
        int count = this.read(buf, 0, 1);
        return count < 0 ? -1 : buf[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.rac.readFully(b, off, len);
        return len;
    }

    public final void write(int b) throws IOException {
        byte[] buf = this.singleByteBuf;
        buf[0] = (byte)b;
        this.write(buf, 0, 1);
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.rac.write(b, off, len);
    }
}

