/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.impl;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.context.BasicAttributeContext;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.preparer.NoSuchPreparerException;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.preparer.ViewPreparer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTilesContainer
implements TilesContainer {
    public static final String DEFINITIONS_CONFIG = "org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG";
    private static final String LEGACY_DEFINITIONS_CONFIG = "definitions-config";
    private static final Log LOG = LogFactory.getLog(BasicTilesContainer.class);
    private TilesApplicationContext context;
    private DefinitionsFactory definitionsFactory;
    private PreparerFactory preparerFactory;
    private TilesContextFactory contextFactory;
    private boolean initialized = false;

    @Override
    public void init(Map<String, String> initParameters) throws TilesException {
        this.checkInit();
        this.initialized = true;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Initializing Tiles2 container. . .");
        }
        this.initializeDefinitionsFactory(this.definitionsFactory, this.getResourceString(), initParameters);
    }

    @Override
    public AttributeContext startContext(Object ... requestItems) {
        TilesRequestContext tilesContext = this.getRequestContext(requestItems);
        return this.startContext(tilesContext);
    }

    @Override
    public void endContext(Object ... requestItems) {
        TilesRequestContext tilesContext = this.getRequestContext(requestItems);
        this.endContext(tilesContext);
    }

    private AttributeContext startContext(TilesRequestContext tilesContext) {
        BasicAttributeContext context = new BasicAttributeContext();
        BasicAttributeContext.pushContext(context, tilesContext);
        return context;
    }

    private void endContext(TilesRequestContext tilesContext) {
        BasicAttributeContext.popContext(tilesContext);
    }

    protected void checkInit() {
        if (this.initialized) {
            throw new IllegalStateException("Container allready initialized");
        }
    }

    protected void initializeDefinitionsFactory(DefinitionsFactory definitionsFactory, String resourceString, Map<String, String> initParameters) throws TilesException {
        List<String> resources = this.getResourceNames(resourceString);
        try {
            for (String resource : resources) {
                URL resourceUrl = this.context.getResource(resource);
                if (resourceUrl != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding resource '" + resourceUrl + "' to definitions factory."));
                    }
                    definitionsFactory.addSource(resourceUrl);
                    continue;
                }
                LOG.warn((Object)("Unable to find configured definition '" + resource + "'"));
            }
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("Unable to parse definitions from " + resourceString, e);
        }
        definitionsFactory.init(initParameters);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Tiles2 container initialization complete.");
        }
    }

    @Override
    public TilesApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setApplicationContext(TilesApplicationContext context) {
        this.context = context;
    }

    @Override
    public AttributeContext getAttributeContext(Object ... requestItems) {
        TilesRequestContext tilesContext = this.getRequestContext(requestItems);
        return this.getAttributeContext(tilesContext);
    }

    private AttributeContext getAttributeContext(TilesRequestContext tilesContext) {
        AttributeContext context = BasicAttributeContext.getContext(tilesContext);
        if (context == null) {
            context = new BasicAttributeContext();
            BasicAttributeContext.pushContext(context, tilesContext);
        }
        return context;
    }

    private TilesRequestContext getRequestContext(Object ... requestItems) {
        return this.getContextFactory().createRequestContext(this.getApplicationContext(), requestItems);
    }

    public TilesContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(TilesContextFactory contextFactory) {
        this.checkInit();
        this.contextFactory = contextFactory;
    }

    public DefinitionsFactory getDefinitionsFactory() {
        return this.definitionsFactory;
    }

    public void setDefinitionsFactory(DefinitionsFactory definitionsFactory) {
        this.checkInit();
        this.definitionsFactory = definitionsFactory;
    }

    public PreparerFactory getPreparerFactory() {
        return this.preparerFactory;
    }

    public void setPreparerFactory(PreparerFactory preparerFactory) {
        this.preparerFactory = preparerFactory;
    }

    @Override
    public void prepare(String preparer, Object ... requestItems) throws TilesException {
        TilesRequestContext requestContext = this.getContextFactory().createRequestContext(this.getApplicationContext(), requestItems);
        this.prepare(requestContext, preparer, false);
    }

    private void prepare(TilesRequestContext context, String preparerName, boolean ignoreMissing) throws TilesException {
        ViewPreparer preparer;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Prepare request received for '" + preparerName));
        }
        if ((preparer = this.preparerFactory.getPreparer(preparerName, context)) == null && ignoreMissing) {
            return;
        }
        if (preparer == null) {
            throw new NoSuchPreparerException("Preparer '" + preparerName + " not found");
        }
        AttributeContext attributeContext = BasicAttributeContext.getContext(context);
        preparer.execute(context, attributeContext);
    }

    @Override
    public void render(String definitionName, Object ... requestItems) throws TilesException {
        TilesRequestContext requestContext = this.getContextFactory().createRequestContext(this.getApplicationContext(), requestItems);
        this.render(requestContext, definitionName);
    }

    private void render(TilesRequestContext request, String definitionName) throws TilesException {
        Definition definition;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Render request recieved for definition '" + definitionName + "'"));
        }
        if ((definition = this.getDefinition(definitionName, request)) == null) {
            if (LOG.isWarnEnabled()) {
                String message = "Unable to find the definition '" + definitionName + "'";
                LOG.warn((Object)message);
            }
            throw new NoSuchDefinitionException(definitionName);
        }
        if (!this.isPermitted(request, definition.getRole())) {
            LOG.info((Object)("Access to definition '" + definitionName + "' denied.  User not in role '" + definition.getRole()));
            return;
        }
        AttributeContext originalContext = this.getAttributeContext(request);
        BasicAttributeContext subContext = new BasicAttributeContext(originalContext);
        subContext.addMissing(definition.getAttributes());
        BasicAttributeContext.pushContext(subContext, request);
        try {
            if (definition.getPreparer() != null) {
                this.prepare(request, definition.getPreparer(), true);
            }
            String dispatchPath = definition.getTemplate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Dispatching to definition path '" + definition.getTemplate() + " '"));
            }
            request.dispatch(dispatchPath);
        }
        catch (TilesException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Error rendering tile", (Throwable)e);
            throw new TilesException(e.getMessage(), e);
        }
        finally {
            BasicAttributeContext.popContext(request);
        }
    }

    @Override
    public void render(Attribute attr, Writer writer, Object ... requestItems) throws TilesException, IOException {
        TilesRequestContext request = this.getRequestContext(requestItems);
        if (attr == null) {
            throw new TilesException("Cannot render a null attribute");
        }
        if (!this.isPermitted(request, attr.getRole())) {
            LOG.info((Object)("Access to attribute '" + attr.getName() + "' denied.  User not in role '" + attr.getRole()));
            return;
        }
        Attribute.AttributeType type = attr.getType();
        if (type == null) {
            type = this.calculateType(attr, request);
            attr.setType(type);
        }
        switch (type) {
            case OBJECT: {
                throw new TilesException("Cannot insert an attribute of 'object' type");
            }
            case STRING: {
                writer.write(attr.getValue().toString());
                break;
            }
            case DEFINITION: {
                this.render(request, attr.getValue().toString());
                break;
            }
            case TEMPLATE: {
                request.dispatch(attr.getValue().toString());
                break;
            }
            default: {
                throw new TilesException("Unrecognized type for attribute value " + attr.getValue());
            }
        }
    }

    private Attribute.AttributeType calculateType(Attribute attr, TilesRequestContext request) throws TilesException {
        String valueString;
        Object valueContent = attr.getValue();
        Attribute.AttributeType type = valueContent instanceof String ? (this.isValidDefinition(request, valueString = (String)valueContent) ? Attribute.AttributeType.DEFINITION : (valueString.startsWith("/") ? Attribute.AttributeType.TEMPLATE : Attribute.AttributeType.STRING)) : Attribute.AttributeType.OBJECT;
        return type;
    }

    protected Definition getDefinition(String definitionName, TilesRequestContext request) throws DefinitionsFactoryException {
        Definition definition = this.definitionsFactory.getDefinition(definitionName, request);
        return definition;
    }

    private boolean isPermitted(TilesRequestContext request, String role) {
        if (role == null) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(role, ",");
        while (st.hasMoreTokens()) {
            if (!request.isUserInRole(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    protected String getResourceString() {
        return this.getResourceString(this.context.getInitParams());
    }

    protected String getResourceString(Map<String, String> parms) {
        String resourceStr = parms.get(DEFINITIONS_CONFIG);
        if (resourceStr == null) {
            resourceStr = parms.get(LEGACY_DEFINITIONS_CONFIG);
        }
        if (resourceStr == null) {
            resourceStr = "/WEB-INF/tiles.xml";
        }
        return resourceStr;
    }

    protected List<String> getResourceNames(String resourceString) {
        StringTokenizer tokenizer = new StringTokenizer(resourceString, ",");
        ArrayList<String> filenames = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            filenames.add(tokenizer.nextToken().trim());
        }
        return filenames;
    }

    @Override
    public boolean isValidDefinition(String definitionName, Object ... requestItems) {
        return this.isValidDefinition(this.getRequestContext(requestItems), definitionName);
    }

    private boolean isValidDefinition(TilesRequestContext context, String definitionName) {
        try {
            Definition definition = this.getDefinition(definitionName, context);
            return definition != null;
        }
        catch (NoSuchDefinitionException nsde) {
            return false;
        }
        catch (DefinitionsFactoryException e) {
            return false;
        }
    }
}

