/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.jsp.taglib.RoleSecurityTagSupport;

public abstract class ContainerTagSupport
extends RoleSecurityTagSupport {
    private static final Log LOG = LogFactory.getLog(ContainerTagSupport.class);
    protected TilesContainer container;
    protected AttributeContext attributeContext;

    public int doStartTag() throws JspException {
        this.container = TilesAccess.getContainer(this.pageContext.getServletContext());
        if (this.container != null) {
            this.startContext(this.pageContext);
            return 2;
        }
        throw new JspException("TilesContainer not initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        try {
            int n = super.doEndTag();
            return n;
        }
        finally {
            this.endContext(this.pageContext);
        }
    }

    public void release() {
        super.release();
        this.container = null;
        this.attributeContext = null;
    }

    protected void startContext(PageContext context) {
        if (this.container != null) {
            this.attributeContext = this.container.startContext(this.pageContext);
        }
    }

    protected void endContext(PageContext context) {
        if (this.attributeContext != null && this.container != null) {
            this.container.endContext(this.pageContext);
        }
    }
}

