/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.account.mgt.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.account.mgt.stub.services.BillingDataAccessServiceStub;
import org.wso2.carbon.account.mgt.stub.services.beans.xsd.Customer;
import org.wso2.carbon.account.mgt.stub.services.beans.xsd.Subscription;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class UsagePlanClient {
    private BillingDataAccessServiceStub stub;
    private String epr;
    private static final Log log = LogFactory.getLog(UsagePlanClient.class);

    public UsagePlanClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "BillingDataAccessService";
        try {
            this.stub = new BillingDataAccessServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public boolean updateUsagePlan(String tenantDomainName, String usagePlanName) {
        try {
            Customer customer = this.stub.getCustomerWithName(tenantDomainName);
            this.stub.changeSubscription(customer.getId(), usagePlanName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getUsagePlanName(String tenantName) throws Exception {
        try {
            Customer customer = this.stub.getCustomerWithName(tenantName);
            if (customer != null) {
                Subscription subscription = this.stub.getActiveSubscriptionOfCustomer(customer.getId());
                if (subscription != null) {
                    return subscription.getSubscriptionPlan();
                }
                return new String("");
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while getting the usage place for tenant: " + tenantName;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return new String("");
    }
}

