/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.account.mgt.ui.utils;

import java.io.StringReader;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.account.mgt.stub.beans.xsd.AccountInfoBean;
import org.wso2.carbon.account.mgt.ui.clients.AccountMgtClient;
import org.wso2.carbon.account.mgt.ui.clients.UsagePlanClient;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);

    public static HttpServletRequest readIntermediateData(HttpServletRequest request, String data) {
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(data));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator it = documentElement.getChildElements();
            while (it.hasNext()) {
                OMElement element = (OMElement)it.next();
                if ("admin".equals(element.getLocalName())) {
                    request.setAttribute("admin", (Object)element.getText());
                    continue;
                }
                if ("email".equals(element.getLocalName())) {
                    request.setAttribute("email", (Object)element.getText());
                    continue;
                }
                if ("tenantDomain".equals(element.getLocalName()) && request.getAttribute("tenantDomain") == null) {
                    request.setAttribute("tenantDomain", (Object)element.getText());
                    continue;
                }
                if (!"confirmationKey".equals(element.getLocalName())) continue;
                request.setAttribute("confirmationKey", (Object)element.getText());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error parsing xml", (Throwable)e);
        }
        return request;
    }

    public static boolean updateFullname(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        AccountInfoBean accountInfoBean = new AccountInfoBean();
        String firstname = "";
        String lastname = "";
        try {
            firstname = request.getParameter("firstname");
            lastname = request.getParameter("lastname");
            accountInfoBean.setFirstname(firstname);
            accountInfoBean.setLastname(lastname);
            AccountMgtClient client = new AccountMgtClient(config, session);
            return client.updateFullname(accountInfoBean);
        }
        catch (Exception e) {
            String msg = "Failed to update tenant with firstname: " + firstname;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static String getUsagePlanName(ServletConfig config, HttpSession session) throws Exception {
        try {
            String tenantDomain = (String)session.getAttribute("tenantDomain");
            UsagePlanClient client = new UsagePlanClient(config, session);
            return client.getUsagePlanName(tenantDomain);
        }
        catch (Exception e) {
            String msg = "Failed to get usage plan for tenant";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static boolean updateUsagePlan(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        boolean updated = false;
        try {
            String tenantDomain = (String)session.getAttribute("tenantDomain");
            String usagePlanName = request.getParameter("usage-plan-name");
            UsagePlanClient client = new UsagePlanClient(config, session);
            updated = client.updateUsagePlan(tenantDomain, usagePlanName);
        }
        catch (Exception e) {
            String msg = "Failed to get update usage plan for tenant";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return updated;
    }
}

