/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.bpel.Axis2ConfigurationContextObserverImpl;
import org.wso2.carbon.bpel.internal.BPELServerHolder;
import org.wso2.carbon.bpel.ode.integration.BPELServer;
import org.wso2.carbon.bpel.ode.integration.BPELServerImpl;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.Utils;

public class BPELServiceComponent {
    private static Log log = LogFactory.getLog(BPELServiceComponent.class);
    private BundleContext bundleContext;
    private boolean dataSourceInfoRepoProvided = false;

    protected void activate(ComponentContext ctxt) {
        try {
            this.bundleContext = ctxt.getBundleContext();
            if (this.dataSourceInfoRepoProvided) {
                BPELServiceComponent.initializeBPELServer();
                Utils.registerDeployerServices((BundleContext)this.bundleContext);
                this.registerBpsServerService();
                this.registerAxis2ConfigurationContextObserver();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to activate the BPELServiceComponent", t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"BPEL Deployer bundle is activated.");
        }
    }

    protected void setDataSourceInformationRepositoryService(DataSourceInformationRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService bound to the BPEL component");
        }
        this.dataSourceInfoRepoProvided = true;
    }

    protected void unsetDataSourceInformationRepositoryService(DataSourceInformationRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService unbound from the BPEL component");
        }
        this.dataSourceInfoRepoProvided = false;
    }

    protected void setAppManager(ApplicationManagerService appService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CarbonApplicationService bound to the BPEL component");
        }
        BPELServerHolder.getInstance().setApplicationManager(appService);
    }

    protected void unsetAppManager(ApplicationManagerService appService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CarbonApplicationService unbound from the BPEL component");
        }
        BPELServerHolder.getInstance().setApplicationManager(null);
    }

    protected void setRegistryService(RegistryService registrySvc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the BPEL component");
        }
        BPELServerHolder.getInstance().setRegistryService(registrySvc);
    }

    protected void unsetRegistryService(RegistryService registrySvc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the BPEL component");
        }
        BPELServerHolder.getInstance().setRegistryService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService bound to the BPEL component");
        }
        BPELServerHolder.getInstance().setCcServiceInstance(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unbound from the BPEL component");
        }
        BPELServerHolder.getInstance().setCcServiceInstance(null);
    }

    public static RegistryService getRegistryService() {
        return BPELServerHolder.getInstance().getRegistryService();
    }

    public static ApplicationManagerService getAppManager() {
        if (BPELServerHolder.getInstance().getApplicationManager() == null) {
            String msg = "Before activating BPEL bundle, an instance of CarbonApplicationService should be in existence";
            log.error((Object)msg);
        }
        return BPELServerHolder.getInstance().getApplicationManager();
    }

    public static BPELServer getBPELServer() {
        return BPELServerHolder.getInstance().getBpelServer();
    }

    private void registerAxis2ConfigurationContextObserver() {
        this.bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new Axis2ConfigurationContextObserverImpl(), null);
    }

    private static void initializeBPELServer() throws Exception {
        BPELServerHolder.getInstance().setBpelServer(BPELServerImpl.getInstance());
        BPELServerHolder.getInstance().getBpelServer().setSupperTenantConfigurationContext(BPELServerHolder.getInstance().getCcServiceInstance().getServerConfigContext());
        log.info((Object)"Initializing BPEL Engine........");
        BPELServerHolder.getInstance().getBpelServer().init();
        Runtime.getRuntime().addShutdownHook(new BPELServerShutDown(BPELServerHolder.getInstance().getBpelServer()));
    }

    private void registerBpsServerService() {
        this.bundleContext.registerService(BPELServer.class.getName(), (Object)BPELServerHolder.getInstance().getBpelServer(), null);
    }

    private static class BPELServerShutDown
    extends Thread {
        private BPELServerImpl bpsServer;

        private BPELServerShutDown(BPELServerImpl bpsServer) {
            this.bpsServer = bpsServer;
        }

        @Override
        public void run() {
            log.info((Object)"Shutting down BPEL Server........");
            try {
                this.bpsServer.shutdown();
            }
            catch (Exception e) {
                log.error((Object)"Error when shutting down BPEL Server.", (Throwable)e);
            }
        }
    }
}

