/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TwoChannelAxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.ode.integration.BPELFault;
import org.wso2.carbon.bpel.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.ode.integration.axis2.WSDLAwareMessage;
import org.wso2.carbon.bpel.ode.integration.utils.SOAPUtils;

public class BPELProcessProxy {
    private static final Log log = LogFactory.getLog(BPELProcessProxy.class);
    private BpelServer odeBpelServer;
    private ProcessConf processConfiguration;
    private TransactionManager transactionManager;
    private Definition wsdlDefinition;
    private QName serviceName;
    private String port;
    private WSAEndpoint serviceReference;
    private AxisService axisService;

    public BPELProcessProxy(ProcessConf processConf, BPELServerImpl bpelServer, QName serviceName, String port) {
        this.processConfiguration = processConf;
        this.odeBpelServer = bpelServer.getODEBPELServer();
        this.serviceName = serviceName;
        this.port = port;
        this.transactionManager = bpelServer.getTransactionManager();
        this.wsdlDefinition = this.processConfiguration.getDefinitionForService(serviceName);
        this.serviceReference = EndpointFactory.convertToWSA((MutableEndpoint)BPELProcessProxy.createServiceRef(BPELProcessProxy.genEPRfromWSDL(this.wsdlDefinition, serviceName, port)));
    }

    public final ProcessConf getProcessConfiguration() {
        return this.processConfiguration;
    }

    public final Definition getWsdlDefinition() {
        return this.wsdlDefinition;
    }

    public final QName getServiceName() {
        return this.serviceName;
    }

    public final String getPort() {
        return this.port;
    }

    public final AxisService getAxisService() {
        return this.axisService;
    }

    public final void setAxisService(AxisService axisService) {
        this.axisService = axisService;
    }

    public final WSAEndpoint getServiceReference() {
        return this.serviceReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAxisServiceInvoke(BPELMessageContext bpelMessageContext) throws AxisFault {
        boolean success = true;
        MyRoleMessageExchange odeMessageExchange = null;
        Future responseFuture = null;
        Throwable cachedException = null;
        try {
            this.transactionManager.begin();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Strating transaction.");
            }
            this.odeBpelServer.acquireTransactionLocks();
            odeMessageExchange = this.createMessageExchange(bpelMessageContext.getInMessageContext());
            if (odeMessageExchange.getOperation() != null) {
                responseFuture = this.invokeBPELProcessThroughODEMessageExchange(odeMessageExchange, bpelMessageContext);
                success = this.commitODEMessageExchange(odeMessageExchange);
            } else {
                success = false;
            }
            if (!success) {
                this.releaseODEMessageExchangeAndRollbackTransaction(odeMessageExchange, (Exception)cachedException, success);
            }
        }
        catch (Exception e) {
            try {
                cachedException = e;
                success = false;
                this.handleExceptionAtODEInvocation(e);
                if (!success) {
                    this.releaseODEMessageExchangeAndRollbackTransaction(odeMessageExchange, (Exception)cachedException, success);
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.releaseODEMessageExchangeAndRollbackTransaction(odeMessageExchange, (Exception)cachedException, success);
                }
                throw throwable;
            }
        }
        if (odeMessageExchange.getOperation().getOutput() != null) {
            this.waitForTheResponse(responseFuture, odeMessageExchange);
            if (bpelMessageContext.getOutMessageContext() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handling response for MEX " + odeMessageExchange));
                }
                this.setOutMessageContextSOAPEnvelope(bpelMessageContext);
                boolean commit = false;
                this.beginTransactionForTheResponsePath();
                try {
                    odeMessageExchange = (MyRoleMessageExchange)this.odeBpelServer.getEngine().getMessageExchange(odeMessageExchange.getMessageExchangeId());
                    this.onResponse(bpelMessageContext, odeMessageExchange, bpelMessageContext.getOutMessageContext());
                    commit = true;
                }
                catch (AxisFault af) {
                    cachedException = af;
                    log.warn((Object)("MEX produced a fault " + odeMessageExchange), (Throwable)af);
                    commit = true;
                    throw af;
                }
                catch (Exception e) {
                    cachedException = e;
                    log.error((Object)("Error processing response for MEX " + odeMessageExchange), (Throwable)e);
                    throw new BPELFault("An exception occured when invoking ODE.", e);
                }
                finally {
                    odeMessageExchange.release(commit);
                    if (commit) {
                        this.commitTransactionForTheResponsePath((Exception)cachedException);
                    } else {
                        this.rollbackTransactionForTheResponsePath((Exception)cachedException);
                    }
                }
            }
            if (!success) {
                throw new BPELFault("Message was either un-routable or timed out!");
            }
        }
    }

    private void beginTransactionForTheResponsePath() throws BPELFault {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting transaction.");
            }
            this.transactionManager.begin();
        }
        catch (Exception ex) {
            String errorMessage = "Failed to start transaction!";
            log.error((Object)errorMessage, (Throwable)ex);
            throw new BPELFault(errorMessage, ex);
        }
    }

    private void commitTransactionForTheResponsePath(Exception cachedException) throws BPELFault {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Comitting transaction.");
            }
            this.transactionManager.commit();
        }
        catch (Exception e) {
            String errorMessage = "Commiting Response Path Transaction Failed.";
            e.initCause(cachedException);
            log.error((Object)errorMessage, (Throwable)e);
            throw new BPELFault(errorMessage, e);
        }
    }

    private void rollbackTransactionForTheResponsePath(Exception cachedException) throws BPELFault {
        try {
            this.transactionManager.rollback();
        }
        catch (Exception e) {
            e.initCause(cachedException);
            throw new BPELFault("Rollback failed!", e);
        }
    }

    private void setOutMessageContextSOAPEnvelope(BPELMessageContext bpelMessageContext) throws AxisFault {
        SOAPEnvelope envelope = bpelMessageContext.getSoapFactoryForCurrentMessageFlow().getDefaultEnvelope();
        bpelMessageContext.getOutMessageContext().setEnvelope(envelope);
    }

    private MyRoleMessageExchange createMessageExchange(MessageContext inMessageContext) {
        MyRoleMessageExchange messageExchange = null;
        String messageId = new GUID().toString();
        messageExchange = this.odeBpelServer.getEngine().createMessageExchange("" + messageId, this.serviceName, inMessageContext.getAxisOperation().getName().getLocalPart());
        if (log.isDebugEnabled()) {
            log.debug((Object)("ODE routed to portType " + messageExchange.getPortType() + " operation " + messageExchange.getOperation() + " from service " + this.serviceName));
        }
        messageExchange.setProperty("isTwoWay", Boolean.toString(inMessageContext.getAxisOperation() instanceof TwoChannelAxisOperation));
        return messageExchange;
    }

    private Message createInputMessageToODE(BPELMessageContext bpelMessageContext, MyRoleMessageExchange messageExchange) throws AxisFault {
        Message odeRequest = messageExchange.createMessage(messageExchange.getOperation().getInput().getMessage().getQName());
        this.fillODEMessage(odeRequest, bpelMessageContext.getRequestMessage());
        return odeRequest;
    }

    private Future invokeBPELProcessThroughODEMessageExchange(MyRoleMessageExchange odeMessageExchange, BPELMessageContext bpelMessageContext) throws AxisFault {
        Message request = this.createInputMessageToODE(bpelMessageContext, odeMessageExchange);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking ODE using MEX " + odeMessageExchange));
            log.debug((Object)("Message content:  " + DOMUtils.domToString((Node)request.getMessage())));
        }
        return odeMessageExchange.invoke(request);
    }

    private boolean commitODEMessageExchange(MyRoleMessageExchange odeMessageExchange) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Commiting ODE MEX " + odeMessageExchange));
                log.debug((Object)"Commiting transaction.");
            }
            this.transactionManager.commit();
        }
        catch (Exception e) {
            log.error((Object)"Commit failed", (Throwable)e);
            return false;
        }
        return true;
    }

    private void handleExceptionAtODEInvocation(Exception e) throws BPELFault {
        String errorMessage = "Exception occurred while invoking ODE";
        log.error((Object)errorMessage, (Throwable)e);
        String message = e.getMessage();
        if (message == null) {
            message = errorMessage;
        }
        throw new BPELFault(message, e);
    }

    public final void releaseODEMessageExchangeAndRollbackTransaction(MyRoleMessageExchange odeMessageExchange, Exception cachedException, boolean isProcessInvokeSuccess) throws BPELFault {
        if (odeMessageExchange != null) {
            odeMessageExchange.release(isProcessInvokeSuccess);
        }
        try {
            this.transactionManager.rollback();
        }
        catch (Exception e) {
            e.initCause(cachedException);
            throw new BPELFault("Rollback failed", e);
        }
    }

    private void waitForTheResponse(Future responseFuture, MyRoleMessageExchange odeMessageExchange) throws BPELFault {
        try {
            responseFuture.get(this.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            String errorMsg = "Timeout or execution error when waiting for response to MEX " + odeMessageExchange + " " + e.toString();
            log.error((Object)errorMsg, (Throwable)e);
            throw new BPELFault(errorMsg);
        }
    }

    private void fillODEMessage(Message odeRequest, WSDLAwareMessage inComingMessage) {
        Map<String, OMElement> bodyParts = inComingMessage.getBodyParts();
        Map<String, OMElement> headerParts = inComingMessage.getHeaderParts();
        for (Map.Entry<String, OMElement> bodyPart : bodyParts.entrySet()) {
            if (inComingMessage.isRPC()) {
                odeRequest.setPart(bodyPart.getKey(), OMUtils.toDOM((OMElement)bodyPart.getValue()));
                continue;
            }
            Document doc = DOMUtils.newDocument();
            Element destPart = doc.createElementNS(null, bodyPart.getKey());
            destPart.appendChild(doc.importNode(OMUtils.toDOM((OMElement)bodyPart.getValue()), true));
            odeRequest.setPart(bodyPart.getKey(), destPart);
        }
        for (Map.Entry<String, OMElement> headerPart : headerParts.entrySet()) {
            odeRequest.setHeaderPart(headerPart.getKey(), OMUtils.toDOM((OMElement)headerPart.getValue()));
        }
    }

    private void onResponse(BPELMessageContext bpelMessageContext, MyRoleMessageExchange mex, MessageContext msgContext) throws AxisFault {
        switch (mex.getStatus()) {
            case FAULT: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fault response message: " + mex.getFault()));
                }
                SOAPFault fault = SOAPUtils.createSoapFault(bpelMessageContext, (MessageExchange)mex);
                msgContext.getEnvelope().getBody().addFault(fault);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Returning fault: " + msgContext.getEnvelope().toString()));
                break;
            }
            case ASYNC: 
            case RESPONSE: {
                SOAPUtils.createSOAPResponse(bpelMessageContext, mex);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Response message " + msgContext.getEnvelope()));
                break;
            }
            case FAILURE: {
                throw new BPELFault("Message exchange failure");
            }
            default: {
                throw new BPELFault("Received ODE message exchange in unexpected state: " + mex.getStatus());
            }
        }
    }

    private long getTimeout() {
        String timeout = (String)this.processConfiguration.getEndpointProperties((EndpointReference)this.serviceReference).get("mex.timeout");
        if (timeout != null) {
            try {
                return Long.parseLong(timeout);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Mal-formatted Property: [mex.timeout=" + timeout + "] Default value (" + 120000 + ") will be used"));
            }
        }
        return BPELServerImpl.getInstance().getBpelServerConfiguration().getMexTimeOut();
    }

    public static Element genEPRfromWSDL(Definition wsdlDef, QName serviceName, String portName) {
        Port portDef;
        Service serviceDef = wsdlDef.getService(serviceName);
        if (serviceDef != null && (portDef = serviceDef.getPort(portName)) != null) {
            Document doc = DOMUtils.newDocument();
            Element service = doc.createElementNS(Namespaces.WSDL_11, "service");
            service.setAttribute("name", serviceDef.getQName().getLocalPart());
            service.setAttribute("targetNamespace", serviceDef.getQName().getNamespaceURI());
            Element port = doc.createElementNS(Namespaces.WSDL_11, "port");
            service.appendChild(port);
            port.setAttribute("name", portDef.getName());
            port.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bindns", portDef.getBinding().getQName().getNamespaceURI());
            port.setAttribute("bindns:binding", portDef.getName());
            for (Object extElmt : portDef.getExtensibilityElements()) {
                if (extElmt instanceof SOAPAddress) {
                    Element soapAddr = doc.createElementNS(Namespaces.SOAP_NS, "address");
                    port.appendChild(soapAddr);
                    soapAddr.setAttribute("location", ((SOAPAddress)extElmt).getLocationURI());
                    continue;
                }
                if (extElmt instanceof HTTPAddress) {
                    Element httpAddr = doc.createElementNS(Namespaces.HTTP_NS, "address");
                    port.appendChild(httpAddr);
                    httpAddr.setAttribute("location", ((HTTPAddress)extElmt).getLocationURI());
                    continue;
                }
                if (extElmt instanceof SOAP12Address) {
                    Element soap12Addr = doc.createElementNS(Namespaces.SOAP12_NS, "address");
                    port.appendChild(soap12Addr);
                    soap12Addr.setAttribute("location", ((SOAP12Address)extElmt).getLocationURI());
                    continue;
                }
                port.appendChild(doc.importNode(((UnknownExtensibilityElement)extElmt).getElement(), true));
            }
            return service;
        }
        return null;
    }

    public static MutableEndpoint createServiceRef(Element elmt) {
        Document doc = DOMUtils.newDocument();
        QName elQName = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
        if (!EndpointReference.SERVICE_REF_QNAME.equals(elQName)) {
            Element serviceref = doc.createElementNS(EndpointReference.SERVICE_REF_QNAME.getNamespaceURI(), EndpointReference.SERVICE_REF_QNAME.getLocalPart());
            serviceref.appendChild(doc.importNode(elmt, true));
            doc.appendChild(serviceref);
        } else {
            doc.appendChild(doc.importNode(elmt, true));
        }
        return EndpointFactory.createEndpoint((Element)doc.getDocumentElement());
    }
}

