/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.evt.DebugBpelEventListener;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.CountLRUDehydrationPolicy;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.cron.CronScheduler;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionCorrelationFilter;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.JdbcDelegate;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.utils.GUID;
import org.wso2.carbon.bpel.ode.integration.BPELBindingContextImpl;
import org.wso2.carbon.bpel.ode.integration.BPELEndpointReferenceContextImpl;
import org.wso2.carbon.bpel.ode.integration.BPELMessageExchangeContextImpl;
import org.wso2.carbon.bpel.ode.integration.BPELServer;
import org.wso2.carbon.bpel.ode.integration.ODEConfigurationProperties;
import org.wso2.carbon.bpel.ode.integration.config.BPELServerConfiguration;
import org.wso2.carbon.bpel.ode.integration.store.MultiTenantProcessStore;
import org.wso2.carbon.bpel.ode.integration.store.ProcessStoreImpl;
import org.wso2.carbon.bpel.ode.integration.utils.BPELDatabaseCreator;
import org.wso2.carbon.utils.CarbonUtils;

public class BPELServerImpl
implements BPELServer {
    private static Log log = LogFactory.getLog(BPELServerImpl.class);
    private BpelServerImpl odeBpelServer;
    private ProcessStoreImpl processStore;
    private TransactionManager transactionManager;
    private MultiThreadedHttpConnectionManager httpConnectionManager;
    private BpelDAOConnectionFactory daoConnectionFactory;
    private Database db;
    private Scheduler scheduler;
    private ODEConfigurationProperties odeConfigurationProperties;
    private ExecutorService executorService;
    private CronScheduler cronScheduler;
    protected IdleConnectionTimeoutThread idleConnectionTimeoutThread;
    private BPELServerConfiguration bpelServerConfiguration;
    private ConfigurationContext supperTenantConfigurationContext;
    private static BPELServerImpl ourInstance = new BPELServerImpl();

    public static BPELServerImpl getInstance() {
        return ourInstance;
    }

    private BPELServerImpl() {
    }

    public void init() throws Exception {
        this.bpelServerConfiguration = new BPELServerConfiguration();
        this.odeConfigurationProperties = new ODEConfigurationProperties(this.bpelServerConfiguration);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing transaction manager");
        }
        this.initTransactionManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating data source");
        }
        this.initDataSource();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting DAO");
        }
        this.initDAO();
        BPELEndpointReferenceContextImpl eprContext = new BPELEndpointReferenceContextImpl();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing BPEL process store");
        }
        this.initProcessStore(eprContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing BPEL server");
        }
        this.initBPELServer(eprContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing multithreaded connection manager");
        }
        this.initHttpConnectionManager();
        this.registerEventListeners();
        this.registerMexInterceptors();
        this.registerExtensionActivityBundles();
        this.registerExtensionCorrelationFilters();
        try {
            this.odeBpelServer.start();
        }
        catch (Exception e) {
            this.shutdown();
            String errMsg = "BPEL Server failed to start.";
            log.error((Object)errMsg, (Throwable)e);
            throw new Exception(errMsg, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting scheduler..");
        }
        this.scheduler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        if (this.odeBpelServer != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Shutting down BPEL server.");
                }
                this.odeBpelServer.shutdown();
            }
            catch (Throwable t) {
                log.warn((Object)"Error stoping services.", t);
            }
            finally {
                this.odeBpelServer = null;
            }
        }
        if (this.cronScheduler != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Shutting down cron scheduler.");
                }
                this.cronScheduler.shutdown();
            }
            catch (Exception e) {
                log.warn((Object)"Cron scheduler couldn't be shutdown.", (Throwable)e);
            }
            finally {
                this.cronScheduler = null;
            }
        }
        if (this.scheduler != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Shutting down quartz schedular.");
                }
                this.scheduler.shutdown();
            }
            catch (Exception e) {
                log.warn((Object)"Scheduler couldn't be shut down.", (Throwable)e);
            }
            finally {
                this.scheduler = null;
            }
        }
        if (this.processStore != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Shutting down process store.");
                }
                this.processStore.shutdown();
            }
            catch (Throwable t) {
                log.warn((Object)"Process store could not be shutdown.", t);
            }
            finally {
                this.processStore = null;
            }
        }
        if (this.daoConnectionFactory != null) {
            try {
                this.daoConnectionFactory.shutdown();
            }
            catch (Throwable t) {
                log.warn((Object)"DAO shutdown failed.", t);
            }
            finally {
                this.daoConnectionFactory = null;
            }
        }
        if (this.db != null) {
            try {
                this.db.shutdown();
            }
            catch (Throwable t) {
                log.warn((Object)"DB shutdown failed.", t);
            }
            finally {
                this.db = null;
            }
        }
        if (this.transactionManager != null) {
            this.transactionManager = null;
        }
        if (this.httpConnectionManager != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Shuting down HTTP Connection Manager.");
                }
                this.httpConnectionManager.shutdown();
            }
            catch (Exception e) {
                log.warn((Object)"HTTP Connection Manager shutdown failed.");
            }
        }
        if (this.idleConnectionTimeoutThread != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Shutting down Idle Connection Timeout Thread.");
                }
                this.idleConnectionTimeoutThread.shutdown();
            }
            catch (Exception e) {
                log.warn((Object)"Idle connection timeout thread shutdown failed.");
            }
        }
        this.executorService.shutdown();
        log.info((Object)"BPEL Server shutdown complpeted.");
    }

    @Override
    public void registerEventListener(String eventListenerClass) {
    }

    @Override
    public void registerMessageExchangeInterceptor(String mexInterceptorClass) {
    }

    @Override
    public MultiTenantProcessStore getMultiTenantProcessStore() {
        return this.processStore;
    }

    @Override
    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public BpelServerImpl getODEBPELServer() {
        return this.odeBpelServer;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public ODEConfigurationProperties getOdeConfigurationProperties() {
        return this.odeConfigurationProperties;
    }

    public void setSupperTenantConfigurationContext(ConfigurationContext supperTenantConfigurationContext) {
        this.supperTenantConfigurationContext = supperTenantConfigurationContext;
    }

    private void initTransactionManager() throws BPELEngineException {
        String txFactoryName = this.bpelServerConfiguration.getTransactionFactoryClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing transaction manager using " + txFactoryName));
        }
        try {
            Class<?> txFactoryClass = this.getClass().getClassLoader().loadClass(txFactoryName);
            Object txFactory = txFactoryClass.newInstance();
            this.transactionManager = (TransactionManager)txFactoryClass.getMethod("getTransactionManager", null).invoke(txFactory, new Object[0]);
        }
        catch (Exception e) {
            log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryName), (Throwable)e);
            throw new BPELEngineException("Couldn't initialize a transaction manager with factory: " + txFactoryName, e);
        }
    }

    private void initDataSource() throws BPELEngineException {
        String dbRoot;
        File dbRootDir;
        this.db = new Database((OdeConfigProperties)this.odeConfigurationProperties);
        this.db.setTransactionManager(this.transactionManager);
        if (System.getProperty("setup") != null) {
            BPELDatabaseCreator bpelDBCreator;
            try {
                bpelDBCreator = new BPELDatabaseCreator((DataSource)this.db.lookupInJndi(this.odeConfigurationProperties.getDbDataSource()));
            }
            catch (Exception e) {
                String errMsg = "Error creating BPELDatabaseCreator";
                log.error((Object)errMsg, (Throwable)e);
                throw new BPELEngineException(errMsg, e);
            }
            if (!bpelDBCreator.isDatabaseStructureCreated("SELECT * FROM ODE_SCHEMA_VERSION")) {
                try {
                    bpelDBCreator.createRegistryDatabase();
                }
                catch (Exception e) {
                    String errMsg = "Error creating BPEL database";
                    log.error((Object)errMsg, (Throwable)e);
                    throw new BPELEngineException(errMsg, e);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"BPEL database already exists. Using the old database.");
            }
        }
        if ((dbRootDir = new File(dbRoot = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "database")).exists() && dbRootDir.isDirectory()) {
            this.db.setWorkRoot(dbRootDir);
        } else {
            this.db.setWorkRoot(null);
        }
        try {
            this.db.start();
        }
        catch (Exception e) {
            String errMsg = "Error starting database connections, check the database configuration!";
            log.error((Object)errMsg, (Throwable)e);
            throw new BPELEngineException(errMsg, e);
        }
    }

    private void initDAO() throws BPELEngineException {
        log.info((Object)("Using DAO Connection Factory class: " + this.odeConfigurationProperties.getDAOConnectionFactory()));
        try {
            this.daoConnectionFactory = this.db.createDaoCF();
        }
        catch (Exception e) {
            String errMsg = "Error instantiating DAO Connection Factory class " + this.odeConfigurationProperties.getDAOConnectionFactory();
            log.error((Object)errMsg, (Throwable)e);
            throw new BPELEngineException(errMsg, e);
        }
    }

    private void initProcessStore(EndpointReferenceContext eprContext) throws Exception {
        this.processStore = new ProcessStoreImpl(eprContext, this.db.getDataSource(), this.odeConfigurationProperties);
        this.processStore.setLocalBPELDeploymentUnitRepo(new File(CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "bpel"));
        this.processStore.registerListener(new ProcessStoreListenerImpl());
        this.processStore.setRootConfigurationContext(this.supperTenantConfigurationContext);
        this.supperTenantConfigurationContext.getAxisConfiguration().addParameter("bpel.process-store", (Object)this.processStore);
    }

    private void initBPELServer(EndpointReferenceContext eprContext) {
        this.initExecutorService(this.createThreadFactory());
        this.odeBpelServer = new BpelServerImpl();
        this.setupJobScheduler();
        this.setupCronScheduler();
        this.odeBpelServer.setDaoConnectionFactory(this.daoConnectionFactory);
        this.odeBpelServer.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl(this.scheduler, this.odeConfigurationProperties.getInMemMexTtl()));
        this.odeBpelServer.setEndpointReferenceContext(eprContext);
        this.odeBpelServer.setMessageExchangeContext((MessageExchangeContext)new BPELMessageExchangeContextImpl());
        this.odeBpelServer.setBindingContext((BindingContext)new BPELBindingContextImpl(this));
        this.odeBpelServer.setScheduler(this.scheduler);
        this.activateDehydration();
        this.odeBpelServer.setMigrationTransactionTimeout(this.odeConfigurationProperties.getMigrationTransactionTimeout());
        this.odeBpelServer.setConfigProperties(this.odeConfigurationProperties.getProperties());
        this.odeBpelServer.init();
        this.odeBpelServer.setInstanceThrottledMaximumCount(this.odeConfigurationProperties.getInstanceThrottledMaximumCount());
        this.odeBpelServer.setProcessThrottledMaximumCount(this.odeConfigurationProperties.getProcessThrottledMaximumCount());
        this.odeBpelServer.setProcessThrottledMaximumSize(this.odeConfigurationProperties.getProcessThrottledMaximumSize());
        this.odeBpelServer.setHydrationLazy(this.odeConfigurationProperties.isHydrationLazy());
        this.odeBpelServer.setHydrationLazyMinimumSize(this.odeConfigurationProperties.getHydrationLazyMinimumSize());
    }

    private void activateDehydration() {
        if (this.bpelServerConfiguration.isProcessDehydrationEnabled()) {
            CountLRUDehydrationPolicy dehy = new CountLRUDehydrationPolicy();
            if (this.bpelServerConfiguration.getProcessDehydrationMaxAge() > 0) {
                dehy.setProcessMaxAge((long)this.bpelServerConfiguration.getProcessDehydrationMaxAge());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Process Max Age: " + this.bpelServerConfiguration.getProcessDehydrationMaxAge()));
                }
            }
            if (this.bpelServerConfiguration.getProcessDehydraionMaxCount() > 0) {
                dehy.setProcessMaxCount(this.bpelServerConfiguration.getProcessDehydraionMaxCount());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Process Max Count: " + this.bpelServerConfiguration.getProcessDehydraionMaxCount()));
                }
            }
            this.odeBpelServer.setDehydrationPolicy((DehydrationPolicy)dehy);
            log.info((Object)"Process Dehydration is activated...");
        }
    }

    private void setupCronScheduler() {
        this.cronScheduler = new CronScheduler();
        this.cronScheduler.setScheduledTaskExec(this.executorService);
        this.cronScheduler.setContexts(this.odeBpelServer.getContexts());
        this.odeBpelServer.setCronScheduler(this.cronScheduler);
        this.cronScheduler.scheduleSystemCronJobs(this.bpelServerConfiguration.getSystemCleanupCronJobs());
    }

    private void setupJobScheduler() {
        this.scheduler = this.createScheduler();
        this.scheduler.setJobProcessor((Scheduler.JobProcessor)this.odeBpelServer);
        BpelServerImpl.PolledRunnableProcessor polledRunnableProcessor = new BpelServerImpl.PolledRunnableProcessor();
        polledRunnableProcessor.setPolledRunnableExecutorService(this.executorService);
        polledRunnableProcessor.setContexts(this.odeBpelServer.getContexts());
        this.scheduler.setPolledRunnableProcesser((Scheduler.JobProcessor)polledRunnableProcessor);
    }

    private Scheduler createScheduler() {
        SimpleScheduler scheduler = new SimpleScheduler(new GUID().toString(), (DatabaseDelegate)new JdbcDelegate(this.db.getDataSource()), this.odeConfigurationProperties.getProperties());
        scheduler.setExecutorService(this.executorService);
        scheduler.setTransactionManager(this.transactionManager);
        return scheduler;
    }

    private ThreadFactory createThreadFactory() {
        return new ThreadFactory(){
            int threadNumber = 0;

            @Override
            public Thread newThread(Runnable r) {
                ++this.threadNumber;
                Thread t = new Thread(r, "BPELServer-" + this.threadNumber);
                t.setDaemon(true);
                return t;
            }
        };
    }

    private void initExecutorService(ThreadFactory threadFactory) {
        this.executorService = this.odeConfigurationProperties.getThreadPoolMaxSize() == 0 ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(this.odeConfigurationProperties.getThreadPoolMaxSize(), threadFactory);
    }

    private void initHttpConnectionManager() throws Exception {
        this.httpConnectionManager = new MultiThreadedHttpConnectionManager();
        int max_per_host = this.bpelServerConfiguration.getMaxConnectionsPerHost();
        int max_total = this.bpelServerConfiguration.getMaxTotalConnections();
        if (log.isDebugEnabled()) {
            log.debug((Object)("http.connection-manager.max-per-host=" + max_per_host));
            log.debug((Object)("http.connection-manager.max-total=" + max_total));
        }
        if (max_per_host < 1 || max_total < 1) {
            String errmsg = "http.connection-manager.max-per-host and http.connection-manager.max-total must be positive integers!";
            log.error((Object)errmsg);
            throw new Exception(errmsg);
        }
        this.httpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(max_per_host);
        this.httpConnectionManager.getParams().setMaxTotalConnections(max_total);
        this.idleConnectionTimeoutThread = new IdleConnectionTimeoutThread();
        this.idleConnectionTimeoutThread.setName("Http_Idle_Connection_Timeout_Thread");
        long idleConnectionTimeout = Long.parseLong(this.odeConfigurationProperties.getProperty("http.idle.connection.timeout", "30000"));
        long idleConnectionCheckInterval = Long.parseLong(this.odeConfigurationProperties.getProperty("http.idle.connection.check.interval", "30000"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("http.idle.connection.timeout=" + idleConnectionTimeout));
            log.debug((Object)("http.idle.connection.check.interval=" + idleConnectionCheckInterval));
        }
        this.idleConnectionTimeoutThread.setConnectionTimeout(idleConnectionTimeout);
        this.idleConnectionTimeoutThread.setTimeoutInterval(idleConnectionCheckInterval);
        this.idleConnectionTimeoutThread.addConnectionManager((HttpConnectionManager)this.httpConnectionManager);
        this.idleConnectionTimeoutThread.start();
    }

    private void registerEventListeners() {
        this.odeBpelServer.registerBpelEventListener((BpelEventListener)new DebugBpelEventListener());
        ArrayList<String> eventListeners = this.bpelServerConfiguration.getEventListeners();
        if (!eventListeners.isEmpty()) {
            for (String listenerCN : eventListeners) {
                try {
                    this.odeBpelServer.registerBpelEventListener((BpelEventListener)Class.forName(listenerCN).newInstance());
                    log.info((Object)("Registered custom BPEL event listener: " + listenerCN));
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't register the event listener " + listenerCN + ", the class couldn't loaded properly: "), (Throwable)e);
                }
            }
        }
    }

    private void registerMexInterceptors() {
        ArrayList<String> mexInterceptors = this.bpelServerConfiguration.getMexInterceptors();
        if (!mexInterceptors.isEmpty()) {
            for (String interceptorCN : mexInterceptors) {
                try {
                    this.odeBpelServer.registerMessageExchangeInterceptor((MessageExchangeInterceptor)Class.forName(interceptorCN).newInstance());
                    log.info((Object)("Registered message exchange interceptor: " + interceptorCN));
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't register the message exchange interceptor " + interceptorCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerExtensionActivityBundles() {
        try {
            log.info((Object)"Registering E4X Extension...");
            this.odeBpelServer.registerExtensionBundle((ExtensionBundleRuntime)Class.forName("org.apache.ode.extension.e4x.JSExtensionBundle").newInstance());
        }
        catch (Exception e) {
            log.error((Object)"Couldn't register e4x extension bundles rutime.", (Throwable)e);
        }
        ArrayList<String> extensionBundleRuntimes = this.bpelServerConfiguration.getExtensionBundleRuntimes();
        if (extensionBundleRuntimes != null) {
            for (String extension : extensionBundleRuntimes) {
                try {
                    ExtensionBundleRuntime bundleRT = (ExtensionBundleRuntime)Class.forName(extension).newInstance();
                    this.odeBpelServer.registerExtensionBundle(bundleRT);
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't register the extension bundle runtime " + extension + ", the class couldn't be " + "loaded properly."));
                }
            }
        }
    }

    private void registerExtensionCorrelationFilters() {
        ArrayList<String> extensionFilters = this.bpelServerConfiguration.getExtensionCorrelationFilters();
        if (extensionFilters != null) {
            for (String filter : extensionFilters) {
                try {
                    ExtensionCorrelationFilter filterRT = (ExtensionCorrelationFilter)Class.forName(filter).newInstance();
                    this.odeBpelServer.registerExtensionCorrelationFilter(filterRT);
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't register the extension correlation filter " + filter + ", the class couldn't be " + "loaded properly."));
                }
            }
        }
    }

    public BPELServerConfiguration getBpelServerConfiguration() {
        return this.bpelServerConfiguration;
    }

    static class BPELEngineException
    extends Exception {
        public BPELEngineException() {
        }

        public BPELEngineException(String message) {
            super(message);
        }

        public BPELEngineException(String message, Throwable cause) {
            super(message, cause);
        }

        public BPELEngineException(Throwable cause) {
            super(cause);
        }
    }

    private class ProcessStoreListenerImpl
    implements ProcessStoreListener {
        private ProcessStoreListenerImpl() {
        }

        public void onProcessStoreEvent(ProcessStoreEvent processStoreEvent) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Process store event: " + processStoreEvent));
            }
            ProcessConf pConf = BPELServerImpl.this.processStore.getProcessConfiguration(processStoreEvent.pid);
            switch (processStoreEvent.type) {
                case DEPLOYED: {
                    if (pConf == null) break;
                    BPELServerImpl.this.odeBpelServer.cleanupProcess(pConf);
                    break;
                }
                case ACTIVATED: {
                    BPELServerImpl.this.odeBpelServer.unregister(processStoreEvent.pid);
                    if (pConf != null) {
                        BPELServerImpl.this.odeBpelServer.register(pConf);
                        break;
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("slightly odd:received event " + processStoreEvent + " for process not in store!"));
                    break;
                }
                case RETIRED: {
                    boolean hasInstances = BPELServerImpl.this.odeBpelServer.hasActiveInstances(processStoreEvent.pid);
                    BPELServerImpl.this.odeBpelServer.unregister(processStoreEvent.pid);
                    if (hasInstances) {
                        if (pConf != null) {
                            BPELServerImpl.this.odeBpelServer.register(pConf);
                            break;
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)("slightly odd:received event " + processStoreEvent + " for process not in store!"));
                        break;
                    }
                    if (pConf == null) break;
                    BPELServerImpl.this.odeBpelServer.cleanupProcess(pConf);
                    break;
                }
                case DISABLED: 
                case UNDEPLOYED: {
                    BPELServerImpl.this.odeBpelServer.unregister(processStoreEvent.pid);
                    if (pConf == null) break;
                    BPELServerImpl.this.odeBpelServer.cleanupProcess(pConf);
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Ignoring store event: " + processStoreEvent));
                }
            }
            if (pConf != null) {
                if (processStoreEvent.type == ProcessStoreEvent.Type.UNDEPLOYED) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cancelling all cron scheduled jobs on store event: " + processStoreEvent));
                    }
                    ((BPELServerImpl)BPELServerImpl.this).odeBpelServer.getContexts().cronScheduler.cancelProcessCronJobs(processStoreEvent.pid, true);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("(Re)scheduling cron scheduled jobs on store event: " + processStoreEvent));
                }
                if (processStoreEvent.type != ProcessStoreEvent.Type.UNDEPLOYED) {
                    ((BPELServerImpl)BPELServerImpl.this).odeBpelServer.getContexts().cronScheduler.scheduleProcessCronJobs(processStoreEvent.pid, pConf);
                }
            }
        }
    }
}

