/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.ode.bpel.epr.EndpointFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.epr.WSDL11Endpoint;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.uuid.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.ode.integration.HTTPBindingHandler;
import org.wso2.carbon.bpel.ode.integration.axis2.WSDLAwareSOAPProcessor;
import org.wso2.carbon.bpel.ode.integration.config.EndpointConfiguration;
import org.wso2.carbon.bpel.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.ode.integration.utils.AnonymousServiceFactory;
import org.wso2.carbon.bpel.ode.integration.utils.BPELMessageContextFactory;
import org.wso2.carbon.bpel.ode.integration.utils.FileLoadingUtil;
import org.wso2.carbon.bpel.ode.integration.utils.FileLoadingUtilException;
import org.wso2.carbon.bpel.ode.integration.utils.Messages;
import org.wso2.carbon.bpel.ode.integration.utils.SOAPUtils;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpoint;
import org.wso2.carbon.unifiedendpoint.core.UnifiedEndpointFactory;

public class PartnerService
implements PartnerRoleChannel {
    private static final Log log = LogFactory.getLog(PartnerService.class);
    private static Log messageTraceLog = LogFactory.getLog((String)"org.wso2.carbon.bpel.messagetrace");
    private Definition wsdlDefinition;
    private QName serviceName;
    private String portName;
    private ConfigurationContext clientConfigCtx;
    private ProcessConf processConfiguration;
    private WSAEndpoint endpointReference;
    private String endpointUrl;
    private AxisConfiguration axisConfig;
    private Binding binding;

    public PartnerService(Definition wsdlDefinition, QName serviceName, String portName, ConfigurationContext clientConfigCtx, ProcessConf pconf, HttpConnectionManager connManager) throws AxisFault {
        this.wsdlDefinition = wsdlDefinition;
        this.serviceName = serviceName;
        this.portName = portName;
        this.clientConfigCtx = clientConfigCtx;
        this.processConfiguration = pconf;
        this.axisConfig = clientConfigCtx.getAxisConfiguration();
        this.inferBindingInformation();
        this.clientConfigCtx.setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connManager);
        this.clientConfigCtx.setProperty("REUSE_HTTP_CLIENT", (Object)"false");
        Element eprEle = BPELProcessProxy.genEPRfromWSDL(this.wsdlDefinition, this.serviceName, this.portName);
        if (eprEle == null) {
            throw new IllegalArgumentException("Service Port definition not found for service:" + this.serviceName + " and port:" + this.portName);
        }
        this.endpointReference = EndpointFactory.convertToWSA((MutableEndpoint)BPELProcessProxy.createServiceRef(eprEle));
        this.endpointUrl = this.endpointReference.getUrl();
    }

    public Definition getWsdlDefinition() {
        return this.wsdlDefinition;
    }

    public Binding getBinding() {
        return this.binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(PartnerRoleMessageExchange partnerRoleMessageExchange) {
        boolean isTwoWay = partnerRoleMessageExchange.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        try {
            MessageContext mctx = new MessageContext();
            BPELMessageContext partnerInvocationContext = BPELMessageContextFactory.createBPELMessageContext(mctx, this);
            ExtensibilityElement bindingType = WSDLAwareSOAPProcessor.getBindingExtension(this.binding);
            try {
                if (bindingType instanceof HTTPBinding) {
                    HTTPBindingHandler httpBindingHandler = new HTTPBindingHandler(this.clientConfigCtx, this.serviceName, this.portName, this.wsdlDefinition);
                    HTTPBindingHandler.HTTPBindingResponse response = httpBindingHandler.invoke(partnerRoleMessageExchange, partnerInvocationContext);
                    if (isTwoWay) {
                        Operation operation = partnerRoleMessageExchange.getOperation();
                        MessageContext responseMessageContext = response.getReponseMessageContext();
                        partnerInvocationContext.setInMessageContext(responseMessageContext);
                        MessageContext fltMessageContext = response.getFaultMessageContext();
                        if (messageTraceLog.isTraceEnabled()) {
                            messageTraceLog.trace((Object)("Response message: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + responseMessageContext.getEnvelope()));
                        }
                        if (fltMessageContext != null) {
                            this.replyHTTP(partnerInvocationContext, partnerRoleMessageExchange, operation, fltMessageContext, true);
                        } else {
                            this.replyHTTP(partnerInvocationContext, partnerRoleMessageExchange, operation, responseMessageContext, response.isFault());
                        }
                    } else {
                        partnerRoleMessageExchange.replyOneWayOk();
                    }
                } else {
                    EndpointConfiguration endpointConf = ((ProcessConfigurationImpl)this.processConfiguration).getEndpointConfiguration((org.apache.ode.bpel.iapi.EndpointReference)new WSDL11Endpoint(this.serviceName, this.portName));
                    UnifiedEndpoint partnerEndpoint = this.buildUnifiedEndpoint(endpointConf);
                    SOAPUtils.createSOAPRequest(partnerInvocationContext, partnerRoleMessageExchange);
                    String mexEndpointUrl = ((MutableEndpoint)partnerRoleMessageExchange.getEndpointReference()).getUrl();
                    if (!this.endpointUrl.equals(mexEndpointUrl)) {
                        partnerEndpoint.setAddress(mexEndpointUrl);
                    }
                    OperationClient opClient = this.getOperationClient(isTwoWay, mctx);
                    mctx.getOptions().setParent(opClient.getOptions());
                    opClient.addMessageContext(mctx);
                    Options operationOptions = opClient.getOptions();
                    if (partnerEndpoint.isAddressingEnabled()) {
                        String action = this.getAction(partnerRoleMessageExchange.getOperationName());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Soap action: " + action + " found"));
                        }
                        operationOptions.setAction(action);
                    }
                    operationOptions.setTo((EndpointReference)partnerEndpoint);
                    if (bindingType instanceof HTTPBinding) {
                        operationOptions.setProperty("enableREST", (Object)"true");
                    }
                    if (messageTraceLog.isDebugEnabled()) {
                        messageTraceLog.debug((Object)("Invoking service: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + this.serviceName + "." + partnerRoleMessageExchange.getOperationName()));
                        if (messageTraceLog.isTraceEnabled()) {
                            messageTraceLog.trace((Object)("Request message: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + partnerInvocationContext.getInMessageContext().getEnvelope()));
                        }
                    }
                    opClient.execute(true);
                    if (messageTraceLog.isDebugEnabled()) {
                        messageTraceLog.debug((Object)("Service invocation completed: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + this.serviceName + "." + partnerRoleMessageExchange.getOperationName()));
                    }
                    if (isTwoWay) {
                        Operation operation = partnerRoleMessageExchange.getOperation();
                        MessageContext response = opClient.getMessageContext("In");
                        partnerInvocationContext.setInMessageContext(response);
                        MessageContext flt = opClient.getMessageContext("Fault");
                        if (messageTraceLog.isTraceEnabled()) {
                            messageTraceLog.trace((Object)("Response message: MEXId: " + partnerRoleMessageExchange.getMessageExchangeId() + " :: " + response.getEnvelope()));
                        }
                        if (flt != null) {
                            this.reply(partnerInvocationContext, partnerRoleMessageExchange, operation, flt, true);
                        } else {
                            this.reply(partnerInvocationContext, partnerRoleMessageExchange, operation, response, response.isFault());
                        }
                    } else {
                        partnerRoleMessageExchange.replyOneWayOk();
                    }
                }
            }
            finally {
                TransportOutDescription out = mctx.getTransportOut();
                if (out != null && out.getSender() != null) {
                    out.getSender().cleanup(mctx);
                }
            }
        }
        catch (Throwable t) {
            String errmsg = Messages.msgErrorSendingMessageToAxisForODEMex(partnerRoleMessageExchange.toString());
            log.error((Object)errmsg, t);
            this.replyWithFailure(partnerRoleMessageExchange, MessageExchange.FailureType.COMMUNICATION_ERROR, errmsg);
        }
    }

    private UnifiedEndpoint buildUnifiedEndpoint(EndpointConfiguration endpointConfiguration) throws AxisFault {
        String secPolicyKey;
        UnifiedEndpoint partnerEndpoint;
        UnifiedEndpointFactory uepFactory = new UnifiedEndpointFactory();
        if (endpointConfiguration != null && (endpointConfiguration.getUnifiedEndPoint() != null || endpointConfiguration.getUnifiedEndPointReference() != null)) {
            if (endpointConfiguration.getUnifiedEndPoint() != null) {
                partnerEndpoint = uepFactory.createEndpoint(endpointConfiguration.getUnifiedEndPoint());
            } else {
                String uepConfPath = endpointConfiguration.getUnifiedEndPointReference();
                if (!(uepConfPath.startsWith("gov:") && uepConfPath.startsWith("conf:") && uepConfPath.startsWith("reg:"))) {
                    if (uepConfPath.startsWith("file:")) {
                        uepConfPath = uepConfPath.substring("file:".length());
                    }
                    uepConfPath = PartnerService.isAbsoutePath(uepConfPath) ? "file:" + uepConfPath : this.getAbsolutePath(endpointConfiguration.getBasePath(), uepConfPath);
                }
                partnerEndpoint = uepFactory.createVirtualEndpoint(uepConfPath);
            }
        } else {
            partnerEndpoint = new UnifiedEndpoint();
            partnerEndpoint.setUepId(this.serviceName.getLocalPart());
            partnerEndpoint.setAddressingEnabled(true);
            partnerEndpoint.setAddressingVersion("final");
        }
        if (partnerEndpoint.getAddress() == null) {
            partnerEndpoint.setAddress(this.endpointUrl);
        }
        if (partnerEndpoint.isSecurityEnabled() && (secPolicyKey = partnerEndpoint.getWsSecPolicyKey()).startsWith("file:")) {
            String secPolicyLocation = secPolicyKey.substring("file:".length());
            secPolicyKey = !PartnerService.isAbsoutePath(secPolicyLocation) ? this.getAbsolutePath(endpointConfiguration.getBasePath(), secPolicyLocation) : "file:" + secPolicyLocation;
            partnerEndpoint.setWsSecPolicyKey(secPolicyKey);
        }
        return partnerEndpoint;
    }

    private String getAbsolutePath(String basePath, String filePath) {
        return "file:" + basePath + File.separator + filePath;
    }

    public static boolean isAbsoutePath(String filePath) {
        return filePath.startsWith("/") || filePath.length() > 1 && filePath.charAt(1) == ':';
    }

    private void inferBindingInformation() {
        Service serviceDef = this.wsdlDefinition.getService(this.serviceName);
        if (serviceDef == null) {
            throw new NullPointerException(Messages.msgServiceDefinitionNotFound(this.serviceName.getLocalPart()));
        }
        Port port = serviceDef.getPort(this.portName);
        if (port == null) {
            throw new NullPointerException(Messages.msgServicePortNotFound(this.serviceName.getLocalPart(), this.portName));
        }
        this.binding = port.getBinding();
        if (this.binding == null) {
            throw new NullPointerException(Messages.msgBindingNotFound(this.serviceName.getLocalPart(), this.portName));
        }
    }

    private void replyWithFailure(PartnerRoleMessageExchange odeMex, MessageExchange.FailureType error, String errmsg) {
        try {
            odeMex.replyWithFailure(error, errmsg, null);
        }
        catch (Exception e) {
            String emsg = "Error executing replyWithFailure; reply will be lost.";
            log.error((Object)emsg, (Throwable)e);
        }
    }

    private void reply(BPELMessageContext partnerInvocationContext, PartnerRoleMessageExchange odeMex, Operation operation, MessageContext reply, boolean isFault) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received response for MEX " + odeMex));
            }
            if (isFault) {
                Document odeMsg = DOMUtils.newDocument();
                Element odeMsgEl = odeMsg.createElementNS(null, "message");
                odeMsg.appendChild(odeMsgEl);
                Fault fault = SOAPUtils.parseSoapFault(odeMsgEl, reply.getEnvelope(), operation);
                if (fault != null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Fault response: faultName=" + fault.getName() + " faultType=" + fault.getMessage().getQName() + "\n" + DOMUtils.domToString((Node)odeMsgEl)));
                    }
                    QName faultType = fault.getMessage().getQName();
                    QName faultName = new QName(this.wsdlDefinition.getTargetNamespace(), fault.getName());
                    Message response = odeMex.createMessage(faultType);
                    response.setMessage(odeMsgEl);
                    odeMex.replyWithFault(faultName, response);
                } else {
                    SOAPFault soapFault = reply.getEnvelope().getBody().getFault();
                    QName faultType = new QName(this.wsdlDefinition.getTargetNamespace(), "UnknownFault");
                    Message response = odeMex.createMessage(faultType);
                    Element actAsPart = odeMsgEl.getOwnerDocument().createElementNS(null, soapFault.getLocalName());
                    odeMsgEl.appendChild(actAsPart);
                    if (soapFault.getCode() != null) {
                        actAsPart.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)soapFault.getCode()), true));
                    }
                    if (soapFault.getReason() != null) {
                        actAsPart.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)soapFault.getReason()), true));
                    }
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Fault response: " + DOMUtils.domToString((Node)odeMsgEl)));
                    }
                    response.setMessage(odeMsgEl);
                    odeMex.replyWithFault(faultType, response);
                }
            } else {
                Message response = SOAPUtils.parseSOAPResponseFromPartner(partnerInvocationContext, (MessageExchange)odeMex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response:\n" + (response.getMessage() != null ? DOMUtils.domToString((Node)response.getMessage()) : "empty")));
                }
                odeMex.reply(response);
            }
        }
        catch (Exception ex) {
            String errmsg = "Unable to process response: " + ex.getMessage();
            log.error((Object)errmsg, (Throwable)ex);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
        }
    }

    private void replyHTTP(BPELMessageContext partnerInvocationContext, PartnerRoleMessageExchange odeMex, Operation operation, MessageContext reply, boolean isFault) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received response for MEX " + odeMex));
            }
            if (isFault) {
                Document odeMsg = DOMUtils.newDocument();
                Element odeMsgEl = odeMsg.createElementNS(null, "message");
                odeMsg.appendChild(odeMsgEl);
                QName faultType = new QName("http://wso2.org/bps/fault", "HTTPBindingFault");
                QName faultName = new QName("http://wso2.org/bps/fault", "RESTPartnerServiceError");
                Element fault = odeMsg.createElementNS(null, "fault");
                fault.setTextContent("Error returned from REST Partner");
                odeMsgEl.appendChild(fault);
                Message response = odeMex.createMessage(faultType);
                response.setMessage(odeMsgEl);
                odeMex.replyWithFault(faultName, response);
            } else {
                Message response = SOAPUtils.parseResponseFromRESTService(partnerInvocationContext, odeMex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response:\n" + (response.getMessage() != null ? DOMUtils.domToString((Node)response.getMessage()) : "empty")));
                }
                odeMex.reply(response);
            }
        }
        catch (Exception ex) {
            String errmsg = "Unable to process response: " + ex.getMessage();
            log.error((Object)errmsg, (Throwable)ex);
            odeMex.replyWithFailure(MessageExchange.FailureType.OTHER, errmsg, null);
        }
    }

    private void populateWSAddressingOptions(MessageContext ctxt, PartnerRoleMessageExchange odeMex) {
        WSAEndpoint targetWSAEPR = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)odeMex.getEndpointReference()));
        WSAEndpoint myRoleWSAEPR = EndpointFactory.convertToWSA((MutableEndpoint)((MutableEndpoint)odeMex.getMyRoleEndpointReference()));
        WSAEndpoint targetEPR = new WSAEndpoint(targetWSAEPR);
        String partnerSessionId = odeMex.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
        String myRoleSessionId = odeMex.getProperty("org.apache.ode.bpel.myRoleSessionId");
        if (partnerSessionId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Partner session identifier found for WSA endpoint: " + partnerSessionId));
            }
            targetEPR.setSessionId(partnerSessionId);
        }
        if (myRoleWSAEPR != null) {
            WSAEndpoint myRoleEPR = new WSAEndpoint(myRoleWSAEPR);
            if (myRoleSessionId != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MyRole session identifier found for myrole (callback) WSA endpoint: " + myRoleSessionId));
                }
                myRoleEPR.setSessionId(myRoleSessionId);
            }
            EndpointReference replyToEP = new EndpointReference();
            replyToEP.setAddress(myRoleEPR.getUrl());
            ctxt.setReplyTo(replyToEP);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"My-Role EPR not specified, SEP will not be used.");
        }
        String action = this.getAction(odeMex.getOperationName());
        ctxt.setSoapAction(action);
        if (MessageExchange.MessageExchangePattern.REQUEST_RESPONSE == odeMex.getMessageExchangePattern()) {
            EndpointReference annonEpr = new EndpointReference(Namespaces.WS_ADDRESSING_ANON_URI);
            ctxt.setReplyTo(annonEpr);
            ctxt.setMessageID("uuid:" + new UUID().toString());
        }
    }

    private OperationClient getOperationClient(boolean isTwoWay, MessageContext msgCtx) throws AxisFault {
        AxisService anonymousService = AnonymousServiceFactory.getAnonymousService(this.serviceName, this.portName, this.axisConfig);
        anonymousService.engageModule(this.axisConfig.getModule("UEPModule"));
        anonymousService.getParent().addParameter("hiddenService", (Object)"true");
        ServiceGroupContext sgc = new ServiceGroupContext(this.clientConfigCtx, (AxisServiceGroup)anonymousService.getParent());
        ServiceContext serviceCtx = sgc.getServiceContext(anonymousService);
        AxisOperation axisAnonymousOperation = anonymousService.getOperation(isTwoWay ? ServiceClient.ANON_OUT_IN_OP : ServiceClient.ANON_OUT_ONLY_OP);
        Options clientOptions = PartnerService.cloneOptions(msgCtx.getOptions());
        clientOptions.setExceptionToBeThrownOnSOAPFault(false);
        clientOptions.setTimeOutInMilliSeconds(60000L);
        return axisAnonymousOperation.createClient(serviceCtx, clientOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy loadPolicy(String fileName, String basePath) {
        Policy policyDoc = null;
        FileLoadingUtil fileLoader = new FileLoadingUtil(basePath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Applying security policy: " + fileName));
        }
        try {
            InputStream policyStream = fileLoader.load(fileName);
            try {
                policyDoc = PolicyEngine.getPolicy((InputStream)policyStream);
            }
            finally {
                policyStream.close();
            }
        }
        catch (IOException e) {
            String errMsg = "Exception while parsing policy: " + fileName;
            log.error((Object)errMsg, (Throwable)e);
            throw new IllegalArgumentException("Exception while parsing policy: " + fileName, e);
        }
        catch (FileLoadingUtilException e) {
            String errMsg = "File Loading Exception";
            log.error((Object)errMsg, (Throwable)e);
            throw new IllegalArgumentException(errMsg, e);
        }
        return policyDoc;
    }

    private String getAction(String operation) {
        String action = this.getWSAInputAction(operation);
        if (action == null || "".equals(action)) {
            action = this.getSoapAction(operation);
        }
        return action;
    }

    public String getWSAInputAction(String operation) {
        Object actionQName;
        BindingOperation bop = this.binding.getBindingOperation(operation, null, null);
        if (bop == null) {
            return "";
        }
        Input input = bop.getOperation().getInput();
        if (input != null && (actionQName = input.getExtensionAttribute(new QName(Namespaces.WS_ADDRESSING_NS, "Action"))) != null && actionQName instanceof QName) {
            return ((QName)actionQName).getLocalPart();
        }
        return "";
    }

    public String getSoapAction(String operation) {
        BindingOperation bop = this.binding.getBindingOperation(operation, null, null);
        if (bop == null) {
            return "";
        }
        Iterator i$ = CollectionsX.filter((Collection)bop.getExtensibilityElements(), SOAPOperation.class).iterator();
        if (i$.hasNext()) {
            SOAPOperation soapOp = (SOAPOperation)i$.next();
            return soapOp.getSoapActionURI();
        }
        return "";
    }

    public static Options cloneOptions(Options options) {
        Options clonedOptions = new Options(options.getParent());
        clonedOptions.setCallTransportCleanup(options.isCallTransportCleanup());
        clonedOptions.setExceptionToBeThrownOnSOAPFault(options.isExceptionToBeThrownOnSOAPFault());
        clonedOptions.setManageSession(options.isManageSession());
        clonedOptions.setSoapVersionURI(options.getSoapVersionURI());
        clonedOptions.setTimeOutInMilliSeconds(options.getTimeOutInMilliSeconds());
        clonedOptions.setUseSeparateListener(options.isUseSeparateListener());
        clonedOptions.setListener(options.getListener());
        clonedOptions.setTransportIn(options.getTransportIn());
        clonedOptions.setTransportInProtocol(options.getTransportInProtocol());
        clonedOptions.setTransportOut(clonedOptions.getTransportOut());
        clonedOptions.setUserName(options.getUserName());
        clonedOptions.setPassword(options.getPassword());
        Iterator i$ = options.getProperties().keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String key = o = (String)i$.next();
            clonedOptions.setProperty(key, options.getProperty(key));
        }
        return clonedOptions;
    }

    public org.apache.ode.bpel.iapi.EndpointReference getInitialEndpointReference() {
        return this.endpointReference;
    }

    public void close() {
    }
}

