/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.axis2;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.hooks.ODEAxisService;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class Axis2UriResolver
implements URIResolver {
    private static final Log log = LogFactory.getLog(ODEAxisService.class);

    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolveEntity: targetNamespace=" + targetNamespace + " schemaLocation=" + schemaLocation + " baseUri=" + baseUri));
        }
        try {
            URI base = new URI(baseUri);
            URI uri = base.resolve(schemaLocation);
            InputStream is = uri.toURL().openStream();
            if (is == null) {
                log.error((Object)("Exception resolving entity: schemaLocation=" + schemaLocation + " baseUri=" + baseUri));
                return null;
            }
            InputSource source = new InputSource(is);
            source.setSystemId(uri.toString());
            source.setPublicId(schemaLocation);
            return new InputSource(is);
        }
        catch (Exception e) {
            log.error((Object)("Exception resolving entity: schemaLocation=" + schemaLocation + " baseUri=" + baseUri), (Throwable)e);
            return null;
        }
    }
}

