/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.axis2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.stl.CollectionsX;
import org.wso2.carbon.bpel.ode.integration.axis2.WSDLAwareMessage;

public class WSDLAwareSOAPProcessor {
    private static Log log = LogFactory.getLog(WSDLAwareSOAPProcessor.class);
    private Definition wsdlDef;
    private boolean isRPC;
    private SOAPFactory soapFactory;
    private QName serviceName;
    private String portName;
    private Service wsdlServiceDef;
    private Binding wsdlBinding;
    private MessageContext inMessageCtx;
    static final String WSDL_4_J_DEFINITION = "wsdl4jDefinition";
    static final String WSDL_BINDING_STYLE_RPC = "rpc";

    public WSDLAwareSOAPProcessor(MessageContext inMsgCtx) throws AxisFault {
        this.inMessageCtx = inMsgCtx;
        AxisService axisService = inMsgCtx.getAxisService();
        this.serviceName = new QName(axisService.getTargetNamespace(), axisService.getName());
        this.wsdlDef = (Definition)axisService.getParameter(WSDL_4_J_DEFINITION).getValue();
        if (this.wsdlDef == null) {
            throw new AxisFault("No WSDL Definition was found for service " + this.serviceName.getLocalPart() + ".");
        }
        this.wsdlServiceDef = this.wsdlDef.getService(this.serviceName);
        if (this.wsdlServiceDef == null) {
            throw new AxisFault("WSDL Service Definition not found for service " + this.serviceName.getLocalPart());
        }
        AxisEndpoint axisEndpoint = (AxisEndpoint)inMsgCtx.getProperty("endpoint");
        if (axisEndpoint == null) {
            String defaultEndpointName = axisService.getEndpointName();
            axisEndpoint = (AxisEndpoint)axisService.getEndpoints().get(defaultEndpointName);
            if (axisEndpoint == null) {
                throw new AxisFault("AxisEndpoint cannot be null.");
            }
        }
        this.portName = axisEndpoint.getName();
        AxisBinding axisBinding = axisEndpoint.getBinding();
        QName bindingQName = axisBinding.getName();
        this.wsdlBinding = this.wsdlDef.getBinding(bindingQName);
        if (this.wsdlBinding == null) {
            throw new AxisFault("WSDL Binding null for incoming message.");
        }
        ExtensibilityElement bindingType = WSDLAwareSOAPProcessor.getBindingExtension(this.wsdlBinding);
        if (!(bindingType instanceof SOAPBinding || bindingType instanceof SOAP12Binding || bindingType instanceof HTTPBinding)) {
            throw new AxisFault("WSDL Binding not supported.");
        }
        this.isRPC = WSDLAwareSOAPProcessor.isRPC(bindingType);
        this.soapFactory = (SOAPFactory)inMsgCtx.getEnvelope().getOMFactory();
        if (this.soapFactory == null) {
            this.soapFactory = bindingType instanceof SOAPBinding ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        }
    }

    public static boolean isRPC(ExtensibilityElement bindingType) {
        if (bindingType instanceof SOAPBinding) {
            return ((SOAPBinding)bindingType).getStyle() != null && ((SOAPBinding)bindingType).getStyle().equals(WSDL_BINDING_STYLE_RPC);
        }
        if (bindingType instanceof SOAP12Binding) {
            return ((SOAP12Binding)bindingType).getStyle() != null && ((SOAP12Binding)bindingType).getStyle().equals(WSDL_BINDING_STYLE_RPC);
        }
        if (bindingType instanceof HTTPBinding) {
            // empty if block
        }
        return false;
    }

    public WSDLAwareMessage parseRequest() throws AxisFault {
        BindingOperation bindingOp = this.wsdlBinding.getBindingOperation(this.wsdlBinding.getPortType().getOperation(this.inMessageCtx.getAxisOperation().getName().getLocalPart(), null, null).getName(), null, null);
        if (bindingOp == null) {
            throw new AxisFault("WSDL binding operation not found for service: " + this.serviceName.getLocalPart() + " port: " + this.portName);
        }
        BindingInput bindingInput = bindingOp.getBindingInput();
        if (bindingInput == null) {
            throw new AxisFault("BindingInput not found for service: " + this.serviceName.getLocalPart() + " port: " + this.portName);
        }
        return this.processMessageParts(bindingInput);
    }

    private WSDLAwareMessage processMessageParts(BindingInput bindingInput) throws AxisFault {
        WSDLAwareMessage message = new WSDLAwareMessage();
        message.setBinding(this.wsdlBinding);
        SOAPBody soapBodyDef = WSDLAwareSOAPProcessor.getFirstExtensibilityElement((ElementExtensible)bindingInput, SOAPBody.class);
        if (soapBodyDef == null) {
            String errMessage = "SOAPBody null for binding input.";
            log.error((Object)errMessage);
            throw new AxisFault(errMessage);
        }
        QName axisOperationName = this.inMessageCtx.getAxisOperation().getName();
        Operation op = this.wsdlBinding.getPortType().getOperation(axisOperationName.getLocalPart(), null, null);
        String rpcWrapper = op.getName();
        List bodyParts = op.getInput().getMessage().getOrderedParts(soapBodyDef.getParts());
        if (this.isRPC) {
            message.setRPC(true);
            QName rpWrapperQName = new QName(soapBodyDef.getNamespaceURI(), rpcWrapper);
            OMElement partWrapper = this.inMessageCtx.getEnvelope().getBody().getFirstChildWithName(rpWrapperQName);
            if (partWrapper == null) {
                String errMsg = "SOAP Body doesn't contain expected part wrapper.";
                log.error((Object)errMsg);
                throw new AxisFault(errMsg);
            }
            for (Object partDef : bodyParts) {
                OMElement srcPart = partWrapper.getFirstChildWithName(new QName(null, ((Part)partDef).getName()));
                if (srcPart == null) {
                    throw new AxisFault("SOAP Body doesn't contain required part " + ((Part)partDef).getName() + ".");
                }
                message.addBodyPart(srcPart.getLocalName(), srcPart);
            }
        } else {
            message.setRPC(false);
            Iterator srcParts = this.inMessageCtx.getEnvelope().getBody().getChildElements();
            for (Object partDef : bodyParts) {
                if (!srcParts.hasNext()) {
                    throw new AxisFault("SOAP Body does not contain required part" + ((Part)partDef).getName() + ".");
                }
                OMElement srcPart = (OMElement)srcParts.next();
                if (((Part)partDef).getElementName() == null) {
                    throw new AxisFault("Binding defines non-element document literal part(s)");
                }
                if (!srcPart.getQName().equals(((Part)partDef).getElementName())) {
                    throw new AxisFault("Unexpected element in SOAP body.");
                }
                message.addBodyPart(((Part)partDef).getName(), srcPart);
            }
        }
        this.processSoapHeaderParts(message, bindingInput, op);
        return message;
    }

    private void processSoapHeaderParts(WSDLAwareMessage message, BindingInput bindingInput, Operation op) throws AxisFault {
        List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs = WSDLAwareSOAPProcessor.getSOAPHeaders((ElementExtensible)bindingInput);
        SOAPHeader soapHeader = this.inMessageCtx.getEnvelope().getHeader();
        for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
            this.handleSoapHeaderPartDef(message, headerDef, op.getInput().getMessage(), soapHeader);
        }
        if (soapHeader != null) {
            Iterator headersIter = soapHeader.getChildElements();
            while (headersIter.hasNext()) {
                OMElement header = (OMElement)headersIter.next();
                String partName = this.findHeaderPartName(headerDefs, header.getQName());
                message.addHeaderPart(partName, header);
            }
        }
    }

    private void handleSoapHeaderPartDef(WSDLAwareMessage message, javax.wsdl.extensions.soap.SOAPHeader headerDef, Message msgType, SOAPHeader soapHeader) throws AxisFault {
        boolean requiredHeader;
        boolean payloadMessageHeader = headerDef.getMessage() == null || headerDef.getMessage().equals(msgType.getQName());
        boolean bl = requiredHeader = payloadMessageHeader || headerDef.getRequired() != null && headerDef.getRequired() != false;
        if (requiredHeader && soapHeader == null) {
            throw new AxisFault("Missing required SOAP header element.");
        }
        if (soapHeader == null) {
            return;
        }
        Message headerMsg = this.wsdlDef.getMessage(headerDef.getMessage());
        if (headerMsg == null) {
            return;
        }
        Part p = headerMsg.getPart(headerDef.getPart());
        if (p == null || p.getElementName() == null) {
            return;
        }
        OMElement headerEl = soapHeader.getFirstChildWithName(p.getElementName());
        if (requiredHeader && headerEl == null) {
            throw new AxisFault("Missing required SOAP header element.");
        }
        if (headerEl == null) {
            return;
        }
        message.addHeaderPart(p.getName(), headerEl);
    }

    private String findHeaderPartName(List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, QName elementName) {
        for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
            Message hdrMsg = this.wsdlDef.getMessage(headerDef.getMessage());
            for (Object o : hdrMsg.getParts().values()) {
                Part p = (Part)o;
                if (!p.getElementName().equals(elementName)) continue;
                return p.getName();
            }
        }
        return elementName.getLocalPart();
    }

    public static List<javax.wsdl.extensions.soap.SOAPHeader> getSOAPHeaders(ElementExtensible eee) {
        return (List)CollectionsX.filter(new ArrayList(), (Collection)eee.getExtensibilityElements(), javax.wsdl.extensions.soap.SOAPHeader.class);
    }

    public static <T> T getFirstExtensibilityElement(ElementExtensible parent, Class<T> cls) {
        Collection ee = CollectionsX.filter((Collection)parent.getExtensibilityElements(), cls);
        return ee.isEmpty() ? null : (T)ee.iterator().next();
    }

    public static ExtensibilityElement getBindingExtension(Binding binding) {
        ArrayList bindings = new ArrayList();
        CollectionsX.filter(bindings, (Collection)binding.getExtensibilityElements(), HTTPBinding.class);
        CollectionsX.filter(bindings, (Collection)binding.getExtensibilityElements(), SOAPBinding.class);
        CollectionsX.filter(bindings, (Collection)binding.getExtensibilityElements(), SOAP12Binding.class);
        if (bindings.size() == 0) {
            return null;
        }
        if (bindings.size() > 1) {
            throw new IllegalArgumentException("Multiple bindings: " + binding.getQName());
        }
        return (ExtensibilityElement)bindings.iterator().next();
    }
}

