/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.axis2.receivers;

import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractInMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.ode.integration.utils.BPELMessageContextFactory;

public class BPELMessageReceiver
extends AbstractInMessageReceiver {
    private static Log log = LogFactory.getLog(BPELMessageReceiver.class);
    private static Log messageTraceLog = LogFactory.getLog((String)"org.wso2.carbon.bpel.messagetrace");
    private BPELProcessProxy processProxy;

    protected final void invokeBusinessLogic(MessageContext inMessageContext) throws AxisFault {
        if (messageTraceLog.isDebugEnabled()) {
            messageTraceLog.debug((Object)("Message received: Message Id: " + inMessageContext.getMessageID() + " :: " + inMessageContext.getAxisService().getName() + "." + inMessageContext.getAxisOperation().getName()));
            if (messageTraceLog.isTraceEnabled()) {
                messageTraceLog.trace((Object)("Request message: Message Id: " + inMessageContext.getMessageID() + " :: " + inMessageContext.getEnvelope()));
            }
        }
        SOAPFactory soapFactory = this.getSOAPFactory(inMessageContext);
        BPELMessageContext bpelMessageContext = BPELMessageContextFactory.createBPELMessageContext(inMessageContext, this.processProxy, soapFactory);
        if (BPELMessageContextFactory.hasResponse(inMessageContext.getAxisOperation())) {
            this.handleInOutOperation(bpelMessageContext);
        } else {
            this.handleInOnlyOperation(bpelMessageContext);
        }
        if (messageTraceLog.isDebugEnabled()) {
            messageTraceLog.debug((Object)("Reply Sent: Message Id: " + inMessageContext.getMessageID() + " :: " + inMessageContext.getAxisService().getName() + "." + inMessageContext.getAxisOperation().getName()));
            if (messageTraceLog.isTraceEnabled()) {
                messageTraceLog.trace((Object)("Response message: Message Id: " + inMessageContext.getMessageID() + " :: " + bpelMessageContext.getOutMessageContext().getEnvelope()));
            }
        }
    }

    public final void setProcessProxy(BPELProcessProxy processProxy) {
        this.processProxy = processProxy;
    }

    private void handleInOutOperation(BPELMessageContext bpelMessageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received request message for " + bpelMessageContext.getInMessageContext().getAxisService().getName() + "." + bpelMessageContext.getInMessageContext().getAxisOperation().getName()));
        }
        this.processProxy.onAxisServiceInvoke(bpelMessageContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reply for " + bpelMessageContext.getInMessageContext().getAxisService().getName() + "." + bpelMessageContext.getInMessageContext().getAxisOperation().getName()));
            log.debug((Object)("\tReply message " + bpelMessageContext.getOutMessageContext().getEnvelope()));
        }
        AxisEngine.send((MessageContext)bpelMessageContext.getOutMessageContext());
    }

    private void handleInOnlyOperation(BPELMessageContext bpelMessageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received one-way message for " + bpelMessageContext.getInMessageContext().getAxisService().getName() + "." + bpelMessageContext.getInMessageContext().getAxisOperation().getName()));
        }
        this.processProxy.onAxisServiceInvoke(bpelMessageContext);
    }
}

