/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.mgt.services;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.ode.integration.BPELConstants;
import org.wso2.carbon.bpel.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.ode.integration.store.TenantProcessStoreImpl;
import org.wso2.carbon.bpel.ode.integration.store.repository.BPELPackageInfo;
import org.wso2.carbon.bpel.ode.integration.store.repository.BPELPackageRepository;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.BPELPackageManagementServiceSkeletonInterface;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.PackageManagementException;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.DeployedPackagesPaginated;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PackageStatusType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Package_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessesInPackage;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.UndeployStatus_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Versions_type0;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BPELPackageManagementServiceSkeleton
extends AbstractAdmin
implements BPELPackageManagementServiceSkeletonInterface {
    private static Log log = LogFactory.getLog(BPELPackageManagementServiceSkeleton.class);

    public ProcessesInPackage listProcessesInPackage(String packageName) {
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        ProcessesInPackage processInPackage = new ProcessesInPackage();
        processInPackage.setPackageName(packageName);
        List<QName> processIds = tenantProcessStore.getProcessesInPackage(packageName);
        for (QName pid : processIds) {
            processInPackage.addProcess(pid.toString());
        }
        return processInPackage;
    }

    @Override
    public UndeployStatus_type0 undeployBPELPackage(String packageName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting undeployment of BPEL package " + packageName));
        }
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        try {
            tenantProcessStore.undeploy(packageName);
        }
        catch (Exception e) {
            log.error((Object)("Undeploying BPEL package " + packageName + " failed."), (Throwable)e);
            return UndeployStatus_type0.FAILED;
        }
        return UndeployStatus_type0.SUCCESS;
    }

    @Override
    public DeployedPackagesPaginated listDeployedPackagesPaginated(int page) throws PackageManagementException {
        List<BPELPackageInfo> packages;
        DeployedPackagesPaginated paginatedPackages = new DeployedPackagesPaginated();
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        BPELPackageRepository packageRepo = tenantProcessStore.getBPELPackageRepository();
        try {
            packages = packageRepo.getBPELPackages();
        }
        catch (Exception e) {
            String errorMessage = "Cannot get the BPEL Package list from repository.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new PackageManagementException(errorMessage, e);
        }
        if (packages != null) {
            if (page < 0 || page == Integer.MAX_VALUE) {
                page = 0;
            }
            int startIndex = page * BPELConstants.ITEMS_PER_PAGE;
            int endIndex = (page + 1) * BPELConstants.ITEMS_PER_PAGE;
            int numberOfPackages = packages.size();
            int pages = (int)Math.ceil((double)numberOfPackages / (double)BPELConstants.ITEMS_PER_PAGE.intValue());
            paginatedPackages.setPages(pages);
            BPELPackageInfo[] packagesArray = packages.toArray(new BPELPackageInfo[numberOfPackages]);
            for (int i = startIndex; i < endIndex && i < numberOfPackages; ++i) {
                paginatedPackages.add_package(this.getPackageInfo(packagesArray[i]));
            }
            return paginatedPackages;
        }
        paginatedPackages.setPages(0);
        return paginatedPackages;
    }

    private Package_type0 getPackageInfo(BPELPackageInfo packageInfo) {
        Package_type0 bpelPackage = new Package_type0();
        bpelPackage.setName(packageInfo.getName());
        bpelPackage.setState(this.convertToPackageStatusType(packageInfo.getStatus()));
        bpelPackage.setVersions(this.getAllVersionsOfPackage(packageInfo));
        bpelPackage.setErrorLog(packageInfo.getCauseForDeploymentFailure());
        return bpelPackage;
    }

    private Versions_type0 getAllVersionsOfPackage(BPELPackageInfo packageInfo) {
        List<String> versions = packageInfo.getAvailableVersions();
        Versions_type0 versionsOfBPELPackage = new Versions_type0();
        for (String version : versions) {
            versionsOfBPELPackage.addPackageName(version);
        }
        return versionsOfBPELPackage;
    }

    private PackageStatusType convertToPackageStatusType(BPELPackageInfo.Status status) {
        if (status.equals((Object)BPELPackageInfo.Status.DEPLOYED)) {
            return PackageStatusType.DEPLOYED;
        }
        if (status.equals((Object)BPELPackageInfo.Status.UNDEPLOYED)) {
            return PackageStatusType.UNDEPLOYED;
        }
        if (status.equals((Object)BPELPackageInfo.Status.FAILED)) {
            return PackageStatusType.FAILED;
        }
        if (status.equals((Object)BPELPackageInfo.Status.UPDATED)) {
            return PackageStatusType.UPDATED;
        }
        return PackageStatusType.UNDEFINED;
    }

    private TenantProcessStoreImpl getTenantProcessStore() {
        ConfigurationContext configContext = this.getConfigContext();
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configContext);
        BPELServerImpl bpelServer = BPELServerImpl.getInstance();
        return (TenantProcessStoreImpl)bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
    }
}

