/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.mgt.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.common.ProcessFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.dd.TService;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.pmapi.ProcessInfoCustomizer;
import org.apache.ode.bpel.pmapi.TInstanceStatus;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.ode.integration.store.TenantProcessStoreImpl;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.ProcessManagementException;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.ProcessManagementServiceSkeletonInterface;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.BpelDefinition;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.DefinitionInfo;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.DeploymentInfo;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EndpointRef_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.EndpointReferencesType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.FailuresInfo;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceStatus;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.InstanceSummary;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Instances_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.LimitedProcessInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PaginatedProcessInfoList;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessProperties;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ProcessStatus;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Property_type0;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.ServiceLocation;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.service.mgt.util.Utils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ProcessManagementServiceSkeleton
extends AbstractAdmin
implements ProcessManagementServiceSkeletonInterface {
    private static Log log = LogFactory.getLog(ProcessManagementServiceSkeleton.class);
    private BPELServerImpl bpelServer = BPELServerImpl.getInstance();
    private BpelDatabase bpelDb = this.bpelServer.getODEBPELServer().getBpelDb();
    private Calendar calendar = Calendar.getInstance();
    private static Integer ITEMS_PER_PAGE = 10;

    @Override
    public PaginatedProcessInfoList getPaginatedProcessList(String processListFilter, String processListOrderByKey, int page) throws ProcessManagementException {
        PaginatedProcessInfoList processList = new PaginatedProcessInfoList();
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        if (page < 0 || page == Integer.MAX_VALUE) {
            page = 0;
        }
        Integer startIndexForCurrentPage = page * ITEMS_PER_PAGE;
        Integer endIndexForCurrentPage = (page + 1) * ITEMS_PER_PAGE;
        ProcessFilter processFilter = new ProcessFilter(processListFilter, processListOrderByKey);
        Collection<ProcessConf> processListForCurrentPage = this.processQuery(processFilter, tenantProcessStore);
        Integer processListSize = processListForCurrentPage.size();
        Integer pages = (int)Math.ceil((double)processListSize.intValue() / (double)ITEMS_PER_PAGE.intValue());
        processList.setPages(pages);
        ProcessConf[] processConfigurations = processListForCurrentPage.toArray(new ProcessConf[processListSize.intValue()]);
        for (int i = startIndexForCurrentPage.intValue(); i < endIndexForCurrentPage && i < processListSize; ++i) {
            processList.addProcessInfo(this.createLimitedProcessInfoObject(processConfigurations[i]));
        }
        return processList;
    }

    @Override
    public String[] getAllProcesses(String getAllProcesses) throws ProcessManagementException {
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        Set<QName> processIds = tenantProcessStore.getProcesses().keySet();
        ArrayList<String> pids = new ArrayList<String>();
        for (QName pid : processIds) {
            pids.add(pid.toString());
        }
        return pids.toArray(new String[pids.size()]);
    }

    @Override
    public void retireProcess(QName pid) throws ProcessManagementException {
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        try {
            tenantProcessStore.setState(pid, ProcessState.RETIRED);
        }
        catch (Exception e) {
            String errMsg = "Process: " + pid + " retirement failed.";
            log.error((Object)errMsg, (Throwable)e);
            throw new ProcessManagementException(errMsg);
        }
    }

    @Override
    public void activateProcess(QName pid) throws ProcessManagementException {
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        try {
            tenantProcessStore.setState(pid, ProcessState.ACTIVE);
        }
        catch (Exception e) {
            String errMsg = "Process: " + pid + " activation failed.";
            log.error((Object)errMsg, (Throwable)e);
            throw new ProcessManagementException(errMsg);
        }
    }

    @Override
    public ProcessInfoType getProcessInfo(QName pid) throws ProcessManagementException {
        ProcessInfoType processInfoType = new ProcessInfoType();
        TenantProcessStoreImpl tenantProcessStore = this.getTenantProcessStore();
        ProcessConf processConf = tenantProcessStore.getProcessConfiguration(pid);
        this.fillProcessInfo(processInfoType, processConf, ProcessInfoCustomizer.ALL, tenantProcessStore);
        return processInfoType;
    }

    private String[] getServiceLocationForProcess(QName processId) throws ProcessManagementException {
        AxisConfiguration axisConf = this.getConfigContext().getAxisConfiguration();
        HashMap services = axisConf.getServices();
        ArrayList<String> serviceEPRs = new ArrayList<String>();
        for (AxisService service : services.values()) {
            Parameter pIdParam = service.getParameter("processId");
            if (pIdParam == null || !pIdParam.getValue().equals(processId)) continue;
            serviceEPRs.addAll(Arrays.asList(service.getEPRs()));
        }
        if (serviceEPRs.size() > 0) {
            return serviceEPRs.toArray(new String[serviceEPRs.size()]);
        }
        String errMsg = "Cannot find service for process: " + processId;
        log.error((Object)errMsg);
        throw new ProcessManagementException(errMsg);
    }

    private void fillPartnerLinks(ProcessInfoType pInfo, TDeployment.Process processInfo) throws ProcessManagementException {
        if (processInfo.getProvideList() != null) {
            EndpointReferencesType eprsType = new EndpointReferencesType();
            for (TProvide provide : processInfo.getProvideList()) {
                String plinkName = provide.getPartnerLink();
                TService service = provide.getService();
                if (service == null) {
                    String errorMsg = "Error in <provide> element for process " + processInfo.getName() + " partnerlink" + plinkName + " did not identify an endpoint";
                    log.error((Object)errorMsg);
                    throw new ProcessManagementException(errorMsg);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing <provide> element for process " + processInfo.getName() + ": partnerlink " + plinkName + " --> " + service.getName() + " : " + service.getPort()));
                }
                QName serviceName = service.getName();
                EndpointRef_type0 eprType = new EndpointRef_type0();
                eprType.setPartnerLink(plinkName);
                eprType.setService(serviceName);
                ServiceLocation sLocation = new ServiceLocation();
                try {
                    String url = Utils.getTryitURL((String)serviceName.getLocalPart(), (ConfigurationContext)this.getConfigContext());
                    sLocation.addServiceLocation(url);
                }
                catch (AxisFault axisFault) {
                    String errMsg = "Error while getting try-it url for the service: " + serviceName;
                    log.error((Object)errMsg, (Throwable)axisFault);
                    throw new ProcessManagementException(errMsg, axisFault);
                }
                eprType.setServiceLocations(sLocation);
                eprsType.addEndpointRef(eprType);
            }
            pInfo.setEndpoints(eprsType);
        }
    }

    private LimitedProcessInfoType createLimitedProcessInfoObject(ProcessConf processConf) {
        LimitedProcessInfoType processInfoObject = new LimitedProcessInfoType();
        processInfoObject.setPid(processConf.getProcessId().toString());
        processInfoObject.setDeployedDate(this.toCalendar(processConf.getDeployDate()));
        processInfoObject.setVersion(processConf.getVersion());
        if (processConf.getState() == ProcessState.RETIRED) {
            processInfoObject.setStatus(ProcessStatus.RETIRED);
        } else if (processConf.getState() == ProcessState.DISABLED) {
            processInfoObject.setStatus(ProcessStatus.DISABLED);
        } else {
            processInfoObject.setStatus(ProcessStatus.ACTIVE);
        }
        if (processConf.getState() == ProcessState.RETIRED) {
            processInfoObject.setStatus(ProcessStatus.RETIRED);
            processInfoObject.setOlderVersion(this.isOlderVersion(processConf, this.getTenantProcessStore()));
        } else if (processConf.getState() == ProcessState.DISABLED) {
            processInfoObject.setStatus(ProcessStatus.DISABLED);
            processInfoObject.setOlderVersion(0);
        } else {
            processInfoObject.setStatus(ProcessStatus.ACTIVE);
            processInfoObject.setOlderVersion(0);
        }
        return processInfoObject;
    }

    private Collection<ProcessConf> processQuery(ProcessFilter filter, TenantProcessStoreImpl tenantsProcessStore) throws ProcessManagementException {
        Pattern pattern;
        Map<QName, ProcessConfigurationImpl> processes = tenantsProcessStore.getProcesses();
        if (log.isDebugEnabled()) {
            for (Map.Entry<QName, ProcessConfigurationImpl> process : processes.entrySet()) {
                log.debug((Object)("Process " + process.getKey() + " in state " + process.getValue()));
            }
        }
        Set<QName> pids = processes.keySet();
        if (filter != null && filter.getNameFilter() != null) {
            String nameFilter = filter.getNameFilter().replace("\\", "\\\\").replace("]", "\\]").replace("[", "\\[").replace("^", "\\^").replace("$", "\\$").replace("|", "\\|").replace("?", "\\?").replace(".", "\\.").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("{", "\\{").replace("}", "\\}").replace("*", ".*");
            pattern = Pattern.compile(nameFilter + "(-\\d*)?");
            CollectionsX.remove_if(pids, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName o) {
                    return !pattern.matcher(o.getLocalPart()).matches();
                }
            });
        }
        if (filter != null && filter.getNamespaceFilter() != null) {
            String namespaceFilter = filter.getNamespaceFilter().replace("\\", "\\\\").replace("]", "\\]").replace("[", "\\[").replace("^", "\\^").replace("$", "\\$").replace("|", "\\|").replace("?", "\\?").replace(".", "\\.").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("{", "\\{").replace("}", "\\}").replace("*", ".*");
            pattern = Pattern.compile(namespaceFilter);
            CollectionsX.remove_if(pids, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName o) {
                    String ns = o.getNamespaceURI() == null ? "" : o.getNamespaceURI();
                    return !pattern.matcher(ns).matches();
                }
            });
        }
        LinkedList<ProcessConf> confs = new LinkedList<ProcessConf>();
        for (QName pid : pids) {
            ProcessConf pConf = tenantsProcessStore.getProcessConfiguration(pid);
            if (pConf == null) continue;
            confs.add(pConf);
        }
        if (filter != null) {
            if (filter.getDeployedDateFilter() != null) {
                for (final String ddf : filter.getDeployedDateFilter()) {
                    Date dd;
                    try {
                        dd = ISO8601DateParser.parse((String)Filter.getDateWithoutOp((String)ddf));
                    }
                    catch (ParseException e) {
                        String errMsg = "Exception while parsing date";
                        log.error((Object)errMsg, (Throwable)e);
                        throw new ProcessManagementException(errMsg, e);
                    }
                    CollectionsX.remove_if(confs, (MemberOfFunction)new MemberOfFunction<ProcessConf>(){

                        public boolean isMember(ProcessConf o) {
                            if (ddf.startsWith("=")) {
                                return !o.getDeployDate().equals(dd);
                            }
                            if (ddf.startsWith("<=")) {
                                return o.getDeployDate().getTime() > dd.getTime();
                            }
                            if (ddf.startsWith(">=")) {
                                return o.getDeployDate().getTime() < dd.getTime();
                            }
                            if (ddf.startsWith("<")) {
                                return o.getDeployDate().getTime() >= dd.getTime();
                            }
                            return ddf.startsWith(">") && o.getDeployDate().getTime() <= dd.getTime();
                        }
                    });
                }
            }
            if (filter.getOrders() != null) {
                ComparatorChain cChain = new ComparatorChain();
                for (String key : filter.getOrders()) {
                    Comparator<ProcessConf> c;
                    boolean ascending = true;
                    String orderKey = key;
                    if (key.startsWith("+") || key.startsWith("-")) {
                        orderKey = key.substring(1, key.length());
                        if (key.startsWith("-")) {
                            ascending = false;
                        }
                    }
                    if ("name".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getProcessId().getLocalPart().compareTo(o2.getProcessId().getLocalPart());
                            }
                        };
                    } else if ("namespace".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                String ns1 = o1.getProcessId().getNamespaceURI() == null ? "" : o1.getProcessId().getNamespaceURI();
                                String ns2 = o2.getProcessId().getNamespaceURI() == null ? "" : o2.getProcessId().getNamespaceURI();
                                return ns1.compareTo(ns2);
                            }
                        };
                    } else if ("version".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return (int)(o1.getVersion() - o2.getVersion());
                            }
                        };
                    } else if ("deployed".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getDeployDate().compareTo(o2.getDeployDate());
                            }
                        };
                    } else if ("status".equals(orderKey)) {
                        c = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf o1, ProcessConf o2) {
                                return o1.getState().compareTo((Enum)o2.getState());
                            }
                        };
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("unrecognized order key" + orderKey));
                        continue;
                    }
                    cChain.addComparator((Comparator)c, !ascending);
                }
                Collections.sort(confs, cChain);
            }
        }
        return confs;
    }

    private void fillProcessInfo(ProcessInfoType info, ProcessConf pconf, ProcessInfoCustomizer custom, TenantProcessStoreImpl tenantProcessStore) throws ProcessManagementException {
        if (pconf == null) {
            String errMsg = "Process configuration cannot be null.";
            log.error((Object)errMsg);
            throw new ProcessManagementException(errMsg);
        }
        info.setPid(pconf.getProcessId().toString());
        if (pconf.getState() == ProcessState.RETIRED) {
            info.setStatus(ProcessStatus.RETIRED);
            info.setOlderVersion(this.isOlderVersion(pconf, tenantProcessStore));
        } else if (pconf.getState() == ProcessState.DISABLED) {
            info.setStatus(ProcessStatus.DISABLED);
            info.setOlderVersion(0);
        } else {
            info.setStatus(ProcessStatus.ACTIVE);
            info.setOlderVersion(0);
        }
        info.setVersion(pconf.getVersion());
        DefinitionInfo defInfo = new DefinitionInfo();
        defInfo.setProcessName(pconf.getType());
        BpelDefinition bpelDefinition = new BpelDefinition();
        bpelDefinition.setExtraElement(this.getProcessDefinition(pconf));
        defInfo.setDefinition(bpelDefinition);
        info.setDefinitionInfo(defInfo);
        DeploymentInfo depInfo = new DeploymentInfo();
        depInfo.setPackageName(pconf.getPackage());
        depInfo.setDocument(pconf.getBpelDocument());
        depInfo.setDeployDate(this.toCalendar(pconf.getDeployDate()));
        depInfo.setDeployer("BPELDeployer");
        info.setDeploymentInfo(depInfo);
        if (custom.includeInstanceSummary()) {
            InstanceSummary instanceSummary = new InstanceSummary();
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.ACTIVE);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.COMPLETED);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.FAILED);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.SUSPENDED);
            this.addInstanceSummaryEntry(instanceSummary, pconf, InstanceStatus.TERMINATED);
            this.addFailuresToInstanceSummary(instanceSummary, pconf);
            info.setInstanceSummary(instanceSummary);
        }
        if (custom.includeProcessProperties()) {
            ProcessProperties processProps = new ProcessProperties();
            for (Map.Entry propEntry : pconf.getProcessProperties().entrySet()) {
                QName key = (QName)propEntry.getKey();
                if (key == null) continue;
                Property_type0 prop = new Property_type0();
                prop.setName(new QName(key.getNamespaceURI(), key.getLocalPart()));
                OMFactory omFac = OMAbstractFactory.getOMFactory();
                OMElement propEle = omFac.createOMElement("PropertyValue", null);
                propEle.setText(((Node)propEntry.getValue()).getNodeValue());
                prop.addExtraElement(propEle);
                processProps.addProperty(prop);
            }
            info.setProperties(processProps);
        }
        this.fillPartnerLinks(info, ((ProcessConfigurationImpl)pconf).getProcessDeploymentInfo());
    }

    private void addInstanceSummaryEntry(InstanceSummary instSum, ProcessConf pconf, InstanceStatus state) throws ProcessManagementException {
        Instances_type0 instances = new Instances_type0();
        instances.setState(state);
        String queryStatus = InstanceFilter.StatusKeys.valueOf((String)state.toString()).toString().toLowerCase();
        final InstanceFilter instanceFilter = new InstanceFilter("status=" + queryStatus + " pid=" + pconf.getProcessId());
        int count = this.dbexec(new BpelDatabase.Callable<Integer>(){

            public Integer run(BpelDAOConnection conn) throws Exception {
                return conn.instanceQuery(instanceFilter).size();
            }
        });
        instances.setCount(count);
        instSum.addInstances(instances);
    }

    private void addFailuresToInstanceSummary(final InstanceSummary instSum, ProcessConf pconf) throws ProcessManagementException {
        final FailuresInfo failureInfo = new FailuresInfo();
        String queryStatus = InstanceFilter.StatusKeys.valueOf((String)TInstanceStatus.ACTIVE.toString()).toString().toLowerCase();
        final InstanceFilter instanceFilter = new InstanceFilter("status=" + queryStatus + " pid=" + pconf.getProcessId());
        this.dbexec(new BpelDatabase.Callable<Void>(){

            public Void run(BpelDAOConnection conn) throws Exception {
                Date lastFailureDt = null;
                int failureInstances = 0;
                for (ProcessInstanceDAO instance : conn.instanceQuery(instanceFilter)) {
                    int count = instance.getActivityFailureCount();
                    if (count <= 0) continue;
                    ++failureInstances;
                    Date failureDt = instance.getActivityFailureDateTime();
                    if (lastFailureDt != null && !lastFailureDt.before(failureDt)) continue;
                    lastFailureDt = failureDt;
                }
                if (failureInstances > 0) {
                    failureInfo.setCount(failureInstances);
                    failureInfo.setFailureDate(ProcessManagementServiceSkeleton.this.toCalendar(lastFailureDt));
                    instSum.setFailures(failureInfo);
                }
                return null;
            }
        });
    }

    private int isOlderVersion(ProcessConf pconf, TenantProcessStoreImpl tenantProcessStore) {
        Set<QName> processIDs = tenantProcessStore.getProcesses().keySet();
        String filter = pconf.getProcessId().getLocalPart().substring(0, pconf.getProcessId().getLocalPart().lastIndexOf("-"));
        Pattern pattern = Pattern.compile(filter.replace("*", ".*") + "(-\\d*)?");
        ArrayList<QName> pids = new ArrayList<QName>();
        for (QName pid : processIDs) {
            if (!pattern.matcher(pid.getLocalPart()).matches()) continue;
            pids.add(pid);
        }
        if (pids.size() > 1) {
            long currentVersion = pconf.getVersion();
            for (QName pid : pids) {
                long tempVersion = Long.parseLong(pid.getLocalPart().substring(pid.getLocalPart().lastIndexOf("-") + 1));
                if (tempVersion <= currentVersion) continue;
                return 1;
            }
        }
        return 0;
    }

    private Calendar toCalendar(Date dtime) {
        if (dtime == null) {
            return null;
        }
        Calendar c = (Calendar)this.calendar.clone();
        c.setTime(dtime);
        return c;
    }

    protected <T> T dbexec(BpelDatabase.Callable<T> callable) throws ProcessManagementException {
        try {
            return (T)this.bpelDb.exec(callable);
        }
        catch (Exception ex) {
            String errMsg = "Exception during database operation ";
            log.error((Object)errMsg, (Throwable)ex);
            throw new ProcessManagementException(errMsg, ex);
        }
    }

    private OMElement getProcessDefinition(ProcessConf pConf) throws ProcessManagementException {
        if (pConf == null) {
            String errMsg = "Process configuration cannot be null.";
            log.error((Object)errMsg);
            throw new ProcessManagementException(errMsg);
        }
        String bpelDoc = pConf.getBpelDocument();
        List files = pConf.getFiles();
        for (File file : files) {
            OMElement bpelDefinition;
            if (!file.getPath().endsWith(bpelDoc) && !file.getPath().endsWith(bpelDoc.replaceAll("/", "\\\\"))) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                XMLInputFactory xif = XMLInputFactory.newInstance();
                XMLStreamReader reader = xif.createXMLStreamReader(fis);
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                bpelDefinition = builder.getDocumentElement();
                bpelDefinition.build();
            }
            catch (XMLStreamException e) {
                String errMsg = "XML stream reader exception: " + file.getAbsolutePath();
                log.error((Object)errMsg, (Throwable)e);
                throw new ProcessManagementException(errMsg, e);
            }
            catch (FileNotFoundException e) {
                String errMsg = "BPEL File reading exception: " + file.getAbsolutePath();
                log.error((Object)errMsg, (Throwable)e);
                throw new ProcessManagementException(errMsg, e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Cannot close file input stream.", (Throwable)e);
                    }
                }
            }
            return bpelDefinition;
        }
        String errMsg = "Process Definition for: " + pConf.getProcessId() + " not found";
        log.error((Object)errMsg);
        throw new ProcessManagementException(errMsg);
    }

    private TenantProcessStoreImpl getTenantProcessStore() {
        Integer tenantId = MultitenantUtils.getTenantId((ConfigurationContext)this.getConfigContext());
        return (TenantProcessStoreImpl)this.bpelServer.getMultiTenantProcessStore().getTenantsProcessStore(tenantId);
    }
}

