/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.store;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class BPELDeploymentContext {
    private Integer tenantId;
    private String bpelFileSystemRepoRoot;
    private long version;
    private String archiveName;
    private String bpelPackageName;
    private String bpelPackageNameWithVersion;
    private String bpelPackageLocationInFileSystem;
    private File bpelArchive;
    private File currentVersionOfBPELPackage;
    private String errorCause;
    private Throwable stackTrace;
    private List<QName> processIds = new ArrayList<QName>();

    public BPELDeploymentContext(Integer tenantId, String bpelFileSystemRepoRoot, File bpelArchive, long version) {
        this.tenantId = tenantId;
        this.bpelArchive = bpelArchive;
        this.version = version;
        this.bpelFileSystemRepoRoot = bpelFileSystemRepoRoot;
        this.calculateMetaData();
    }

    private void calculateMetaData() {
        this.archiveName = this.bpelArchive.getName();
        this.bpelPackageName = this.archiveName.substring(0, this.archiveName.lastIndexOf(".zip"));
        this.bpelPackageNameWithVersion = this.bpelPackageName + "-" + this.version;
        this.bpelPackageLocationInFileSystem = this.getTheLocationToExtract(this.bpelPackageNameWithVersion);
    }

    private String getTheLocationToExtract(String bpelPackageNameWithVersion) {
        return this.bpelFileSystemRepoRoot + File.separator + this.tenantId + File.separator + bpelPackageNameWithVersion;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setBPELPackageContent(File bpelPackage) {
        this.currentVersionOfBPELPackage = bpelPackage;
    }

    public File getBPELPackageContent() {
        return this.currentVersionOfBPELPackage;
    }

    public String getBpelPackageName() {
        return this.bpelPackageName;
    }

    public String getBpelPackageNameWithVersion() {
        return this.bpelPackageNameWithVersion;
    }

    public String getBpelPackageLocationInFileSystem() {
        return this.bpelPackageLocationInFileSystem;
    }

    public File getBpelArchive() {
        return this.bpelArchive;
    }

    public String getDeploymentFailureCause() {
        return this.errorCause;
    }

    public void setDeploymentFailureCause(String errorCause) {
        this.errorCause = errorCause;
    }

    public long getVersion() {
        return this.version;
    }

    public void addProcessId(QName pid) {
        this.processIds.add(pid);
    }

    public List<QName> getProcessIdsForCurrentDeployment() {
        return this.processIds;
    }

    public String getProcessIdsInCurrentVersion() {
        String pids = "";
        for (QName n : this.processIds) {
            pids = pids.concat(n.toString()).concat(",");
        }
        return pids.substring(0, pids.length() - 1);
    }

    public Throwable getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(Throwable stackTrace) {
        this.stackTrace = stackTrace;
    }
}

