/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.activityRecovery.FailureHandlingDocument;
import org.apache.ode.bpel.dd.TCleanup;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TInvoke;
import org.apache.ode.bpel.dd.TMexInterceptor;
import org.apache.ode.bpel.dd.TProcessEvents;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.dd.TSchedule;
import org.apache.ode.bpel.dd.TScopeEvents;
import org.apache.ode.bpel.dd.TService;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.o.OFailureHandling;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.ProcessCleanupConfImpl;
import org.apache.ode.utils.CronExpression;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.ode.integration.config.EndpointConfigBuilder;
import org.wso2.carbon.bpel.ode.integration.config.EndpointConfiguration;
import org.wso2.carbon.bpel.ode.integration.config.PackageConfiguration;
import org.wso2.carbon.bpel.ode.integration.store.BPELDeploymentException;
import org.wso2.carbon.bpel.ode.integration.store.MultiTenantProcessConfiguration;
import org.wso2.carbon.bpel.ode.integration.store.Utils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ProcessConfigurationImpl
implements ProcessConf,
MultiTenantProcessConfiguration {
    private static final Log log = LogFactory.getLog(ProcessConfigurationImpl.class);
    private ConfigurationContext tenatConfigurationContext;
    private final Date deployDate;
    private final Map<QName, Node> properties;
    private final Map<String, Endpoint> partnerRoleInitialValues = new HashMap<String, Endpoint>();
    private final Map<String, ProcessConf.PartnerRoleConfig> partnerRoleConfigurations = new HashMap<String, ProcessConf.PartnerRoleConfig>();
    private final Map<String, Endpoint> myRoleEndpoints = new HashMap<String, Endpoint>();
    private final List<QName> sharedServices = new ArrayList<QName>();
    private final Map<String, Set<BpelEvent.TYPE>> events = new HashMap<String, Set<BpelEvent.TYPE>>();
    private final List<String> mexInterceptors = new ArrayList<String>();
    private final DeploymentUnitDir du;
    private ProcessState state;
    private final TDeployment.Process processInfo;
    private long version = 0L;
    private QName processId;
    private QName type;
    private volatile boolean inMemory = false;
    private EndpointReferenceContext eprContext;
    private final ProcessCleanupConfImpl processCleanupConfImpl;
    private PackageConfiguration bpelPackageConfiguration = new PackageConfiguration();
    private Integer tenantId = -1;
    private boolean undeploying = false;
    private String deployer = "";

    public ProcessConfigurationImpl(Integer tenantId, TDeployment.Process processDescriptor, DeploymentUnitDir du, Date deployDate, EndpointReferenceContext eprContext, ConfigurationContext tenantConfigContext) {
        this.deployDate = (Date)deployDate.clone();
        this.type = Utils.getProcessType(processDescriptor);
        this.du = du;
        this.processInfo = processDescriptor;
        this.version = du.getVersion();
        this.processId = Utils.toPid(processDescriptor.getName(), this.version);
        this.eprContext = eprContext;
        this.state = Utils.calcInitialState(processDescriptor);
        this.properties = Collections.unmodifiableMap(Utils.calcInitialProperties(du.getProperties(), processDescriptor));
        this.inMemory = processDescriptor.isSetInMemory() && processDescriptor.getInMemory();
        this.tenatConfigurationContext = tenantConfigContext;
        this.tenantId = MultitenantUtils.getTenantId((ConfigurationContext)tenantConfigContext);
        this.deployer = tenantId.toString();
        this.readPackageConfiguration();
        this.initPartnerLinks();
        this.initMexInterceptors();
        this.initEventList();
        this.processCleanupConfImpl = new ProcessCleanupConfImpl(processDescriptor);
        this.initSchedules();
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    @Override
    public ConfigurationContext getTenantConfigurationContext() {
        return this.tenatConfigurationContext;
    }

    public QName getProcessId() {
        return this.processId;
    }

    public QName getType() {
        return this.processInfo.getType() == null ? this.type : this.processInfo.getType();
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isTransient() {
        return this.inMemory;
    }

    public InputStream getCBPInputStream() {
        DeploymentUnitDir.CBPInfo cbpInfo = this.du.getCBPInfo(this.getType());
        if (cbpInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        try {
            return new FileInputStream(cbpInfo.getCbp());
        }
        catch (FileNotFoundException e) {
            throw new ContextException("File Not Found: " + cbpInfo.getCbp(), (Throwable)e);
        }
    }

    public long getCBPFileSize() {
        DeploymentUnitDir.CBPInfo cbpInfo = this.du.getCBPInfo(this.getType());
        if (cbpInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        return cbpInfo.getCbp().length();
    }

    public String getBpelDocument() {
        DeploymentUnitDir.CBPInfo cbpInfo = this.du.getCBPInfo(this.getType());
        if (cbpInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        try {
            String relative = this.getRelativePath(this.du.getDeployDir(), cbpInfo.getCbp()).replaceAll("\\\\", "/");
            if (!relative.endsWith(".cbp")) {
                throw new ContextException("CBP file must end with .cbp suffix: " + cbpInfo.getCbp());
            }
            relative = relative.replace(".cbp", ".bpel");
            File bpelFile = new File(this.du.getDeployDir(), relative);
            if (!bpelFile.exists()) {
                log.warn((Object)("BPEL file does not exist: " + bpelFile));
            }
            return relative;
        }
        catch (IOException e) {
            throw new ContextException("IOException in getBpelRelativePath: " + cbpInfo.getCbp(), (Throwable)e);
        }
    }

    private String getRelativePath(File base, File path) throws IOException {
        String basePath = base.getCanonicalPath();
        String cbpPath = path.getCanonicalPath();
        if (!cbpPath.startsWith(basePath)) {
            throw new IOException("Invalid relative path: base=" + base + " path=" + path);
        }
        String relative = cbpPath.substring(basePath.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return relative;
    }

    public URI getBaseURI() {
        return this.du.getDeployDir().toURI();
    }

    public Date getDeployDate() {
        return (Date)this.deployDate.clone();
    }

    public String getDeployer() {
        return this.deployer;
    }

    public ProcessState getState() {
        return this.state;
    }

    public List<File> getFiles() {
        return this.du.allFiles();
    }

    public Map<QName, Node> getProcessProperties() {
        return this.properties;
    }

    public String getPackage() {
        return this.du.getName();
    }

    public Definition getDefinitionForService(QName serviceName) {
        return this.du.getDefinitionForService(serviceName);
    }

    public Definition getDefinitionForPortType(QName portType) {
        return this.du.getDefinitionForPortType(portType);
    }

    public Map<String, Endpoint> getProvideEndpoints() {
        return Collections.unmodifiableMap(this.myRoleEndpoints);
    }

    public Map<String, Endpoint> getInvokeEndpoints() {
        return Collections.unmodifiableMap(this.partnerRoleInitialValues);
    }

    public Map<String, ProcessConf.PartnerRoleConfig> getPartnerRoleConfig() {
        return Collections.unmodifiableMap(this.partnerRoleConfigurations);
    }

    public boolean isSharedService(QName serviceName) {
        return this.sharedServices.contains(serviceName);
    }

    public boolean isUndeploying() {
        return this.undeploying;
    }

    public void setUndeploying(boolean undeploying) {
        this.undeploying = undeploying;
    }

    public List<Element> getExtensionElement(QName name) {
        try {
            return DOMUtils.findChildrenByName((Element)DOMUtils.stringToDOM((String)this.processInfo.toString()), (QName)name);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean isEventEnabled(List<String> scopeNames, BpelEvent.TYPE type) {
        Set<BpelEvent.TYPE> evtSet;
        if (scopeNames != null) {
            for (String scopeName : scopeNames) {
                Set<BpelEvent.TYPE> evtSet2 = this.events.get(scopeName);
                if (evtSet2 == null || !evtSet2.contains(type)) continue;
                return true;
            }
        }
        return (evtSet = this.events.get(null)) != null && evtSet.contains(type);
    }

    public Map<String, String> getEndpointProperties(EndpointReference endpointReference) {
        EndpointConfiguration epConf = null;
        Map map = this.eprContext.getConfigLookup(endpointReference);
        QName service = (QName)map.get("service");
        String port = (String)map.get("port");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking Endpoint configuration properties for service: " + service + " and port: " + port));
        }
        if (this.bpelPackageConfiguration != null) {
            epConf = (EndpointConfiguration)this.bpelPackageConfiguration.getEndpoints().get((Object)service.getLocalPart(), (Object)service.getNamespaceURI(), (Object)port);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (epConf != null) {
            props.put("mex.timeout", epConf.getMexTimeout());
        }
        return props;
    }

    public EndpointConfiguration getEndpointConfiguration(EndpointReference endpointReference) {
        MultiKeyMap endpointConfigs;
        Map map = this.eprContext.getConfigLookup(endpointReference);
        QName service = (QName)map.get("service");
        String port = (String)map.get("port");
        EndpointConfiguration endpointConfig = null;
        if (this.bpelPackageConfiguration != null && (endpointConfigs = this.bpelPackageConfiguration.getEndpoints()).size() > 0 && (endpointConfig = (EndpointConfiguration)endpointConfigs.get((Object)service.getLocalPart(), (Object)service.getNamespaceURI(), (Object)port)) == null) {
            endpointConfig = (EndpointConfiguration)endpointConfigs.get((Object)service.getLocalPart(), (Object)service.getNamespaceURI(), null);
        }
        return endpointConfig;
    }

    public boolean isCleanupCategoryEnabled(boolean instanceSucceeded, ProcessConf.CLEANUP_CATEGORY category) {
        return this.processCleanupConfImpl.isCleanupCategoryEnabled(instanceSucceeded, category);
    }

    public Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean instanceSucceeded) {
        return this.processCleanupConfImpl.getCleanupCategories(instanceSucceeded);
    }

    public List<ProcessConf.CronJob> getCronJobs() {
        ArrayList<ProcessConf.CronJob> jobs = new ArrayList<ProcessConf.CronJob>();
        for (TSchedule schedule : this.processInfo.getScheduleList()) {
            ProcessConf.CronJob job = new ProcessConf.CronJob();
            try {
                job.setCronExpression(new CronExpression(schedule.getWhen()));
                for (TCleanup aCleanup : schedule.getCleanupList()) {
                    ProcessConf.CleanupInfo cleanupInfo = new ProcessConf.CleanupInfo();
                    assert (!aCleanup.getFilterList().isEmpty());
                    cleanupInfo.setFilters(aCleanup.getFilterList());
                    ProcessCleanupConfImpl.processACleanup((Set)cleanupInfo.getCategories(), (List)aCleanup.getCategoryList());
                    Scheduler.JobDetails runnableDetails = new Scheduler.JobDetails();
                    runnableDetails.getDetailsExt().put("cleanupInfo", cleanupInfo);
                    runnableDetails.setProcessId(this.processId);
                    runnableDetails.getDetailsExt().put("transactionSize", 10);
                    job.getRunnableDetailList().add(runnableDetails);
                }
                jobs.add(job);
            }
            catch (ParseException pe) {
                log.error((Object)("Exception during parsing the schedule cron expression: " + schedule.getWhen() + ", skipped the scheduled job."), (Throwable)pe);
            }
        }
        return jobs;
    }

    public QName getCorrelationFilter(String partnerLinkName) {
        for (TProvide tProvide : this.processInfo.getProvideList()) {
            if (!tProvide.getPartnerLink().equals(partnerLinkName)) continue;
            return tProvide.getCorrelationFilter();
        }
        return null;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public DeploymentUnitDir getDeploymentUnit() {
        return this.du;
    }

    public List<String> getMexInterceptors(QName processId) {
        return Collections.unmodifiableList(this.mexInterceptors);
    }

    public TDeployment.Process getProcessDeploymentInfo() {
        return this.processInfo;
    }

    private void initSchedules() {
        for (TSchedule schedule : this.processInfo.getScheduleList()) {
            for (TCleanup cleanup : schedule.getCleanupList()) {
                assert (!cleanup.getFilterList().isEmpty());
            }
        }
    }

    private void readPackageConfiguration() {
        File depDir = this.du.getDeployDir();
        List processList = this.du.getDeploymentDescriptor().getDeploy().getProcessList();
        for (TDeployment.Process process : processList) {
            List tInvokeList = process.getInvokeList();
            for (TInvoke tInvoke : tInvokeList) {
                if (tInvoke.getService() == null) {
                    String errMsg = "Service element missing for the invoke element in deploy.xml";
                    log.error((Object)errMsg);
                    throw new BPELDeploymentException(errMsg);
                }
                try {
                    OMElement serviceEle = AXIOMUtil.stringToOM((String)tInvoke.getService().toString());
                    OMElement endpointEle = serviceEle.getFirstElement();
                    if (endpointEle == null || !endpointEle.getQName().equals(new QName("http://wso2.org/bps/bpel/endpoint/config", "endpoint"))) continue;
                    EndpointConfiguration epConf = EndpointConfigBuilder.buildEndpointConfiguration(endpointEle, depDir.getAbsolutePath());
                    epConf.setServiceName(tInvoke.getService().getName().getLocalPart());
                    epConf.setServiceNS(tInvoke.getService().getName().getNamespaceURI());
                    epConf.setServicePort(tInvoke.getService().getPort());
                    this.bpelPackageConfiguration.addEndpoint(epConf);
                }
                catch (XMLStreamException e) {
                    log.warn((Object)("Error occurred while reading endpoint configuration. Endpoint config will not be applied to: " + tInvoke.getService()));
                }
            }
            List tProvideList = process.getProvideList();
            for (TProvide tProvide : tProvideList) {
                if (tProvide.getService() == null) {
                    String errMsg = "Service element missing for the provide element in deploy.xml";
                    log.error((Object)errMsg);
                    throw new BPELDeploymentException(errMsg);
                }
                try {
                    OMElement serviceEle = AXIOMUtil.stringToOM((String)tProvide.getService().toString());
                    OMElement endpointEle = serviceEle.getFirstElement();
                    if (endpointEle == null || !endpointEle.getQName().equals(new QName("http://wso2.org/bps/bpel/endpoint/config", "endpoint"))) continue;
                    EndpointConfiguration epConf = EndpointConfigBuilder.buildEndpointConfiguration(endpointEle, depDir.getAbsolutePath());
                    epConf.setServiceName(tProvide.getService().getName().getLocalPart());
                    epConf.setServiceNS(tProvide.getService().getName().getNamespaceURI());
                    epConf.setServicePort(tProvide.getService().getPort());
                    this.bpelPackageConfiguration.addEndpoint(epConf);
                }
                catch (XMLStreamException e) {
                    log.warn((Object)("Error occured while reading endpoint configuration. Endpoint config will not be applied to: " + tProvide.getService()));
                }
            }
        }
    }

    private void initPartnerLinks() {
        String errMsg;
        Service serviceDef;
        String errMsg2;
        QName serviceName;
        Definition wsdlDef;
        TService service;
        String plinkName;
        if (this.processInfo.getInvokeList() != null) {
            for (TInvoke invoke : this.processInfo.getInvokeList()) {
                plinkName = invoke.getPartnerLink();
                service = invoke.getService();
                if (service == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing <invoke> element for process " + this.processInfo.getName() + ": partnerlink" + plinkName + " -->" + service));
                }
                if ((wsdlDef = this.getDefinitionForService(serviceName = service.getName())) == null) {
                    errMsg2 = "Cannot find WSDL definition for invoke service " + serviceName + ". Required resources not found in the BPEL package " + this.du.getName() + ".";
                    log.error((Object)errMsg2);
                    throw new ContextException(errMsg2);
                }
                serviceDef = wsdlDef.getService(serviceName);
                if (serviceDef.getPort(service.getPort()) == null) {
                    errMsg = "Cannot find  port for invoking service for the given name " + serviceName + ". Error in deploy.xml.";
                    log.error((Object)errMsg);
                    throw new ContextException(errMsg);
                }
                this.partnerRoleInitialValues.put(plinkName, new Endpoint(service.getName(), service.getPort()));
                OFailureHandling g = null;
                if (invoke.isSetFailureHandling()) {
                    FailureHandlingDocument.FailureHandling fh = invoke.getFailureHandling();
                    g = new OFailureHandling();
                    if (fh.isSetFaultOnFailure()) {
                        g.faultOnFailure = fh.getFaultOnFailure();
                    }
                    if (fh.isSetRetryDelay()) {
                        g.retryDelay = fh.getRetryDelay();
                    }
                    if (fh.isSetRetryFor()) {
                        g.retryFor = fh.getRetryFor();
                    }
                }
                ProcessConf.PartnerRoleConfig c = new ProcessConf.PartnerRoleConfig(g, invoke.getUsePeer2Peer());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PartnerRoleConfig for " + plinkName + " " + c.failureHandling + " usePeer2Peer: " + c.usePeer2Peer));
                }
                this.partnerRoleConfigurations.put(plinkName, c);
            }
        }
        if (this.processInfo.getProvideList() != null) {
            for (TProvide proivde : this.processInfo.getProvideList()) {
                plinkName = proivde.getPartnerLink();
                service = proivde.getService();
                if (service == null) {
                    String errorMsg = "Error in <provide> element for process " + this.processInfo.getName() + ";partnerlink" + plinkName + "did not identify an endpoint";
                    log.error((Object)errorMsg);
                    throw new ContextException(errorMsg);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing <provide> element for process " + this.processInfo.getName() + ": partnerlink " + plinkName + " --> " + service.getName() + " : " + service.getPort()));
                }
                if ((wsdlDef = this.getDefinitionForService(serviceName = service.getName())) == null) {
                    errMsg2 = "Cannot find WSDL definition for provide service " + serviceName + ". Required resources not found in the BPEL " + "package " + this.du.getName() + ".";
                    log.error((Object)errMsg2);
                    throw new ContextException(errMsg2);
                }
                serviceDef = wsdlDef.getService(serviceName);
                if (serviceDef.getPort(service.getPort()) == null) {
                    errMsg = "Cannot find provide port in the given service " + serviceName + ". Error in deploy.xml.";
                    log.error((Object)errMsg);
                    throw new ContextException(errMsg);
                }
                this.myRoleEndpoints.put(plinkName, new Endpoint(service.getName(), service.getPort()));
                if (!proivde.isSetEnableSharing()) continue;
                this.sharedServices.add(service.getName());
            }
        }
    }

    private void initEventList() {
        HashSet<BpelEvent.TYPE> all;
        TProcessEvents processEvents = this.processInfo.getProcessEvents();
        if (processEvents != null && log.isDebugEnabled()) {
            List enabledEventList = processEvents.getEnableEventList();
            StringBuffer strBuf = new StringBuffer();
            for (String eventType : enabledEventList) {
                strBuf.append(eventType);
                strBuf.append(", ");
            }
            log.debug((Object)("Enabled Event List: " + strBuf.toString()));
        }
        if (processEvents == null) {
            all = new HashSet<BpelEvent.TYPE>();
            for (BpelEvent.TYPE t : BpelEvent.TYPE.values()) {
                if (t.equals((Object)BpelEvent.TYPE.scopeHandling)) continue;
                all.add(t);
            }
            this.events.put(null, all);
            return;
        }
        if (processEvents.getGenerate() != null && processEvents.getGenerate().equals(TProcessEvents.Generate.ALL)) {
            all = new HashSet();
            all.addAll(Arrays.asList(BpelEvent.TYPE.values()));
            this.events.put(null, all);
            return;
        }
        if (processEvents.getEnableEventList() != null) {
            List enabled = processEvents.getEnableEventList();
            HashSet<BpelEvent.TYPE> evtSet = new HashSet<BpelEvent.TYPE>();
            for (String enEvt : enabled) {
                evtSet.add(BpelEvent.TYPE.valueOf((String)enEvt));
            }
            this.events.put(null, evtSet);
        }
        if (processEvents.getScopeEventsList() != null) {
            for (TScopeEvents tScopeEvents : processEvents.getScopeEventsList()) {
                HashSet<BpelEvent.TYPE> evtSet = new HashSet<BpelEvent.TYPE>();
                for (String enEvt : tScopeEvents.getEnableEventList()) {
                    evtSet.add(BpelEvent.TYPE.valueOf((String)enEvt));
                }
                this.events.put(tScopeEvents.getName(), evtSet);
            }
        }
    }

    private void initMexInterceptors() {
        if (this.processInfo.getMexInterceptors() != null) {
            for (TMexInterceptor mexInterceptor : this.processInfo.getMexInterceptors().getMexInterceptorList()) {
                this.mexInterceptors.add(mexInterceptor.getClassName());
            }
        }
    }
}

