/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.ProcessConfDAO;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.bpel.internal.BPELServiceComponent;
import org.wso2.carbon.bpel.ode.integration.store.BPELDeploymentContext;
import org.wso2.carbon.bpel.ode.integration.store.BPELDeploymentException;
import org.wso2.carbon.bpel.ode.integration.store.ProcessConfigurationImpl;
import org.wso2.carbon.bpel.ode.integration.store.ProcessStoreImpl;
import org.wso2.carbon.bpel.ode.integration.store.TenantProcessStore;
import org.wso2.carbon.bpel.ode.integration.store.Utils;
import org.wso2.carbon.bpel.ode.integration.store.clustering.BPELPackageUndeployedCommand;
import org.wso2.carbon.bpel.ode.integration.store.clustering.BPELProcessStateChangedCommand;
import org.wso2.carbon.bpel.ode.integration.store.clustering.NewBPELPackageDeployedCommand;
import org.wso2.carbon.bpel.ode.integration.store.repository.BPELPackageInfo;
import org.wso2.carbon.bpel.ode.integration.store.repository.BPELPackageRepository;
import org.wso2.carbon.bpel.ode.integration.store.repository.BPELPackageRepositoryUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryClientUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class TenantProcessStoreImpl
implements TenantProcessStore {
    private static final Log log = LogFactory.getLog(TenantProcessStoreImpl.class);
    private Integer tenantId;
    private ConfigurationContext tenantConfigContext;
    private Registry tenantConfigRegistry;
    private ProcessStoreImpl parentProcessStore;
    private final Map<String, DeploymentUnitDir> deploymentUnits = new ConcurrentHashMap<String, DeploymentUnitDir>();
    private final Map<QName, ProcessConfigurationImpl> processes = new ConcurrentHashMap<QName, ProcessConfigurationImpl>();
    private final Map<String, List<QName>> processesInDeploymentUnit = new ConcurrentHashMap<String, List<QName>>();
    private BPELPackageRepository repository;
    private File bpelDURepo;
    private File bpelArchiveRepo;

    public TenantProcessStoreImpl(ConfigurationContext configContext, ProcessStoreImpl parent) throws RegistryException {
        this.tenantConfigContext = configContext;
        this.tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configContext);
        this.tenantConfigRegistry = BPELServiceComponent.getRegistryService().getConfigSystemRegistry(this.tenantId.intValue());
        this.parentProcessStore = parent;
    }

    @Override
    public void init() throws Exception {
        this.bpelDURepo = new File(this.parentProcessStore.getLocalDeploymentUnitRepo(), this.tenantId.toString());
        if (!this.bpelDURepo.exists() && !this.bpelDURepo.mkdirs()) {
            log.warn((Object)("Cannot create tenant " + this.tenantId + " BPEL deployment unit repository."));
        }
        this.repository = new BPELPackageRepository(this.tenantConfigRegistry, this.bpelDURepo, this.bpelArchiveRepo);
        this.repository.init();
    }

    @Override
    public void handleNewBPELPackageDeploymentNotification(String bpelPackageName) {
        try {
            this.repository.restoreBPELArchive(this.repository.getBPELPackageInfo("/bpel/packages/" + bpelPackageName));
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while deploying: " + bpelPackageName), (Throwable)e);
        }
    }

    @Override
    public void handleBPELPackageUndeploymentNotification(String bpelPackageName, List<String> versionsOfPackage) {
        this.updateLocalInstanceWithUndeployment(bpelPackageName, versionsOfPackage);
    }

    @Override
    public void handleBPELProcessStateChangedNotification(QName pid, ProcessState processState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changing state of the process " + pid + " to " + processState));
        }
        if (!this.isProcessExist(pid).booleanValue()) {
            String errMsg = "Process " + pid + " not found. Process state change failed.";
            log.error((Object)errMsg);
            return;
        }
        if (processState == null) {
            String errMessage = "Process State cannot be null. Process state change failed";
            log.error((Object)errMessage);
            return;
        }
        this.parentProcessStore.updateLocalInstanceWithStateChange(pid, processState);
    }

    @Override
    public void deploy(File bpelArchive) throws Exception {
        log.info((Object)("Deploying BPEL archive: " + bpelArchive.getAbsolutePath()));
        long versionForThisDeployment = this.parentProcessStore.getCurrentVersion();
        BPELDeploymentContext deploymentContext = new BPELDeploymentContext(this.tenantId, this.parentProcessStore.getLocalDeploymentUnitRepo().getAbsolutePath(), bpelArchive, versionForThisDeployment);
        boolean isExistingPackage = this.repository.isExistingBPELPackage(deploymentContext);
        boolean isLoadOnly = this.repository.isBPELPackageReload(deploymentContext);
        if (isExistingPackage && isLoadOnly) {
            this.reloadExistingVersionsOfBPELPackage(deploymentContext);
            this.attachWithCapp(deploymentContext.getArchiveName(), deploymentContext.getBpelPackageName(), this.tenantId);
            return;
        }
        try {
            Utils.extractBPELArchive(deploymentContext);
        }
        catch (Exception e) {
            String errMsg = "Error extracting BPEL archive " + deploymentContext.getBpelArchive() + ".";
            deploymentContext.setDeploymentFailureCause(errMsg);
            deploymentContext.setStackTrace(e);
            this.handleDeploymentError(deploymentContext);
            return;
        }
        if (!this.validateBPELPackage(deploymentContext, isExistingPackage)) {
            this.handleDeploymentError(deploymentContext);
            return;
        }
        this.deployBPELPackageInODE(deploymentContext);
        if (isExistingPackage) {
            this.repository.handleBPELPackageUpdate(deploymentContext);
        } else {
            this.repository.handleNewBPELPackageAddition(deploymentContext);
        }
        this.attachWithCapp(deploymentContext.getArchiveName(), deploymentContext.getBpelPackageName(), this.tenantId);
        this.parentProcessStore.sendProcessDeploymentNotificationsToCluster(new NewBPELPackageDeployedCommand(deploymentContext.getBpelPackageName(), this.tenantId));
    }

    @Override
    public void undeploy(String bpelPackageName) throws RegistryException, ClusteringFault {
        List<String> versionsOfThePackage;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeploying BPEL package " + bpelPackageName + " ...."));
        }
        if (!this.repository.isExistingBPELPackage(bpelPackageName).booleanValue()) {
            String warningMsg = "Cannot find BPEL package with name " + bpelPackageName + " in the repository. If the bpel package is undeployed through the management" + " console or if this node is a member of a cluster, please ignore this warning.";
            log.warn((Object)warningMsg);
            return;
        }
        try {
            versionsOfThePackage = this.repository.getAllVersionsForPackage(bpelPackageName);
        }
        catch (RegistryException re) {
            String errMessage = "Cannot get all versions of the package " + bpelPackageName + " from registry.";
            log.error((Object)errMessage);
            throw re;
        }
        for (String nameWithVersion : versionsOfThePackage) {
            this.parentProcessStore.deleteDeploymentUnitDataFromDB(nameWithVersion);
            Utils.deleteInstances(this.getProcessesInPackage(nameWithVersion));
            for (QName pid : this.getProcessesInPackage(nameWithVersion)) {
                ProcessConfigurationImpl processConf = (ProcessConfigurationImpl)this.getProcessConfiguration(pid);
                processConf.setUndeploying(true);
            }
        }
        try {
            this.repository.handleBPELPackageUndeploy(bpelPackageName);
        }
        catch (RegistryException re) {
            String errMessage = "Cannot update the BPEL package repository for undeployment ofpackage " + bpelPackageName + ".";
            log.error((Object)errMessage);
            throw re;
        }
        this.updateLocalInstanceWithUndeployment(bpelPackageName, versionsOfThePackage);
        this.parentProcessStore.sendProcessDeploymentNotificationsToCluster(new BPELPackageUndeployedCommand(versionsOfThePackage, bpelPackageName, this.tenantId));
    }

    public void updateLocalInstanceWithUndeployment(String bpelPackageName, List<String> versionsOfThePackage) {
        this.deleteBpelArchive(bpelPackageName);
        ArrayList<QName> undeployedProcesses = new ArrayList<QName>();
        for (String nameWithVersion : versionsOfThePackage) {
            this.undeploySpecificVersionOfBPELPackage(nameWithVersion, undeployedProcesses);
        }
        this.parentProcessStore.updateMapsAndFireStateChangeEventsForUndeployedProcesses(this.tenantId, bpelPackageName, undeployedProcesses);
    }

    private void deleteBpelArchive(String bpelPackageName) {
        String bpelArchiveLocation = this.tenantConfigContext.getAxisConfiguration().getRepository().getPath() + File.separator + "bpel" + File.separator + bpelPackageName + "." + "zip";
        log.info((Object)("Undeploying BPEL package " + bpelPackageName + ". Deleting BPEL archive " + bpelArchiveLocation + "...."));
        File bpelArchive = new File(bpelArchiveLocation);
        if (bpelArchive.exists()) {
            if (!bpelArchive.delete()) {
                bpelArchive.deleteOnExit();
            }
        } else {
            log.warn((Object)("BPEL archive " + bpelArchive.getAbsolutePath() + " not found. This can happen if you delete " + "the BPEL archive from the file system."));
        }
    }

    private void undeploySpecificVersionOfBPELPackage(String packageName, Collection<QName> undeployedProcesses) {
        DeploymentUnitDir du = this.deploymentUnits.remove(packageName);
        this.processesInDeploymentUnit.remove(packageName);
        if (du != null) {
            long version = du.getVersion();
            for (QName name : du.getProcessNames()) {
                QName pid = Utils.toPid(name, version);
                undeployedProcesses.add(pid);
                this.processes.remove(pid);
            }
        }
    }

    @Override
    public void handleTenantUnload() {
    }

    @Override
    public void hydrate() {
    }

    @Override
    public ProcessConf getProcessConfiguration(QName pid) {
        return this.processes.get(pid);
    }

    @Override
    public void setState(QName pid, ProcessState processState) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changing state of the process " + pid + " to " + processState));
        }
        if (!this.isProcessExist(pid).booleanValue()) {
            String errMsg = "Process " + pid + " not found.";
            log.error((Object)errMsg);
            throw new Exception(errMsg);
        }
        if (processState == null) {
            String errMessage = "Process State cannot be null.";
            log.error((Object)errMessage);
            throw new Exception(errMessage);
        }
        this.parentProcessStore.setState(pid, processState);
        this.parentProcessStore.sendProcessDeploymentNotificationsToCluster(new BPELProcessStateChangedCommand(pid, processState, this.tenantId));
    }

    private Boolean isProcessExist(QName pid) {
        return this.processes.containsKey(pid);
    }

    public BPELPackageRepository getBPELPackageRepository() {
        return this.repository;
    }

    public Map<QName, ProcessConfigurationImpl> getProcesses() {
        return this.processes;
    }

    public ProcessConf removeProcessConfiguration(QName pid) {
        return this.processes.remove(pid);
    }

    public List<QName> getProcessesInPackage(String packageName) {
        return this.processesInDeploymentUnit.get(packageName);
    }

    public Boolean containsProcess(QName pid) {
        return this.processes.containsKey(pid);
    }

    @Override
    public void setBpelArchiveRepo(File bpelArchiveRepo) {
        this.bpelArchiveRepo = bpelArchiveRepo;
    }

    private void handleDeploymentError(BPELDeploymentContext deploymentContext) throws Exception {
        if (deploymentContext.getStackTrace() != null) {
            log.error((Object)deploymentContext.getDeploymentFailureCause(), deploymentContext.getStackTrace());
        } else {
            log.error((Object)deploymentContext.getDeploymentFailureCause());
        }
        this.repository.handleBPELPackageDeploymentError(deploymentContext);
    }

    private void reloadExistingVersionsOfBPELPackage(BPELDeploymentContext deploymentContext) throws RegistryException {
        BPELPackageInfo bpelPackage = this.repository.getBPELPackageInfo(deploymentContext);
        for (String packageName : bpelPackage.getAvailableVersions()) {
            this.loadExistingBPELPackage(packageName);
        }
    }

    private void deployBPELPackageInODE(BPELDeploymentContext deploymentContext) throws Exception {
        File bpelPackage = deploymentContext.getBPELPackageContent();
        log.info((Object)("Starting deployment of processes from directory " + bpelPackage.getAbsolutePath()));
        Date deployDate = new Date();
        DeploymentUnitDir du = new DeploymentUnitDir(bpelPackage);
        du.setVersion(du.getStaticVersion());
        try {
            du.compile();
        }
        catch (CompilationException ce) {
            String logMessage = "Deployment failed due to compilation issues.";
            log.error((Object)logMessage, (Throwable)ce);
            throw new BPELDeploymentException(logMessage, ce);
        }
        du.scan();
        DeployDocument dd = du.getDeploymentDescriptor();
        ArrayList<ProcessConfigurationImpl> processConfs = new ArrayList<ProcessConfigurationImpl>();
        ArrayList<QName> processIds = new ArrayList<QName>();
        if (this.deploymentUnits.containsKey(du.getName())) {
            String logMessage = "Aborting deployment. Duplicate Deployment unit " + du.getName() + ".";
            log.error((Object)logMessage);
            throw new BPELDeploymentException(logMessage);
        }
        this.validateBPELPackage(du);
        this.retirePreviousPackageVersions(du);
        for (TDeployment.Process processDD : dd.getDeploy().getProcessList()) {
            QName processId = Utils.toPid(processDD.getName(), du.getVersion());
            processConfs.add(new ProcessConfigurationImpl(this.tenantId, processDD, du, deployDate, this.parentProcessStore.getEndpointReferenceContext(), this.tenantConfigContext));
            processIds.add(processId);
        }
        this.deploymentUnits.put(du.getName(), du);
        this.processesInDeploymentUnit.put(du.getName(), processIds);
        for (ProcessConfigurationImpl processConf : processConfs) {
            this.processes.put(processConf.getProcessId(), processConf);
            deploymentContext.addProcessId(processConf.getProcessId());
        }
        try {
            this.parentProcessStore.onBPELPackageDeployment(this.tenantId, du.getName(), BPELPackageRepositoryUtils.getResourcePathForBPELPackageContent(deploymentContext), processConfs);
        }
        catch (ContextException ce) {
            this.handleDeploymentErrorsAtODELayer(deploymentContext, du.getName());
            deploymentContext.setDeploymentFailureCause("BPEL Package deployment failed at ODE layer. Possible cause: " + ce.getMessage());
            deploymentContext.setStackTrace(ce);
            try {
                this.handleDeploymentError(deploymentContext);
            }
            catch (Exception e) {
                e.initCause(ce);
                throw e;
            }
            throw ce;
        }
    }

    private void validateBPELPackage(DeploymentUnitDir du) throws BPELDeploymentException {
        DeployDocument dd = du.getDeploymentDescriptor();
        for (TDeployment.Process processDD : dd.getDeploy().getProcessList()) {
            QName processId = Utils.toPid(processDD.getName(), du.getVersion());
            if (this.processes.containsKey(processId)) {
                String logMessage = "Aborting deployment. Duplicate process ID " + processId + ".";
                log.error((Object)logMessage);
                throw new BPELDeploymentException(logMessage);
            }
            QName processType = Utils.getProcessType(processDD);
            DeploymentUnitDir.CBPInfo cbpInfo = du.getCBPInfo(processType);
            if (cbpInfo != null) continue;
            String logMessage = "Aborting deployment. Cannot find Process definition for type " + processType + ".";
            log.error((Object)logMessage);
            throw new BPELDeploymentException(logMessage);
        }
    }

    private void handleDeploymentErrorsAtODELayer(BPELDeploymentContext deploymentContext, String duName) {
        this.deploymentUnits.remove(duName);
        this.processesInDeploymentUnit.remove(duName);
        for (QName pid : deploymentContext.getProcessIdsForCurrentDeployment()) {
            this.processes.remove(pid);
        }
    }

    private void loadExistingBPELPackage(String bpelPackageName) {
        DeploymentUnitDAO duDAO = this.parentProcessStore.getDeploymentUnitDAO(bpelPackageName);
        if (duDAO == null) {
            String errMsg = "Cannot find DeploymentUnitDAO instance for package " + bpelPackageName + ".";
            log.error((Object)errMsg);
            throw new BPELDeploymentException(errMsg);
        }
        File bpelPackage = this.findBPELPackageInFileSystem(duDAO);
        if (bpelPackage == null || !bpelPackage.exists()) {
            throw new BPELDeploymentException("Deployed directory " + (bpelPackage == null ? "(unknown)" : bpelPackage) + " no longer there!");
        }
        DeploymentUnitDir du = new DeploymentUnitDir(bpelPackage);
        du.setVersion(du.getStaticVersion());
        du.scan();
        ArrayList<ProcessConfigurationImpl> loaded = new ArrayList<ProcessConfigurationImpl>();
        ArrayList<QName> processIds = new ArrayList<QName>();
        for (ProcessConfDAO pConfDAO : duDAO.getProcesses()) {
            TDeployment.Process processDD = du.getProcessDeployInfo(pConfDAO.getType());
            if (processDD == null) {
                log.warn((Object)("Cannot load " + pConfDAO.getPID() + "; cannot find descriptor."));
                continue;
            }
            ProcessConfigurationImpl pConf = new ProcessConfigurationImpl(this.tenantId, processDD, du, duDAO.getDeployDate(), this.parentProcessStore.getEndpointReferenceContext(), this.tenantConfigContext);
            pConf.setState(pConfDAO.getState());
            processIds.add(pConfDAO.getPID());
            this.processes.put(pConf.getProcessId(), pConf);
            loaded.add(pConf);
        }
        this.deploymentUnits.put(du.getName(), du);
        this.processesInDeploymentUnit.put(du.getName(), processIds);
        this.parentProcessStore.onBPELPackageReload(this.tenantId, du.getName(), loaded);
    }

    private File findBPELPackageInFileSystem(DeploymentUnitDAO dudao) {
        String duName = dudao.getName();
        log.info((Object)("Looking for BPEL package in file system for deployment unit " + duName));
        File bpelDUDirectory = new File(this.bpelDURepo, duName);
        if (bpelDUDirectory.exists()) {
            return bpelDUDirectory;
        }
        String registryCollectionPath = dudao.getDeploymentUnitDir();
        try {
            if (this.tenantConfigRegistry.resourceExists(registryCollectionPath)) {
                if (!bpelDUDirectory.exists() && !bpelDUDirectory.mkdirs()) {
                    String errMsg = "Error creating BPEL deployment unit repository for tenant " + this.tenantId;
                    log.error((Object)errMsg);
                    log.error((Object)("Failed to load BPEL deployment unit " + duName + " due to above error."));
                    throw new BPELDeploymentException(errMsg);
                }
                RegistryClientUtils.exportFromRegistry((File)bpelDUDirectory, (String)registryCollectionPath, (Registry)this.tenantConfigRegistry);
                return bpelDUDirectory;
            }
            String errMsg = "Expected resource: " + registryCollectionPath + " not found in the registry";
            log.error((Object)errMsg);
            throw new BPELDeploymentException(errMsg);
        }
        catch (RegistryException re) {
            String errMsg = "Error while exporting deployment unit: " + duName + " to file system from the registry.";
            log.error((Object)errMsg, (Throwable)re);
            throw new BPELDeploymentException(errMsg, re);
        }
    }

    private void retirePreviousPackageVersions(DeploymentUnitDir du) {
        String[] nameParts = du.getName().split("/");
        nameParts[0] = nameParts[0].replaceAll("([-\\Q.\\E](\\d)+)?\\z", "");
        nameParts[0] = nameParts[0] + "([-\\Q.\\E](\\d)+)?";
        StringBuilder duNameRegExp = new StringBuilder(du.getName().length() * 2);
        int n = nameParts.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                duNameRegExp.append("/");
            }
            duNameRegExp.append(nameParts[i]);
        }
        Pattern duNamePattern = Pattern.compile(duNameRegExp.toString());
        for (String deployedDUname : this.deploymentUnits.keySet()) {
            Matcher matcher = duNamePattern.matcher(deployedDUname);
            if (!matcher.matches()) continue;
            this.parentProcessStore.setRetiredPackage(deployedDUname, true);
        }
    }

    private boolean validateBPELPackage(BPELDeploymentContext bpelDeploymentContext, boolean isExistingPackage) {
        DeploymentUnitDir du;
        try {
            du = new DeploymentUnitDir(bpelDeploymentContext.getBPELPackageContent());
        }
        catch (IllegalArgumentException e) {
            bpelDeploymentContext.setDeploymentFailureCause(e.getMessage());
            bpelDeploymentContext.setStackTrace(e);
            return false;
        }
        if (!isExistingPackage) {
            DeployDocument deployDocument = du.getDeploymentDescriptor();
            List processList = deployDocument.getDeploy().getProcessList();
            for (TDeployment.Process process : processList) {
                List provideList = process.getProvideList();
                for (TProvide provide : provideList) {
                    if (!this.getDeployedServices().containsKey(provide.getService().getName())) continue;
                    String errMsg = "Service: " + provide.getService().getName() + " already " + "used by another process. Try again with a different " + "service name";
                    bpelDeploymentContext.setDeploymentFailureCause(errMsg);
                    return false;
                }
            }
        }
        return true;
    }

    private void attachWithCapp(String bpelArchiveName, String bpelPackageName, int tenantId) {
        AppDeployerUtils.attachArtifactToOwnerApp((String)bpelArchiveName, (String)"bpel/workflow", (String)bpelPackageName, (int)tenantId);
    }

    @Override
    public Map<QName, Object> getDeployedServices() {
        return this.parentProcessStore.getServicesPublishedByTenant(this.tenantId);
    }
}

