/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.store;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.pmapi.ManagementException;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.internal.BPELServiceComponent;
import org.wso2.carbon.bpel.ode.integration.BPELServerImpl;
import org.wso2.carbon.bpel.ode.integration.store.BPELDeploymentContext;

public class Utils {
    private static Log log = LogFactory.getLog(Utils.class);
    private static final String HEXES = "0123456789ABCDEF";
    public static final Comparator<String> BY_VERSION = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String[] nameParts1 = o1.split("/");
            String version1 = nameParts1[0].substring(nameParts1[0].lastIndexOf("-") + 1);
            String[] nameParts2 = o2.split("/");
            String version2 = nameParts2[0].substring(nameParts2[0].lastIndexOf("-") + 1);
            return Integer.parseInt(version1) - Integer.parseInt(version2);
        }
    };

    private Utils() {
    }

    public static Map<QName, Node> calcInitialProperties(Properties properties, TDeployment.Process dd) {
        Document doc;
        HashMap<QName, Node> ret = new HashMap<QName, Node>();
        for (Object key1 : properties.keySet()) {
            String key = (String)key1;
            doc = DOMUtils.newDocument();
            doc.appendChild(doc.createElementNS(null, "temporary-simple-type-wrapper"));
            doc.getDocumentElement().appendChild(doc.createTextNode(properties.getProperty(key)));
            ret.put(new QName(key), doc.getDocumentElement());
        }
        if (dd.getPropertyList().size() > 0) {
            for (TDeployment.Process.Property property : dd.getPropertyList()) {
                Element elementContent = DOMUtils.getElementContent((Node)property.getDomNode());
                if (elementContent != null) {
                    doc = DOMUtils.newDocument();
                    doc.appendChild(doc.importNode(elementContent, true));
                    ret.put(property.getName(), doc.getDocumentElement());
                    continue;
                }
                ret.put(property.getName(), property.getDomNode().getFirstChild());
            }
        }
        return ret;
    }

    public static ProcessState calcInitialState(TDeployment.Process dd) {
        ProcessState state = ProcessState.ACTIVE;
        if (dd.isSetActive() && !dd.getActive()) {
            state = ProcessState.DISABLED;
        }
        if (dd.isSetRetired() && dd.getRetired()) {
            state = ProcessState.RETIRED;
        }
        return state;
    }

    public static QName toPid(QName processType, long version) {
        return new QName(processType.getNamespaceURI(), processType.getLocalPart() + "-" + version);
    }

    public static QName getProcessType(TDeployment.Process processDescriptor) {
        return processDescriptor.getType() != null ? processDescriptor.getType() : processDescriptor.getName();
    }

    public static void extractBPELArchive(BPELDeploymentContext deploymentContext) throws Exception {
        try {
            ZipEntry entry;
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(deploymentContext.getBpelArchive()));
            while ((entry = zipStream.getNextEntry()) != null) {
                File destFile;
                if (entry.isDirectory()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extracting directory " + entry.getName()));
                    }
                    if (new File(deploymentContext.getBpelPackageLocationInFileSystem(), entry.getName()).mkdirs()) continue;
                    throw new Exception("Archive extraction failed. Cannot create directory: " + new File(deploymentContext.getBpelPackageLocationInFileSystem(), entry.getName()).getAbsolutePath() + ".");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Extracting file " + entry.getName()));
                }
                if (!(destFile = new File(deploymentContext.getBpelPackageLocationInFileSystem(), entry.getName())).getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                    throw new Exception("Archive extraction failed. Cannot create directory: " + destFile.getParentFile().getAbsolutePath());
                }
                Utils.copyInputStream(zipStream, new BufferedOutputStream(new FileOutputStream(destFile)));
            }
            zipStream.close();
            deploymentContext.setBPELPackageContent(new File(deploymentContext.getBpelPackageLocationInFileSystem()));
        }
        catch (IOException e) {
            String errMsg = "Error occurred during extracting the archive: " + deploymentContext.getArchiveName();
            log.error((Object)errMsg, (Throwable)e);
            throw new Exception(errMsg, e);
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
    }

    public static void deleteInstances(Collection<QName> processes) {
        if (processes != null) {
            String filter = null;
            for (QName q : processes) {
                if (filter == null) {
                    filter = "pid=" + q.toString();
                    continue;
                }
                filter = filter + "|" + q.toString();
            }
            List<Long> iids = Utils.delete(filter);
            Utils.logIids(processes, iids);
        } else {
            log.warn((Object)"No processes found to delete instances");
        }
    }

    public static List<Long> delete(String filter) {
        log.info((Object)("Instance filter for instance deletion:" + filter));
        final InstanceFilter instanceFilter = new InstanceFilter(filter);
        final LinkedList<Long> ret = new LinkedList<Long>();
        try {
            Utils.dbexec(new BpelDatabase.Callable<Object>(){

                public Object run(BpelDAOConnection conn) {
                    Collection instances = conn.instanceQuery(instanceFilter);
                    for (ProcessInstanceDAO instance : instances) {
                        instance.delete(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class), true);
                        ret.add(instance.getInstanceId());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String errMsg = "Exception during instance deletion. Filter: " + filter;
            log.error((Object)errMsg, (Throwable)e);
            throw new ManagementException(errMsg, (Throwable)e);
        }
        return ret;
    }

    private static void logIids(Collection<QName> pids, List<Long> ids) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deleting instances of processes: ");
            for (QName q : pids) {
                log.debug((Object)q);
            }
            log.debug((Object)"Instance IDs:");
            for (Long l : ids) {
                log.debug((Object)l);
            }
        }
    }

    private static <T> T dbexec(BpelDatabase.Callable<T> callable) throws ManagementException {
        try {
            BPELServerImpl bpelServer = (BPELServerImpl)BPELServiceComponent.getBPELServer();
            BpelDatabase bpelDb = bpelServer.getODEBPELServer().getBpelDb();
            return (T)bpelDb.exec(callable);
        }
        catch (ManagementException me) {
            throw me;
        }
        catch (Exception ex) {
            log.error((Object)"Exception during database operation", (Throwable)ex);
            throw new ManagementException("Exception during database operation", (Throwable)ex);
        }
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static byte[] createChecksum(File fileToCalculateMD5) throws IOException, NoSuchAlgorithmException {
        int numRead;
        FileInputStream fis = new FileInputStream(fileToCalculateMD5);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String getMD5Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Utils.createChecksum(file);
        return Utils.getHex(b);
    }
}

