/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.store.clustering;

import javax.xml.namespace.QName;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ProcessState;
import org.wso2.carbon.bpel.ode.integration.store.ProcessStoreImpl;
import org.wso2.carbon.bpel.ode.integration.store.TenantProcessStore;

public class BPELProcessStateChangedCommand
extends StateClusteringCommand {
    private static final Log log = LogFactory.getLog((String)"org.wso2.carbon.bpel.deployment");
    private Integer tenantId;
    private QName pid;
    private ProcessState processState;

    public BPELProcessStateChangedCommand(QName pid, ProcessState processState, Integer tenantId) {
        this.pid = pid;
        this.processState = processState;
        this.tenantId = tenantId;
    }

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("New state changed command received. Process: " + this.pid + " New state: " + this.processState + " Tenant: " + this.tenantId));
        }
        ProcessStoreImpl parentProcessStore = (ProcessStoreImpl)configurationContext.getAxisConfiguration().getParameter("bpel.process-store").getValue();
        TenantProcessStore tenantProcessStore = parentProcessStore.getTenantsProcessStore(this.tenantId);
        tenantProcessStore.handleBPELProcessStateChangedNotification(this.pid, this.processState);
    }
}

