/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.store.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.ode.integration.store.BPELDeploymentContext;
import org.wso2.carbon.bpel.ode.integration.store.Utils;
import org.wso2.carbon.bpel.ode.integration.store.repository.BPELPackageInfo;
import org.wso2.carbon.bpel.ode.integration.store.repository.BPELPackageRepositoryUtils;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryClientUtils;

public class BPELPackageRepository {
    private static Log log = LogFactory.getLog((String)"org.wso2.carbon.bpel.deployment");
    private Registry configRegistry;
    private File bpelDURepo;
    private File bpelArchiveRepo;

    public BPELPackageRepository(Registry configRegistry, File bpelDURepo, File bpelArchiveRepo) {
        this.configRegistry = configRegistry;
        this.bpelDURepo = bpelDURepo;
        this.bpelArchiveRepo = bpelArchiveRepo;
    }

    public void init() throws Exception {
        this.fixLocalBPELArchiveRepository();
    }

    private void addLatestArchiveToRegistryCollection(BPELDeploymentContext bpelDeploymentContext) throws FileNotFoundException, RegistryException {
        Resource latestBPELArchive = this.configRegistry.newResource();
        latestBPELArchive.setContent((Object)new FileInputStream(bpelDeploymentContext.getBpelArchive()));
        this.configRegistry.put(BPELPackageRepositoryUtils.getBPELPackageArchiveResourcePath(bpelDeploymentContext.getBpelPackageName()), latestBPELArchive);
    }

    public void handleNewBPELPackageAddition(BPELDeploymentContext deploymentContext) throws Exception {
        try {
            if (!this.isDUCollectionIsThere(deploymentContext)) {
                this.configRegistry.beginTransaction();
                this.createBPELPackageParentCollectionWithProperties(deploymentContext);
                this.addLatestArchiveToRegistryCollection(deploymentContext);
                this.createCollectionWithBPELPackageContentForCurrentVersion(deploymentContext);
                this.configRegistry.commitTransaction();
            }
        }
        catch (RegistryException re) {
            this.handleExceptionWithRollback("Unable to handle new BPEL Package addition. Package: " + deploymentContext.getBpelPackageName(), (Exception)((Object)re));
        }
        catch (NoSuchAlgorithmException e) {
            this.handleExceptionWithRollback("Unable to generate MD5. Adding BPEL package " + deploymentContext.getBpelPackageName() + " to registry failed.", e);
        }
        catch (IOException e) {
            this.handleExceptionWithRollback("Unable to find file to generate MD5. Adding BPEL package " + deploymentContext.getBpelPackageName() + " to registry failed.", e);
        }
    }

    public void handleBPELPackageUpdate(BPELDeploymentContext deploymentContext) throws Exception {
        try {
            if (!this.isDUCollectionIsThere(deploymentContext)) {
                this.configRegistry.beginTransaction();
                this.updateBPELPackageProperties(deploymentContext);
                this.addLatestArchiveToRegistryCollection(deploymentContext);
                this.createCollectionWithBPELPackageContentForCurrentVersion(deploymentContext);
                this.configRegistry.commitTransaction();
            }
        }
        catch (RegistryException re) {
            this.handleExceptionWithRollback("Unable to handle BPEL package update. Package: " + deploymentContext.getBpelPackageName(), (Exception)((Object)re));
        }
        catch (NoSuchAlgorithmException e) {
            this.handleExceptionWithRollback("Unable to generate MD5. Adding BPEL package " + deploymentContext.getBpelPackageName() + " to registry failed.", e);
        }
        catch (IOException e) {
            this.handleExceptionWithRollback("Unable to find file to generate MD5. Adding BPEL package " + deploymentContext.getBpelPackageName() + " to registry failed.", e);
        }
    }

    public void handleBPELPackageDeploymentError(BPELDeploymentContext deploymentContext) throws Exception {
        try {
            if (this.isExistingBPELPackage(deploymentContext).booleanValue()) {
                this.updateExistingBPELPackageOnLastDeploymentError(deploymentContext);
            } else {
                this.storeMetaDataAboutFailedNewBPELPackageDeployment(deploymentContext);
            }
        }
        catch (RegistryException re) {
            String errMessage = "Unable to handle BPEL package deployment error persistence. Package: " + deploymentContext.getBpelPackageName();
            log.error((Object)errMessage, (Throwable)re);
            throw re;
        }
        catch (NoSuchAlgorithmException e) {
            this.handleExceptionWithRollback("Unable to generate MD5. Adding BPEL package " + deploymentContext.getBpelPackageName() + " to registry failed.", e);
        }
        catch (IOException e) {
            this.handleExceptionWithRollback("Unable to find file to generate MD5. Adding BPEL package " + deploymentContext.getBpelPackageName() + " to registry failed.", e);
        }
    }

    public void handleBPELPackageUndeploy(String packageName) throws RegistryException {
        try {
            String packageLocation = BPELPackageRepositoryUtils.getResourcePathForBPELPackage(packageName);
            this.configRegistry.delete(packageLocation);
        }
        catch (RegistryException re) {
            String errMessage = "Unable to access registry for handling BPEL package undeployment. Package: " + packageName;
            log.error((Object)errMessage, (Throwable)re);
            throw re;
        }
    }

    public Boolean isExistingBPELPackage(BPELDeploymentContext deploymentContext) throws RegistryException {
        return this.configRegistry.resourceExists(BPELPackageRepositoryUtils.getResourcePathForBPELPackage(deploymentContext) + "/versions/");
    }

    public Boolean isExistingBPELPackage(String packageName) throws RegistryException {
        return this.configRegistry.resourceExists(BPELPackageRepositoryUtils.getResourcePathForBPELPackage(packageName));
    }

    public Boolean isBPELPackageReload(BPELDeploymentContext deploymentContext) throws RegistryException, IOException, NoSuchAlgorithmException {
        String resourceLocation = BPELPackageRepositoryUtils.getResourcePathForBPELPackage(deploymentContext);
        if (this.configRegistry.resourceExists(resourceLocation)) {
            String md5Checksum = this.configRegistry.get(resourceLocation).getProperty("bpel.package.latest.checksum");
            if (log.isDebugEnabled()) {
                log.debug((Object)(deploymentContext.getBpelPackageName() + " Checksum in registry: " + md5Checksum + " : File checksum: " + Utils.getMD5Checksum(deploymentContext.getBpelArchive())));
            }
            return md5Checksum.equals(Utils.getMD5Checksum(deploymentContext.getBpelArchive()));
        }
        return false;
    }

    public BPELPackageInfo getBPELPackageInfo(BPELDeploymentContext deploymentContext) throws RegistryException {
        return this.getBPELPackageInfo(BPELPackageRepositoryUtils.getResourcePathForBPELPackage(deploymentContext));
    }

    public List<BPELPackageInfo> getBPELPackages() throws Exception {
        ArrayList<BPELPackageInfo> bpelPackages = new ArrayList<BPELPackageInfo>();
        try {
            if (this.configRegistry.resourceExists("/bpel/packages/")) {
                String[] children;
                Resource parentCollection = this.configRegistry.get("/bpel/packages/");
                for (String childPath : children = (String[])parentCollection.getContent()) {
                    bpelPackages.add(this.getBPELPackageInfo(childPath));
                }
                return bpelPackages;
            }
        }
        catch (RegistryException re) {
            this.handleExceptionWithRollback("Unable to get BPEL Packages from Repository.", (Exception)((Object)re));
        }
        return null;
    }

    private void fixLocalBPELArchiveRepository() throws Exception {
        List<BPELPackageInfo> bpelPackages = this.getBPELPackages();
        if (this.bpelArchiveRepo != null && bpelPackages != null) {
            for (BPELPackageInfo bpelPackage : bpelPackages) {
                this.restoreBPELArchive(bpelPackage);
            }
        }
    }

    public void restoreBPELArchive(BPELPackageInfo bpelPackage) throws RegistryException, IOException, NoSuchAlgorithmException {
        File bpelArchive = new File(this.bpelArchiveRepo, bpelPackage.getBPELArchiveFileName());
        if (log.isDebugEnabled() && bpelArchive.exists()) {
            log.debug((Object)(bpelPackage.getName() + " File checksum: " + Utils.getMD5Checksum(bpelArchive) + " : " + bpelPackage.getChecksum()));
        }
        if (!bpelArchive.exists() || bpelArchive.exists() && !Utils.getMD5Checksum(bpelArchive).equals(bpelPackage.getChecksum())) {
            if (bpelArchive.exists()) {
                log.info((Object)("Cannot find BPEL archive " + this.bpelArchiveRepo.getAbsolutePath() + " : " + bpelPackage.getBPELArchiveFileName() + " in the local repository. Re-storing from the registry"));
            } else {
                log.info((Object)("Updated BPEL archive found in registry: " + bpelPackage.getName() + " Re-storing from the registry"));
            }
            String bpelPackageZipLocation = bpelPackage.getPackageLocationInRegistry() + "/bpelArchive";
            if (!this.configRegistry.resourceExists(bpelPackageZipLocation)) {
                log.warn((Object)("Cannot restore " + bpelPackage.getName() + " from registry. The resource: " + bpelPackageZipLocation + " does not exist."));
                return;
            }
            RegistryClientUtils.exportFromRegistry((File)new File(this.bpelArchiveRepo, bpelPackage.getBPELArchiveFileName()), (String)bpelPackageZipLocation, (Registry)this.configRegistry);
        }
    }

    public BPELPackageInfo getBPELPackageInfo(String packageLocationInRegistry) throws RegistryException {
        BPELPackageInfo bpelPackage = new BPELPackageInfo();
        String name = packageLocationInRegistry.substring(packageLocationInRegistry.lastIndexOf("/") + 1);
        bpelPackage.setName(name);
        bpelPackage.setPackageLocationInRegistry(packageLocationInRegistry);
        Resource packageResource = this.configRegistry.get(packageLocationInRegistry);
        bpelPackage.setLatestVersion(packageResource.getProperty("bpel.package.latest.version"));
        bpelPackage.setChecksum(packageResource.getProperty("bpel.package.latest.checksum"));
        BPELPackageInfo.Status status = this.getStatus(packageResource.getProperty("bpel.package.status"));
        bpelPackage.setStatus(status);
        if (status.equals((Object)BPELPackageInfo.Status.FAILED)) {
            bpelPackage.setCauseForDeploymentFailure(packageResource.getProperty("bpel.package.error.log"));
        }
        bpelPackage.setAvailableVersions(this.getVersionsOfPackage(packageLocationInRegistry));
        return bpelPackage;
    }

    public List<String> getAllVersionsForPackage(String packageName) throws RegistryException {
        return this.getVersionsOfPackage(BPELPackageRepositoryUtils.getResourcePathForBPELPackage(packageName));
    }

    private List<String> getVersionsOfPackage(String packageLocation) throws RegistryException {
        ArrayList<String> versions = new ArrayList<String>();
        String versionsLocation = packageLocation + "/versions/";
        if (this.configRegistry.resourceExists(versionsLocation)) {
            String[] children;
            Resource versionsResource = this.configRegistry.get(versionsLocation);
            for (String child : children = (String[])versionsResource.getContent()) {
                versions.add(child.substring(child.lastIndexOf("/") + 1));
            }
            Collections.sort(versions, Utils.BY_VERSION);
        }
        return versions;
    }

    private BPELPackageInfo.Status getStatus(String status) {
        if (status.equals("DEPLOYED")) {
            return BPELPackageInfo.Status.DEPLOYED;
        }
        if (status.equals("FAILED")) {
            return BPELPackageInfo.Status.FAILED;
        }
        if (status.equals("UNDEPLOYED")) {
            return BPELPackageInfo.Status.UNDEPLOYED;
        }
        if (status.equals("UPDATED")) {
            return BPELPackageInfo.Status.UPDATED;
        }
        return BPELPackageInfo.Status.UNDEFINED;
    }

    private void createBPELPackageParentCollectionWithProperties(BPELDeploymentContext deploymentContext) throws RegistryException, IOException, NoSuchAlgorithmException {
        Collection bpelPackage = this.configRegistry.newCollection();
        bpelPackage.setProperty("bpel.package.latest.checksum", Utils.getMD5Checksum(deploymentContext.getBpelArchive()));
        if (log.isDebugEnabled()) {
            log.debug((Object)(deploymentContext.getBpelPackageName() + " updating checksum: " + Utils.getMD5Checksum(deploymentContext.getBpelArchive()) + " in registry"));
        }
        bpelPackage.setProperty("bpel.package.status", "DEPLOYED");
        bpelPackage.setProperty("bpel.package.latest.version", Long.toString(deploymentContext.getVersion()));
        this.configRegistry.put(BPELPackageRepositoryUtils.getResourcePathForBPELPackage(deploymentContext), (Resource)bpelPackage);
    }

    private void createCollectionWithBPELPackageContentForCurrentVersion(BPELDeploymentContext deploymentContext) throws RegistryException {
        String collectionLocation = BPELPackageRepositoryUtils.getResourcePathForBPELPackageVersions(deploymentContext);
        RegistryClientUtils.importToRegistry((File)deploymentContext.getBPELPackageContent(), (String)collectionLocation, (Registry)this.configRegistry);
    }

    private boolean isDUCollectionIsThere(BPELDeploymentContext deploymentContext) throws RegistryException {
        String collectionLocation = BPELPackageRepositoryUtils.getResourcePathForBPELPackageContent(deploymentContext);
        return this.configRegistry.resourceExists(collectionLocation);
    }

    private void updateBPELPackageProperties(BPELDeploymentContext deploymentContext) throws RegistryException, IOException, NoSuchAlgorithmException {
        String packageLocation = BPELPackageRepositoryUtils.getResourcePathForBPELPackage(deploymentContext);
        Resource bpelPackage = this.configRegistry.get(packageLocation);
        bpelPackage.setProperty("bpel.package.latest.checksum", Utils.getMD5Checksum(deploymentContext.getBpelArchive()));
        if (log.isDebugEnabled()) {
            log.debug((Object)(deploymentContext.getBpelPackageName() + " updated checksum to: " + Utils.getMD5Checksum(deploymentContext.getBpelArchive())));
        }
        bpelPackage.setProperty("bpel.package.status", "UPDATED");
        bpelPackage.setProperty("bpel.package.latest.version", Long.toString(deploymentContext.getVersion()));
        this.configRegistry.put(packageLocation, bpelPackage);
    }

    private void updateExistingBPELPackageOnLastDeploymentError(BPELDeploymentContext deploymentContext) throws RegistryException, IOException, NoSuchAlgorithmException {
        String packageLocation = BPELPackageRepositoryUtils.getResourcePathForBPELPackage(deploymentContext);
        Resource bpelPackage = this.configRegistry.get(packageLocation);
        BPELPackageRepository.setBPELPackagePropertiesOnFailure(bpelPackage, deploymentContext);
        this.configRegistry.put(packageLocation, bpelPackage);
    }

    private void storeMetaDataAboutFailedNewBPELPackageDeployment(BPELDeploymentContext deploymentContext) throws RegistryException, IOException, NoSuchAlgorithmException {
        Collection bpelPackage = this.configRegistry.newCollection();
        BPELPackageRepository.setBPELPackagePropertiesOnFailure((Resource)bpelPackage, deploymentContext);
        this.configRegistry.put(BPELPackageRepositoryUtils.getResourcePathForBPELPackage(deploymentContext), (Resource)bpelPackage);
    }

    private static void setBPELPackagePropertiesOnFailure(Resource bpelPackage, BPELDeploymentContext deploymentContext) throws RegistryException, IOException, NoSuchAlgorithmException {
        bpelPackage.setProperty("bpel.package.status", "FAILED");
        bpelPackage.setProperty("bpel.package.latest.checksum", Utils.getMD5Checksum(deploymentContext.getBpelArchive()));
        if (log.isDebugEnabled()) {
            log.debug((Object)(deploymentContext.getBpelPackageName() + " updating checksum to: " + Utils.getMD5Checksum(deploymentContext.getBpelArchive())));
        }
        bpelPackage.setProperty("bpel.package.error.log", deploymentContext.getDeploymentFailureCause());
    }

    protected void handleExceptionWithRollback(String msg, Exception e) throws Exception {
        RegistryException cachedException = null;
        log.error((Object)msg, (Throwable)e);
        try {
            this.configRegistry.rollbackTransaction();
        }
        catch (RegistryException re) {
            cachedException = re;
            log.error((Object)"Transaction rollback failed", (Throwable)re);
        }
        if (cachedException != null) {
            cachedException.initCause(e);
            throw cachedException;
        }
        throw e;
    }
}

