/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.ode.bpel.evt.ActivityEnabledEvent;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.ActivityExecEndEvent;
import org.apache.ode.bpel.evt.ActivityExecStartEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evtproc.ActivityStateDocumentBuilder;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.pmapi.ActivityInfoDocument;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.TEventInfo;
import org.apache.ode.bpel.pmapi.TEventInfoList;
import org.wso2.carbon.bpel.ode.integration.utils.ActivityInfoWithEventsDocument;

public class ActivityStateAndEventDocumentBuilder
extends ActivityStateDocumentBuilder
implements BpelEventListener {
    private ArrayList<ActivityInfoWithEventsDocument> activitiesWithEventsOrdered = new ArrayList();
    private HashMap<Long, ActivityInfoWithEventsDocument> activitiesWithEvents = new HashMap();
    private boolean removeCompleted = false;

    public void onEvent(BpelEvent be) {
        super.onEvent(be);
        List infoDocList = super.getActivities();
        if (be instanceof ActivityEvent) {
            ActivityEvent event = (ActivityEvent)be;
            this.fillActivityInfo(event, infoDocList);
            ActivityInfoWithEventsDocument actinf = this.lookup(event);
            assert (actinf != null);
            if (event instanceof ActivityEnabledEvent) {
                // empty if block
            }
            if (event instanceof ActivityExecStartEvent || event instanceof ActivityExecEndEvent) {
                // empty if block
            }
        }
    }

    private void fillActivityInfo(ActivityEvent be, List<ActivityInfoDocument> infoDocList) {
        ActivityInfoDocument infoDoc = null;
        for (ActivityInfoDocument inf : infoDocList) {
            if (!inf.getActivityInfo().getAiid().equals(String.valueOf(be.getActivityId()))) continue;
            infoDoc = inf;
        }
        if (this.activitiesWithEvents.get(be.getActivityId()) == null) {
            this.activitiesWithEvents.put(be.getActivityId(), new ActivityInfoWithEventsDocument(infoDoc));
        }
        this.addActivitiesWithEventOrdered(String.valueOf(be.getActivityId()), infoDoc);
    }

    private void completed(ActivityInfoWithEventsDocument ainf) {
        if (this.removeCompleted) {
            this.activitiesWithEventsOrdered.remove(ainf);
            this.activitiesWithEvents.values().remove(ainf);
        }
    }

    private ActivityInfoWithEventsDocument lookup(ActivityEvent event) {
        TEventInfo eventInfo;
        ActivityInfoWithEventsDocument actEvtInfoDoc = this.activitiesWithEvents.get(event.getActivityId());
        ActivityInfoDocument aInfo = actEvtInfoDoc.getActivityInfoDoc();
        EventInfoListDocument aEventList = actEvtInfoDoc.getEventInfoList();
        if (aEventList == null) {
            aEventList = EventInfoListDocument.Factory.newInstance();
            actEvtInfoDoc.setEventInfoList(aEventList);
            aEventList = actEvtInfoDoc.getEventInfoList();
        }
        if (aEventList.getEventInfoList() == null) {
            TEventInfoList eventInfoList = aEventList.addNewEventInfoList();
            eventInfo = eventInfoList.addNewEventInfo();
        } else {
            eventInfo = aEventList.getEventInfoList().addNewEventInfo();
        }
        this.fillEventInfo(eventInfo, event);
        this.addActivitiesWithEventOrdered(event, new ActivityInfoWithEventsDocument(aInfo, aEventList));
        return this.activitiesWithEvents.get(event.getActivityId());
    }

    private void addActivitiesWithEventOrdered(String activityID, ActivityInfoDocument infoDoc) {
        boolean isExist = false;
        for (int i = 0; i < this.activitiesWithEventsOrdered.size(); ++i) {
            if (!this.activitiesWithEventsOrdered.get(i).getActivityInfoDoc().getActivityInfo().getAiid().equals(infoDoc.getActivityInfo().getAiid())) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            this.activitiesWithEventsOrdered.add(new ActivityInfoWithEventsDocument(infoDoc));
        }
    }

    private void addActivitiesWithEventOrdered(ActivityEvent event, ActivityInfoWithEventsDocument infoWithEventsDoc) {
        boolean isExist = false;
        for (int i = 0; i < this.activitiesWithEventsOrdered.size(); ++i) {
            TEventInfo eventInfo;
            if (!this.activitiesWithEventsOrdered.get(i).getActivityInfoDoc().getActivityInfo().getAiid().equals(infoWithEventsDoc.getActivityInfoDoc().getActivityInfo().getAiid())) continue;
            isExist = true;
            EventInfoListDocument aEventList = this.activitiesWithEventsOrdered.get(i).getEventInfoList();
            if (aEventList == null) {
                aEventList = EventInfoListDocument.Factory.newInstance();
                this.activitiesWithEventsOrdered.get(i).setEventInfoList(aEventList);
                aEventList = this.activitiesWithEventsOrdered.get(i).getEventInfoList();
            }
            if (aEventList.getEventInfoList() == null) {
                TEventInfoList eventInfoList = aEventList.addNewEventInfoList();
                eventInfo = eventInfoList.addNewEventInfo();
            } else {
                eventInfo = aEventList.getEventInfoList().addNewEventInfo();
            }
            this.fillEventInfo(eventInfo, event);
            break;
        }
        if (!isExist) {
            this.activitiesWithEventsOrdered.add(infoWithEventsDoc);
        }
    }

    private void fillEventInfo(TEventInfo info, ActivityEvent event) {
        info.setActivityType(event.getActivityType());
        info.setActivityDefinitionId(event.getActivityDeclarationId());
        info.setActivityId(event.getActivityId());
        info.setActivityName(event.getActivityName());
        info.setLineNumber(event.getLineNo());
        info.setName(BpelEvent.eventName((BpelEvent)event));
        info.setProcessId(event.getProcessId());
        info.setScopeId(event.getScopeId().longValue());
        info.setScopeName(event.getScopeName());
        info.setTimestamp(this.convertDatetoCalendar(event.getTimestamp()));
        info.setType(event.getType().toString());
    }

    private Calendar convertDatetoCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public List<ActivityInfoWithEventsDocument> getActivitiesWithEvents() {
        return this.activitiesWithEventsOrdered;
    }

    public void startup(Properties properties) {
    }

    public void shutdown() {
    }
}

