/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Element;
import org.wso2.carbon.bpel.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.ode.integration.axis2.Axis2UriResolver;
import org.wso2.carbon.bpel.ode.integration.axis2.Axis2WSDLLocator;
import org.wso2.carbon.bpel.ode.integration.axis2.receivers.BPELMessageReceiver;

public class AxisServiceUtils {
    private static final Log log = LogFactory.getLog(AxisServiceUtils.class);

    public static AxisService createAxisService(AxisConfiguration axisConfiguration, BPELProcessProxy processProxy) throws AxisFault {
        QName serviceName = processProxy.getServiceName();
        String portName = processProxy.getPort();
        Definition wsdlDefinition = processProxy.getWsdlDefinition();
        ProcessConf processConfiguration = processProxy.getProcessConfiguration();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating AxisService: Service=" + serviceName + " port=" + portName + " WSDL=" + wsdlDefinition.getDocumentBaseURI() + " BPEL=" + processConfiguration.getBpelDocument()));
        }
        WSDL11ToAxisServiceBuilder serviceBuilder = AxisServiceUtils.createAxisServiceBuilder(processProxy);
        AxisService axisService = AxisServiceUtils.populateAxisService(processProxy, axisConfiguration, serviceBuilder);
        Iterator operations = axisService.getOperations();
        BPELMessageReceiver messageRec = new BPELMessageReceiver();
        messageRec.setProcessProxy(processProxy);
        while (operations.hasNext()) {
            AxisOperation operation = (AxisOperation)operations.next();
            operation.setMessageReceiver((MessageReceiver)messageRec);
        }
        return axisService;
    }

    private static AxisService populateAxisService(BPELProcessProxy processProxy, AxisConfiguration axisConfiguration, WSDL11ToAxisServiceBuilder serviceBuilder) throws AxisFault {
        ProcessConf pConf = processProxy.getProcessConfiguration();
        AxisService axisService = serviceBuilder.populateService();
        axisService.setParent((AxisDescription)axisConfiguration);
        axisService.setWsdlFound(true);
        axisService.setCustomWsdl(true);
        axisService.setClassLoader(axisConfiguration.getServiceClassLoader());
        URL wsdlUrl = null;
        for (File file : pConf.getFiles()) {
            if (file.getAbsolutePath().indexOf(processProxy.getWsdlDefinition().getDocumentBaseURI()) <= 0) continue;
            try {
                wsdlUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                String errorMessage = "Cannot convert File URI to URL.";
                AxisServiceUtils.handleException(pConf.getProcessId(), errorMessage, e);
            }
        }
        if (wsdlUrl != null) {
            axisService.setFileName(wsdlUrl);
        }
        Utils.setEndpointsToAllUsedBindings((AxisService)axisService);
        axisService.addParameter("serviceType", (Object)"bpel");
        axisService.addParameter("processId", (Object)pConf.getProcessId());
        axisService.addParameter(new Parameter("preserveServiceHistory", (Object)"true"));
        axisService.addParameter(new Parameter("messageReceiver.invokeOnSeparateThread", (Object)"true"));
        return axisService;
    }

    private static WSDL11ToAxisServiceBuilder createAxisServiceBuilder(BPELProcessProxy processProxy) throws AxisFault {
        String errMsg;
        Definition wsdlDef = processProxy.getWsdlDefinition();
        QName serviceName = processProxy.getServiceName();
        String portName = processProxy.getPort();
        ProcessConf pConf = processProxy.getProcessConfiguration();
        QName pid = pConf.getProcessId();
        InputStream wsdlInStream = null;
        URI wsdlBaseURI = pConf.getBaseURI().resolve(wsdlDef.getDocumentBaseURI());
        try {
            wsdlInStream = wsdlBaseURI.toURL().openStream();
        }
        catch (MalformedURLException e) {
            errMsg = "Malformed WSDL base URI.";
            AxisServiceUtils.handleException(pid, errMsg, e);
        }
        catch (IOException e) {
            errMsg = "Error opening stream.";
            AxisServiceUtils.handleException(pid, errMsg, e);
        }
        WSDL11ToAxisPatchedBuilder serviceBuilder = new WSDL11ToAxisPatchedBuilder(wsdlInStream, serviceName, portName);
        serviceBuilder.setBaseUri(wsdlBaseURI.toString());
        serviceBuilder.setCustomResolver(new Axis2UriResolver());
        try {
            serviceBuilder.setCustomWSDLResolver(new Axis2WSDLLocator(wsdlBaseURI));
        }
        catch (URISyntaxException e) {
            String errorMessage = "URI syntax invalid.";
            AxisServiceUtils.handleException(pid, errorMessage, e);
        }
        serviceBuilder.setServerSide(true);
        return serviceBuilder;
    }

    private static void handleException(QName pid, String errorMessage, Exception e) throws AxisFault {
        errorMessage = "Error creating axis service for process " + pid + ".Cause: " + errorMessage;
        log.error((Object)errorMessage, (Throwable)e);
        throw new AxisFault(errorMessage, (Throwable)e);
    }

    public static void engageModules(AxisDescription description, String ... modules) throws AxisFault {
        for (String m : modules) {
            if (description.getAxisConfiguration().getModule(m) != null) {
                if (description.getAxisConfiguration().isEngaged(m) || description.isEngaged(m)) continue;
                description.engageModule(description.getAxisConfiguration().getModule(m));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Module " + m + " is not available."));
        }
    }

    public static class WSDL11ToAxisPatchedBuilder
    extends WSDL11ToAxisServiceBuilder {
        public WSDL11ToAxisPatchedBuilder(InputStream in, QName serviceName, String portName) {
            super(in, serviceName, portName);
        }

        public WSDL11ToAxisPatchedBuilder(Definition def, QName serviceName, String portName) {
            super(def, serviceName, portName);
        }

        public WSDL11ToAxisPatchedBuilder(Definition def, QName serviceName, String portName, boolean isAllPorts) {
            super(def, serviceName, portName, isAllPorts);
        }

        public WSDL11ToAxisPatchedBuilder(InputStream in, AxisService service) {
            super(in, service);
        }

        public WSDL11ToAxisPatchedBuilder(InputStream in) {
            super(in);
        }

        protected XmlSchema getXMLSchema(Element element, String baseUri) {
            XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
            if (baseUri != null) {
                schemaCollection.setBaseUri(baseUri);
            }
            return schemaCollection.read(element, baseUri);
        }
    }
}

