/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.utils;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.MessageContextBuilder;
import org.wso2.carbon.bpel.ode.integration.BPELMessageContext;
import org.wso2.carbon.bpel.ode.integration.BPELProcessProxy;
import org.wso2.carbon.bpel.ode.integration.PartnerService;
import org.wso2.carbon.bpel.ode.integration.axis2.WSDLAwareMessage;
import org.wso2.carbon.bpel.ode.integration.axis2.WSDLAwareSOAPProcessor;

public final class BPELMessageContextFactory {
    private BPELMessageContextFactory() {
    }

    public static BPELMessageContext createBPELMessageContext(MessageContext inMessageContext, BPELProcessProxy processProxy, SOAPFactory soapFactory) throws AxisFault {
        BPELMessageContext bpelMessageContext = new BPELMessageContext(processProxy.getWsdlDefinition());
        bpelMessageContext.setInMessageContext(inMessageContext);
        bpelMessageContext.setSoapFactoryForCurrentMessageFlow(soapFactory);
        if (BPELMessageContextFactory.hasResponse(inMessageContext.getAxisOperation())) {
            BPELMessageContextFactory.setOutMessageContextToBPELMessageContext(bpelMessageContext);
        }
        BPELMessageContextFactory.fillBindingAndRelatedInformation(bpelMessageContext);
        bpelMessageContext.setRequestMessage(BPELMessageContextFactory.extractRequestMessageFromInMessageContext(inMessageContext));
        return bpelMessageContext;
    }

    public static BPELMessageContext createBPELMessageContext(MessageContext inMessageContext, PartnerService partnerService) {
        BPELMessageContext bpelMessageContext = new BPELMessageContext(partnerService.getWsdlDefinition());
        bpelMessageContext.setInMessageContext(inMessageContext);
        bpelMessageContext.setWsdlBindingForCurrentMessageFlow(partnerService.getBinding());
        BPELMessageContextFactory.setSOAPFactoryAndBindingStyle(bpelMessageContext);
        return bpelMessageContext;
    }

    private static void setOutMessageContextToBPELMessageContext(BPELMessageContext bpelMessageContext) throws AxisFault {
        MessageContext outMessageContext = MessageContextBuilder.createOutMessageContext((MessageContext)bpelMessageContext.getInMessageContext());
        outMessageContext.getOperationContext().addMessageContext(outMessageContext);
        bpelMessageContext.setOutMessageContext(outMessageContext);
    }

    private static void fillBindingAndRelatedInformation(BPELMessageContext bpelMessageContext) throws AxisFault {
        Binding wsdlBinding = BPELMessageContextFactory.getWSDLBindingOfCurrentMessageFlow(bpelMessageContext.getInMessageContext().getAxisService(), bpelMessageContext.getInMessageContext());
        if (wsdlBinding == null) {
            throw new NullPointerException("WSDL Binding null for incoming message.");
        }
        bpelMessageContext.setWsdlBindingForCurrentMessageFlow(wsdlBinding);
        BPELMessageContextFactory.setSOAPFactoryAndBindingStyle(bpelMessageContext);
    }

    private static void setSOAPFactoryAndBindingStyle(BPELMessageContext bpelMessageContext) {
        ExtensibilityElement bindingType = WSDLAwareSOAPProcessor.getBindingExtension(bpelMessageContext.getWsdlBindingForCurrentMessageFlow());
        if (bpelMessageContext.getSoapFactoryForCurrentMessageFlow() == null) {
            if (bindingType instanceof SOAPBinding) {
                bpelMessageContext.setSoapFactoryForCurrentMessageFlow(OMAbstractFactory.getSOAP11Factory());
            } else {
                bpelMessageContext.setSoapFactoryForCurrentMessageFlow(OMAbstractFactory.getSOAP12Factory());
            }
        }
        BPELMessageContextFactory.deriveAndSetBindingStyle(bindingType, bpelMessageContext);
    }

    private static void deriveAndSetBindingStyle(ExtensibilityElement bindingType, BPELMessageContext bpelMessageContext) {
        boolean isRPC = false;
        if (bindingType instanceof SOAPBinding) {
            isRPC = ((SOAPBinding)bindingType).getStyle() != null && ((SOAPBinding)bindingType).getStyle().toLowerCase().equals("rpc");
        } else if (bindingType instanceof SOAP12Binding) {
            isRPC = ((SOAP12Binding)bindingType).getStyle() != null && ((SOAP12Binding)bindingType).getStyle().toLowerCase().equals("rpc");
        }
        bpelMessageContext.setRPCStyleOperation(isRPC);
    }

    private static Binding getWSDLBindingOfCurrentMessageFlow(AxisService bpelProcessService, MessageContext inMessageContext) {
        Definition wsdl = BPELMessageContextFactory.getWSDLDefinitionFromAxisService(bpelProcessService);
        return BPELMessageContextFactory.extractBindingInformation(bpelProcessService, wsdl, inMessageContext);
    }

    private static Definition getWSDLDefinitionFromAxisService(AxisService service) {
        Definition wsdlDefinition = (Definition)service.getParameter("wsdl4jDefinition").getValue();
        QName serviceName = new QName(service.getTargetNamespace(), service.getName());
        if (wsdlDefinition == null) {
            throw new NullPointerException("No WSDL Definition was found for service " + serviceName.getLocalPart() + ".");
        }
        BPELMessageContextFactory.checkWhetherServiceDefinitionIsAvailable(wsdlDefinition, serviceName);
        return wsdlDefinition;
    }

    private static void checkWhetherServiceDefinitionIsAvailable(Definition wsdlOfTheService, QName serviceName) {
        if (wsdlOfTheService.getService(serviceName) == null) {
            throw new NullPointerException("WSDL Service Definition not found for service " + serviceName.getLocalPart());
        }
    }

    private static Binding extractBindingInformation(AxisService service, Definition wsdlOfService, MessageContext inMessageContext) {
        AxisEndpoint currentEndpoint = (AxisEndpoint)inMessageContext.getProperty("endpoint");
        if (currentEndpoint == null) {
            String defaultEndpointName = service.getEndpointName();
            currentEndpoint = (AxisEndpoint)service.getEndpoints().get(defaultEndpointName);
            if (currentEndpoint == null) {
                throw new NullPointerException("AxisEndpoint cannot be null.");
            }
        }
        AxisBinding currentAxisBinding = currentEndpoint.getBinding();
        QName bindingQName = currentAxisBinding.getName();
        return wsdlOfService.getBinding(bindingQName);
    }

    private static WSDLAwareMessage extractRequestMessageFromInMessageContext(MessageContext inMessageContext) throws AxisFault {
        WSDLAwareSOAPProcessor soapProcessor = new WSDLAwareSOAPProcessor(inMessageContext);
        return soapProcessor.parseRequest();
    }

    public static boolean hasResponse(AxisOperation op) {
        switch (op.getAxisSpecificMEPConstant()) {
            case 12: {
                return true;
            }
            case 14: {
                return true;
            }
            case 17: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }
}

