/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.ode.integration.utils.FileLoadingUtilException;

public class FileLoadingUtil {
    private static Log log = LogFactory.getLog(FileLoadingUtil.class);
    private static final float JAVA_1_4 = 1.4f;
    static final String PROTOCOL_FILE = "file";
    private String basePath;

    public FileLoadingUtil(String basePath) {
        this.basePath = basePath;
    }

    public InputStream load(String fileName) throws FileLoadingUtilException, IllegalArgumentException {
        try {
            URL url = FileLoadingUtil.locate(this.basePath, fileName);
            if (url == null) {
                throw new IllegalArgumentException("Cannot locate configuration source " + fileName);
            }
            return this.load(url);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Unable to load the configuration file " + fileName;
            log.error((Object)errMsg, (Throwable)e);
            throw new FileLoadingUtilException(errMsg, e);
        }
    }

    public InputStream load(URL url) throws FileLoadingUtilException {
        InputStream in = null;
        try {
            in = FileLoadingUtil.getInputStream(url);
            return in;
        }
        catch (FileLoadingUtilException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileLoadingUtilException("Unable to load the configuration from the URL " + url, e);
        }
    }

    static InputStream getInputStream(URL url) throws FileLoadingUtilException {
        File file = FileLoadingUtil.fileFromURL(url);
        if (file != null && file.isDirectory()) {
            throw new FileLoadingUtilException("Cannot load a configuration from a directory");
        }
        try {
            return url.openStream();
        }
        catch (Exception e) {
            throw new FileLoadingUtilException("Unable to load the configuration from the URL " + url, e);
        }
    }

    static File fileFromURL(URL url) {
        if (PROTOCOL_FILE.equals(url.getProtocol())) {
            return new File(URLDecoder.decode(url.getPath()));
        }
        return null;
    }

    static URL locate(String basePath, String fileName) {
        File file;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Locate file: " + fileName + " using base path: " + basePath));
        }
        if (fileName == null) {
            return null;
        }
        URL url = FileLoadingUtil.locateFromURL(basePath, fileName);
        if (url == null && (file = new File(fileName)).isAbsolute() && file.exists()) {
            try {
                url = FileLoadingUtil.toURL(file);
                log.debug((Object)("Loading configuration from the absolute path " + fileName));
            }
            catch (MalformedURLException e) {
                log.warn((Object)"Could not obtain URL from file", (Throwable)e);
            }
        }
        if (url == null) {
            try {
                file = FileLoadingUtil.constructFile(basePath, fileName);
                if (file != null && file.exists()) {
                    url = FileLoadingUtil.toURL(file);
                }
                if (url != null) {
                    log.debug((Object)("Loading configuration from the path " + file));
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)"Could not obtain URL from file", (Throwable)e);
            }
        }
        if (url == null) {
            try {
                file = FileLoadingUtil.constructFile(System.getProperty("user.home"), fileName);
                if (file != null && file.exists()) {
                    url = FileLoadingUtil.toURL(file);
                }
                if (url != null) {
                    log.debug((Object)("Loading configuration from the home path " + file));
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)"Could not obtain URL from file", (Throwable)e);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL locateFromURL(String basePath, String fileName) {
        try {
            if (basePath == null) {
                return new URL(fileName);
            }
            URL baseURL = new URL(basePath);
            URL url = new URL(baseURL, fileName);
            InputStream in = null;
            try {
                in = url.openStream();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return url;
        }
        catch (IOException e) {
            return null;
        }
    }

    static URL toURL(File file) throws MalformedURLException {
        if (new SystemUtils().isJavaVersionAtLeast(1.4f)) {
            try {
                Method toURI = file.getClass().getMethod("toURI", null);
                Object uri = toURI.invoke((Object)file, (Object[])null);
                Method toURL = uri.getClass().getMethod("toURL", null);
                return (URL)toURL.invoke(uri, (Object[])null);
            }
            catch (Exception e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        return file.toURL();
    }

    static File constructFile(String basePath, String fileName) {
        File file;
        File absolute = null;
        if (fileName != null) {
            absolute = new File(fileName);
        }
        if (StringUtils.isEmpty((String)basePath) || absolute != null && absolute.isAbsolute()) {
            file = new File(fileName);
        } else {
            StringBuffer fName = new StringBuffer();
            fName.append(basePath);
            if (!basePath.endsWith(File.separator)) {
                fName.append(File.separator);
            }
            if (fileName.startsWith("." + File.separator)) {
                fName.append(fileName.substring(2));
            } else {
                fName.append(fileName);
            }
            file = new File(fName.toString());
        }
        return file;
    }
}

