/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ode.integration.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.ode.integration.BPELFault;
import org.wso2.carbon.bpel.ode.integration.BPELMessageContext;

public class SOAPUtils {
    private SOAPUtils() {
    }

    public static void createSOAPResponse(BPELMessageContext bpelMessageContext, MyRoleMessageExchange odeMessageExchange) throws AxisFault {
        SOAPUtils.checkForNullValuesInResponse(bpelMessageContext, (MessageExchange)odeMessageExchange);
        BindingOperation bindingOp = SOAPUtils.getBindingOperation(bpelMessageContext, odeMessageExchange.getOperationName());
        BindingOutput bindingOutput = SOAPUtils.getBindingOutPut(bindingOp);
        SOAPEnvelope soapEnv = bpelMessageContext.getOutMessageContext().getEnvelope();
        if (soapEnv == null) {
            soapEnv = bpelMessageContext.getSoapFactoryForCurrentMessageFlow().getDefaultEnvelope();
            bpelMessageContext.getOutMessageContext().setEnvelope(soapEnv);
        }
        SOAPUtils.populateSOAPHeaders(odeMessageExchange.getResponse(), soapEnv, bpelMessageContext.getSoapFactoryForCurrentMessageFlow(), SOAPUtils.getSOAPHeaders((ElementExtensible)bindingOutput), odeMessageExchange.getOperation());
        SOAPUtils.populateSOAPBody(soapEnv, SOAPUtils.getSOAPBody((ElementExtensible)bindingOutput), bpelMessageContext.getSoapFactoryForCurrentMessageFlow(), odeMessageExchange.getOperation(), odeMessageExchange.getOperation().getOutput().getMessage(), odeMessageExchange.getResponse(), bpelMessageContext.isRPCStyleOperation(), false);
    }

    public static void createSOAPRequest(BPELMessageContext bpelMessageContext, PartnerRoleMessageExchange odePartnerMessageExchange) throws AxisFault {
        SOAPUtils.checkForNullValuesInRequest(bpelMessageContext, (MessageExchange)odePartnerMessageExchange);
        BindingOperation bindingOp = SOAPUtils.getBindingOperation(bpelMessageContext, odePartnerMessageExchange.getOperationName());
        BindingInput bindingInput = SOAPUtils.getBindingInput(bindingOp);
        SOAPEnvelope soapEnvelope = bpelMessageContext.getInMessageContext().getEnvelope();
        if (soapEnvelope == null) {
            soapEnvelope = bpelMessageContext.getSoapFactoryForCurrentMessageFlow().getDefaultEnvelope();
            bpelMessageContext.getInMessageContext().setEnvelope(soapEnvelope);
        }
        SOAPUtils.populateSOAPHeaders(odePartnerMessageExchange.getRequest(), soapEnvelope, bpelMessageContext.getSoapFactoryForCurrentMessageFlow(), SOAPUtils.getSOAPHeaders((ElementExtensible)bindingInput), odePartnerMessageExchange.getOperation());
        SOAPUtils.populateSOAPBody(soapEnvelope, SOAPUtils.getSOAPBody((ElementExtensible)bindingInput), bpelMessageContext.getSoapFactoryForCurrentMessageFlow(), odePartnerMessageExchange.getOperation(), odePartnerMessageExchange.getOperation().getInput().getMessage(), odePartnerMessageExchange.getRequest(), bpelMessageContext.isRPCStyleOperation(), true);
    }

    private static BindingInput getBindingInput(BindingOperation bindingOp) {
        BindingInput bindingInput = bindingOp.getBindingInput();
        if (bindingInput == null) {
            throw new NullPointerException("BindingInput is null.");
        }
        return bindingInput;
    }

    private static void populateSOAPBody(SOAPEnvelope soapEnvelope, SOAPBody soapBodyDefinition, SOAPFactory soapFactory, Operation operation, Message messageDefinition, org.apache.ode.bpel.iapi.Message messageFromODE, boolean isRPC, boolean isRequest) throws BPELFault {
        if (soapBodyDefinition != null) {
            org.apache.axiom.soap.SOAPBody partHolder;
            org.apache.axiom.soap.SOAPBody soapBody = soapEnvelope.getBody() != null ? soapEnvelope.getBody() : soapFactory.createSOAPBody(soapEnvelope);
            if (isRPC) {
                String rpcWrapperElementName = isRequest ? operation.getName() : operation.getName() + "Response";
                partHolder = SOAPUtils.createRPCWrapperElement(soapBody, soapFactory, new QName(soapBodyDefinition.getNamespaceURI(), rpcWrapperElementName));
            } else {
                partHolder = soapBody;
            }
            List parts = messageDefinition.getOrderedParts(soapBodyDefinition.getParts());
            for (Part p : parts) {
                Element partContent = DOMUtils.findChildByName((Element)messageFromODE.getMessage(), (QName)new QName(null, p.getName()));
                if (partContent == null) {
                    throw new BPELFault("Missing required part in ODE Message: " + new QName(null, p.getName()));
                }
                OMElement omPartContent = OMUtils.toOM((Element)partContent, (OMFactory)soapFactory);
                if (isRPC) {
                    partHolder.addChild((OMNode)omPartContent);
                    continue;
                }
                Iterator i = omPartContent.getChildren();
                while (i.hasNext()) {
                    partHolder.addChild((OMNode)i.next());
                }
            }
        }
    }

    private static OMElement createRPCWrapperElement(org.apache.axiom.soap.SOAPBody soapBody, SOAPFactory soapFactory, QName wrapperElementName) {
        return soapFactory.createOMElement(wrapperElementName, (OMContainer)soapBody);
    }

    private static void generateSOAPBody(BPELMessageContext bpelMessageContext, MessageExchange odeMessageexchange, BindingOutput bindingOutput) throws BPELFault {
        SOAPBody soapBody = SOAPUtils.getSOAPBody((ElementExtensible)bindingOutput);
        if (soapBody != null) {
            SOAPEnvelope soapEnv = bpelMessageContext.getOutMessageContext().getEnvelope();
            SOAPFactory soapFactory = bpelMessageContext.getSoapFactoryForCurrentMessageFlow();
            org.apache.axiom.soap.SOAPBody axiomSOAPBody = soapEnv.getBody() == null ? soapFactory.createSOAPBody(soapEnv) : soapEnv.getBody();
            String rpcWrapper = odeMessageexchange.getOperationName();
            org.apache.axiom.soap.SOAPBody partHolder = bpelMessageContext.isRPCStyleOperation() ? soapFactory.createOMElement(new QName(soapBody.getNamespaceURI(), rpcWrapper, "odens"), (OMContainer)axiomSOAPBody) : axiomSOAPBody;
            List parts = odeMessageexchange.getOperation().getOutput().getMessage().getOrderedParts(soapBody.getParts());
            for (Part part : parts) {
                Element srcPartEl = DOMUtils.findChildByName((Element)odeMessageexchange.getResponse().getMessage(), (QName)new QName(null, part.getName()));
                if (srcPartEl == null) {
                    throw new BPELFault("Missing required part in ODE Message: " + new QName(null, part.getName()));
                }
                OMElement omPart = OMUtils.toOM((Element)srcPartEl, (OMFactory)soapFactory);
                if (bpelMessageContext.isRPCStyleOperation()) {
                    partHolder.addChild((OMNode)omPart);
                    continue;
                }
                Iterator i = omPart.getChildren();
                while (i.hasNext()) {
                    partHolder.addChild((OMNode)i.next());
                }
            }
        }
    }

    private static void populateSOAPHeaders(org.apache.ode.bpel.iapi.Message messageFromOde, SOAPEnvelope soapEnvelope, SOAPFactory soapFactory, List<javax.wsdl.extensions.soap.SOAPHeader> soapHaderDefinitions, Operation operation) throws BPELFault {
        if (messageFromOde.getHeaderParts().size() > 0 || soapHaderDefinitions.size() > 0) {
            for (javax.wsdl.extensions.soap.SOAPHeader soapHeaderDefinition : soapHaderDefinitions) {
                SOAPUtils.handleSOAPHeaderElementsInBindingOperation(soapEnvelope, soapFactory, messageFromOde, operation, soapHeaderDefinition);
            }
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            if (soapHeader == null) {
                soapHeader = soapFactory.createSOAPHeader(soapEnvelope);
            }
            for (Node headerNode : messageFromOde.getHeaderParts().values()) {
                if (headerNode.getNodeType() == 1) {
                    SOAPUtils.addSOAPHeaderBock(soapHeader, headerNode, soapFactory);
                    continue;
                }
                throw new BPELFault("SOAP Header Must be an Element");
            }
        }
    }

    private static void addSOAPHeaderBock(SOAPHeader soapHeader, Node headerNode, SOAPFactory soapFactory) {
        if (soapHeader.getFirstChildWithName(new QName(headerNode.getNamespaceURI(), headerNode.getLocalName())) == null) {
            OMElement omHeaderNode = OMUtils.toOM((Element)((Element)headerNode), (OMFactory)soapFactory);
            SOAPHeaderBlock hb = soapHeader.addHeaderBlock(omHeaderNode.getLocalName(), omHeaderNode.getNamespace());
            Iterator iter = omHeaderNode.getChildren();
            while (iter.hasNext()) {
                OMNode omNode = (OMNode)iter.next();
                hb.addChild(omNode);
            }
            Iterator iter2 = omHeaderNode.getAllAttributes();
            while (iter2.hasNext()) {
                OMAttribute omAttribute = (OMAttribute)iter2.next();
                hb.addAttribute(omAttribute);
            }
        }
    }

    public static BindingOperation getBindingOperation(BPELMessageContext bpelMessageContext, String operationName) {
        BindingOperation bOp = bpelMessageContext.getWsdlBindingForCurrentMessageFlow().getBindingOperation(operationName, null, null);
        if (bOp == null) {
            throw new NullPointerException("BindingOperation not found for operation " + operationName + ".");
        }
        return bOp;
    }

    private static BindingOutput getBindingOutPut(BindingOperation bOp) {
        BindingOutput bOutput = bOp.getBindingOutput();
        if (bOutput == null) {
            throw new NullPointerException("BindingOutput cannot be null for operation " + bOp.getName() + ".");
        }
        return bOutput;
    }

    private static void checkForNullValuesInResponse(BPELMessageContext bpelMessageContext, MessageExchange odeMessageExchange) {
        if (odeMessageExchange.getOperation() == null) {
            throw new NullPointerException("Null operation");
        }
        if (odeMessageExchange.getResponse() == null) {
            throw new NullPointerException("Null message.");
        }
        if (bpelMessageContext.getOutMessageContext() == null) {
            throw new NullPointerException("Null msgCtx");
        }
    }

    public static void checkForNullValuesInRequest(BPELMessageContext bpelMessageContext, MessageExchange odeMessageExchange) {
        if (odeMessageExchange.getOperation() == null) {
            throw new NullPointerException("Null operation");
        }
        if (odeMessageExchange.getRequest() == null) {
            throw new NullPointerException("Null message.");
        }
        if (bpelMessageContext.getInMessageContext() == null) {
            throw new NullPointerException("Null msgCtx");
        }
    }

    private static void handleSOAPHeaderElementsInBindingOperation(SOAPEnvelope soapEnvelope, SOAPFactory soapFactory, org.apache.ode.bpel.iapi.Message messageFromOde, Operation wsdlOperation, javax.wsdl.extensions.soap.SOAPHeader soapHeaderElementDefinition) throws BPELFault {
        boolean isHeaderElementAPartOfPayload;
        Map headerParts = messageFromOde.getHeaderParts();
        Message responseMessageDefinition = wsdlOperation.getOutput().getMessage();
        boolean bl = isHeaderElementAPartOfPayload = soapHeaderElementDefinition.getMessage() == null || soapHeaderElementDefinition.getMessage().equals(responseMessageDefinition.getQName());
        if (soapHeaderElementDefinition.getPart() == null) {
            return;
        }
        if (isHeaderElementAPartOfPayload && responseMessageDefinition.getPart(soapHeaderElementDefinition.getPart()) == null) {
            throw new BPELFault("SOAP Header Element Definition refer unknown part.");
        }
        Element partElement = null;
        if (headerParts.size() > 0 && isHeaderElementAPartOfPayload) {
            try {
                partElement = (Element)headerParts.get(soapHeaderElementDefinition.getPart());
            }
            catch (ClassCastException e) {
                throw new BPELFault("SOAP Header must be a DOM Element.");
            }
        }
        if (partElement == null && isHeaderElementAPartOfPayload) {
            if (messageFromOde.getPart(soapHeaderElementDefinition.getPart()) != null) {
                partElement = messageFromOde.getPart(soapHeaderElementDefinition.getPart());
            } else {
                throw new BPELFault("Missing Required part in response message.");
            }
        }
        if (partElement == null) {
            return;
        }
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        if (soapHeader == null) {
            soapHeader = soapFactory.createSOAPHeader(soapEnvelope);
        }
        OMElement omPart = OMUtils.toOM((Element)partElement, (OMFactory)soapFactory);
        Iterator i = omPart.getChildren();
        while (i.hasNext()) {
            soapHeader.addChild((OMNode)i.next());
        }
    }

    public static SOAPFault createSoapFault(BPELMessageContext bpelMessageContext, MessageExchange odeMessageContext) throws AxisFault {
        SOAPFactory soapFactory = bpelMessageContext.getSoapFactoryForCurrentMessageFlow();
        OMElement detail = SOAPUtils.buildSoapDetail(bpelMessageContext, odeMessageContext);
        SOAPFault fault = soapFactory.createSOAPFault();
        SOAPFaultCode code = soapFactory.createSOAPFaultCode(fault);
        code.setText(new QName(Namespaces.SOAP_ENV_NS, "Server"));
        SOAPFaultReason reason = soapFactory.createSOAPFaultReason(fault);
        reason.setText(odeMessageContext.getFault());
        SOAPFaultDetail soapDetail = soapFactory.createSOAPFaultDetail(fault);
        if (detail != null) {
            soapDetail.addDetailEntry(detail);
        }
        return fault;
    }

    private static OMElement buildSoapDetail(BPELMessageContext bpelMessageContext, MessageExchange odeMessageContext) throws AxisFault {
        Element message = odeMessageContext.getResponse().getMessage();
        QName faultName = odeMessageContext.getFault();
        Operation operation = odeMessageContext.getOperation();
        SOAPFactory soapFactory = bpelMessageContext.getSoapFactoryForCurrentMessageFlow();
        if (faultName.getNamespaceURI() == null) {
            return SOAPUtils.toFaultDetail(message, soapFactory);
        }
        Fault f = operation.getFault(faultName.getLocalPart());
        if (f == null) {
            return SOAPUtils.toFaultDetail(message, soapFactory);
        }
        Part p = (Part)f.getMessage().getParts().values().iterator().next();
        if (p == null) {
            return SOAPUtils.toFaultDetail(message, soapFactory);
        }
        Element partEl = DOMUtils.findChildByName((Element)message, (QName)new QName(null, p.getName()));
        if (partEl == null) {
            return SOAPUtils.toFaultDetail(message, soapFactory);
        }
        Element detail = DOMUtils.findChildByName((Element)partEl, (QName)p.getElementName());
        if (detail == null) {
            return SOAPUtils.toFaultDetail(message, soapFactory);
        }
        return OMUtils.toOM((Element)detail, (OMFactory)soapFactory);
    }

    private static OMElement toFaultDetail(Element message, SOAPFactory soapFactory) {
        if (message == null) {
            return null;
        }
        Element firstPart = DOMUtils.getFirstChildElement((Element)message);
        if (firstPart == null) {
            return null;
        }
        Element detail = DOMUtils.getFirstChildElement((Element)firstPart);
        if (detail == null) {
            return OMUtils.toOM((Element)firstPart, (OMFactory)soapFactory);
        }
        return OMUtils.toOM((Element)detail, (OMFactory)soapFactory);
    }

    public static org.apache.ode.bpel.iapi.Message parseSOAPResponseFromPartner(BPELMessageContext partnerInvocationContext, MessageExchange partnerRoleMessageExchange) throws BPELFault {
        org.apache.ode.bpel.iapi.Message messageToODE = partnerRoleMessageExchange.createMessage(partnerRoleMessageExchange.getOperation().getOutput().getMessage().getQName());
        BindingOperation bindingOp = SOAPUtils.getBindingOperation(partnerInvocationContext, partnerRoleMessageExchange.getOperationName());
        BindingOutput bindingOutPut = SOAPUtils.getBindingOutPut(bindingOp);
        SOAPBody soapBodyDefinition = SOAPUtils.getSOAPBody((ElementExtensible)bindingOutPut);
        SOAPEnvelope responseFromPartnerService = partnerInvocationContext.getInMessageContext().getEnvelope();
        if (soapBodyDefinition != null) {
            if (responseFromPartnerService.getBody() != null) {
                SOAPUtils.extractSOAPBodyParts(partnerRoleMessageExchange, messageToODE, responseFromPartnerService.getBody(), soapBodyDefinition, partnerInvocationContext.isRPCStyleOperation());
            } else {
                throw new BPELFault("SOAP Body cannot be null for WSDL operation which requires SOAP Body.");
            }
        }
        if (SOAPUtils.getSOAPHeaders((ElementExtensible)bindingOutPut) != null && responseFromPartnerService.getHeader() != null) {
            SOAPUtils.extractSoapHeaderParts(messageToODE, partnerInvocationContext.getBpelServiceWSDLDefinition(), responseFromPartnerService.getHeader(), SOAPUtils.getSOAPHeaders((ElementExtensible)bindingOutPut), partnerRoleMessageExchange.getOperation().getOutput().getMessage());
        }
        return messageToODE;
    }

    public static org.apache.ode.bpel.iapi.Message parseResponseFromRESTService(BPELMessageContext partnerInvocationContext, PartnerRoleMessageExchange odePartnerMex) {
        org.apache.ode.bpel.iapi.Message messageToODE = odePartnerMex.createMessage(odePartnerMex.getOperation().getOutput().getMessage().getQName());
        BindingOperation bindingOp = SOAPUtils.getBindingOperation(partnerInvocationContext, odePartnerMex.getOperationName());
        BindingOutput bindingOutPut = SOAPUtils.getBindingOutPut(bindingOp);
        MIMEContent mimeContent = SOAPUtils.getFirstExtensibilityElement((ElementExtensible)bindingOutPut, MIMEContent.class);
        if (mimeContent != null) {
            SOAPEnvelope soapEnv = partnerInvocationContext.getInMessageContext().getEnvelope();
            Iterator childElementsItr = soapEnv.getBody().getChildElements();
            while (childElementsItr.hasNext()) {
                OMNode child = (OMNode)childElementsItr.next();
                if (child.getType() != 1) continue;
                Document doc = DOMUtils.newDocument();
                Element domPart = doc.createElementNS(null, mimeContent.getPart());
                domPart.appendChild(doc.importNode(OMUtils.toDOM((OMElement)((OMElement)child)), true));
                messageToODE.setPart(mimeContent.getPart(), domPart);
                return messageToODE;
            }
        }
        throw new IllegalArgumentException("WSO2 BPS only support HTTP binding with mime output.");
    }

    private static void extractSOAPBodyParts(MessageExchange partnerRoleMessageExchange, org.apache.ode.bpel.iapi.Message messageToODE, org.apache.axiom.soap.SOAPBody omSOAPBody, SOAPBody soapBodyDefinition, boolean isRPC) throws BPELFault {
        List messageBodyParts = partnerRoleMessageExchange.getOperation().getOutput().getMessage().getOrderedParts(soapBodyDefinition.getParts());
        if (isRPC) {
            String rpcWrapperElementName = partnerRoleMessageExchange.getOperationName() + "Response";
            OMElement rpcWrapperElement = omSOAPBody.getFirstChildWithName(new QName(soapBodyDefinition.getNamespaceURI(), rpcWrapperElementName));
            if (rpcWrapperElement == null) {
                throw new BPELFault("Message body doesn't contain expected part wrapper: " + new QName(soapBodyDefinition.getNamespaceURI(), rpcWrapperElementName));
            }
            for (Part partDef : messageBodyParts) {
                OMElement omPartElement = rpcWrapperElement.getFirstChildWithName(new QName(null, partDef.getName()));
                if (omPartElement == null) {
                    throw new BPELFault("SOAP body doesn't contain required part: " + new QName(null, partDef.getName()));
                }
                messageToODE.setPart(omPartElement.getLocalName(), OMUtils.toDOM((OMElement)omPartElement));
            }
        } else {
            Iterator omParts = omSOAPBody.getChildElements();
            for (Part partDef : messageBodyParts) {
                if (!omParts.hasNext()) {
                    throw new BPELFault("SOAP body doesn't contain required part.");
                }
                OMElement omPart = (OMElement)omParts.next();
                if (partDef.getElementName() == null) {
                    throw new BPELFault("Binding defines non element document list parts.");
                }
                if (!omPart.getQName().equals(partDef.getElementName())) {
                    throw new BPELFault("Unexpected element in SOAP body: " + omPart.getQName());
                }
                Document doc = DOMUtils.newDocument();
                Element domPart = doc.createElementNS(null, partDef.getName());
                domPart.appendChild(doc.importNode(OMUtils.toDOM((OMElement)omPart), true));
                messageToODE.setPart(partDef.getName(), domPart);
            }
        }
    }

    private static void extractSoapHeaderParts(org.apache.ode.bpel.iapi.Message message, Definition wsdl, SOAPHeader soapHeader, List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, Message msg) throws BPELFault {
        for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
            SOAPUtils.handleSoapHeaderPartDef(message, wsdl, soapHeader, headerDef, msg);
        }
        Iterator headersIter = soapHeader.getChildElements();
        while (headersIter.hasNext()) {
            OMElement header = (OMElement)headersIter.next();
            String partName = SOAPUtils.findHeaderPartName(headerDefs, wsdl, header.getQName());
            message.setHeaderPart(partName, OMUtils.toDOM((OMElement)header));
        }
    }

    private static void handleSoapHeaderPartDef(org.apache.ode.bpel.iapi.Message odeMessage, Definition wsdl, SOAPHeader header, javax.wsdl.extensions.soap.SOAPHeader headerdef, Message msgType) throws BPELFault {
        boolean requiredHeader;
        boolean payloadMessageHeader = headerdef.getMessage() == null || headerdef.getMessage().equals(msgType.getQName());
        boolean bl = requiredHeader = payloadMessageHeader || headerdef.getRequired() != null && headerdef.getRequired() != false;
        if (requiredHeader && header == null) {
            throw new BPELFault("SOAP Header missing required element.");
        }
        if (header == null) {
            return;
        }
        Message hdrMsg = wsdl.getMessage(headerdef.getMessage());
        if (hdrMsg == null) {
            return;
        }
        Part p = hdrMsg.getPart(headerdef.getPart());
        if (p == null || p.getElementName() == null) {
            return;
        }
        OMElement headerEl = header.getFirstChildWithName(p.getElementName());
        if (requiredHeader && headerEl == null) {
            throw new BPELFault("SOAP Header missing required element: " + p.getElementName());
        }
        if (headerEl == null) {
            return;
        }
        odeMessage.setHeaderPart(p.getName(), OMUtils.toDOM((OMElement)headerEl));
    }

    private static String findHeaderPartName(List<javax.wsdl.extensions.soap.SOAPHeader> headerDefs, Definition wsdl, QName elmtName) {
        for (javax.wsdl.extensions.soap.SOAPHeader headerDef : headerDefs) {
            Message hdrMsg = wsdl.getMessage(headerDef.getMessage());
            for (Object o : hdrMsg.getParts().values()) {
                Part p = (Part)o;
                if (!p.getElementName().equals(elmtName)) continue;
                return p.getName();
            }
        }
        return elmtName.getLocalPart();
    }

    public static Fault parseSoapFault(Element odeMsgEl, SOAPEnvelope envelope, Operation operation) throws AxisFault {
        SOAPFault flt = envelope.getBody().getFault();
        SOAPFaultDetail detail = flt.getDetail();
        Fault fdef = SOAPUtils.inferFault(operation, flt);
        if (fdef == null) {
            return null;
        }
        Part pdef = (Part)fdef.getMessage().getParts().values().iterator().next();
        Element partel = odeMsgEl.getOwnerDocument().createElementNS(null, pdef.getName());
        odeMsgEl.appendChild(partel);
        if (detail.getFirstChildWithName(pdef.getElementName()) != null) {
            partel.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)detail.getFirstChildWithName(pdef.getElementName())), true));
        } else {
            partel.appendChild(odeMsgEl.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)detail), true));
        }
        return fdef;
    }

    private static Fault inferFault(Operation operation, SOAPFault flt) {
        if (flt.getDetail() == null) {
            return null;
        }
        if (flt.getDetail().getFirstElement() == null) {
            return null;
        }
        QName elName = flt.getDetail().getFirstElement().getQName();
        return WsdlUtils.inferFault((Operation)operation, (QName)elName);
    }

    public static SOAPBody getSOAPBody(ElementExtensible ee) {
        return SOAPUtils.getFirstExtensibilityElement(ee, SOAPBody.class);
    }

    public static <T> T getFirstExtensibilityElement(ElementExtensible parent, Class<T> cls) {
        Collection ee = CollectionsX.filter((Collection)parent.getExtensibilityElements(), cls);
        return ee.isEmpty() ? null : (T)ee.iterator().next();
    }

    public static List<javax.wsdl.extensions.soap.SOAPHeader> getSOAPHeaders(ElementExtensible eee) {
        return (List)CollectionsX.filter(new ArrayList(), (Collection)eee.getExtensibilityElements(), javax.wsdl.extensions.soap.SOAPHeader.class);
    }
}

