/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bpel.BPELConstants;
import org.wso2.carbon.bpel.services.types.UploadedFileItem;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;

public class BPELUploader
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(BPELUploader.class);

    public void uploadService(UploadedFileItem[] fileItems) throws AxisFault {
        try {
            File bpelDir;
            ConfigurationContext configurationContext = this.getConfigContext();
            String repo = configurationContext.getAxisConfiguration().getRepository().getPath();
            if (CarbonUtils.isURL((String)repo)) {
                throw new AxisFault("URL Repositories are not supported: " + repo);
            }
            String bpelDirectory = repo + File.separator + "bpel";
            String bpelTemp = CarbonUtils.getCarbonHome() + BPELConstants.BPEL_PACKAGE_TEMP_DIRECTORY;
            File bpelTempDir = new File(bpelTemp);
            if (!bpelTempDir.exists()) {
                bpelTempDir.mkdirs();
            }
            if (!(bpelDir = new File(bpelDirectory)).exists()) {
                bpelDir.mkdirs();
            }
            for (UploadedFileItem uploadedFile : fileItems) {
                String fileName = uploadedFile.getFileName();
                if (fileName == null || fileName.equals("")) {
                    throw new AxisFault("Invalid file name. File name is not available");
                }
                if (!uploadedFile.getFileType().equals("zip")) {
                    throw new AxisFault("Invalid file type : " + uploadedFile.getFileType() + " ." + "zip" + " file type is expected");
                }
                this.writeResource(uploadedFile.getDataHandler(), bpelTemp, fileName, bpelDir);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while uploading service artifacts", (Throwable)e);
        }
    }

    private void writeResource(DataHandler dataHandler, String destPath, String fileName, File bpelDest) throws IOException {
        File destFile = new File(destPath, fileName);
        FileOutputStream fos = null;
        AbstractInterruptibleChannel out = null;
        AbstractInterruptibleChannel in = null;
        try {
            fos = new FileOutputStream(destFile);
            dataHandler.writeTo((OutputStream)fos);
            out = new FileOutputStream(bpelDest + File.separator + fileName).getChannel();
            in = new FileInputStream(destFile).getChannel();
            ((FileChannel)out).write(((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)in).size()));
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Cannot find the file", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)"IO error.");
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Can't close file streams.", (Throwable)e);
            }
        }
        boolean isDeleted = destFile.delete();
        if (!isDeleted) {
            log.warn((Object)("temp file: " + destFile.getAbsolutePath() + " deletion failed, scheduled deletion on server exit."));
            destFile.deleteOnExit();
        }
    }
}

