/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.samples.lcm.notifications.handlers;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.samples.lcm.notifications.handlers.utils.events.ApprovalNeededEvent;
import org.wso2.carbon.governance.samples.lcm.notifications.internal.Utils;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;

public class DLCMEventingHandler
extends Handler {
    private static final Log log = LogFactory.getLog(DLCMEventingHandler.class);

    public void init(String defaultNotificationEndpoint) {
        Utils.setDefaultNotificationServiceURL(defaultNotificationEndpoint);
    }

    public DLCMEventingHandler() {
        try {
            Utils.getRegistryNotificationService().registerEventType("custom:Approval Needed", "ApprovalNeeded", "ApprovalNeeded");
        }
        catch (Exception e) {
            this.handleException("Unable to register Event Types", e);
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        String[] stringArray;
        String path = requestContext.getResourcePath().getPath();
        Resource resource = requestContext.getResource();
        if (resource == null || resource.getProperties() == null) {
            return;
        }
        boolean allItemsAreChecked = true;
        String currentState = null;
        String lastState = resource.getProperty("registry.dlcm.last.state");
        String aspectName = resource.getProperty("registry.LC.name");
        Properties props = resource.getProperties();
        for (String string : props.keySet()) {
            if (!string.matches("registry\\p{Punct}lifecycle\\p{Punct}.*\\p{Punct}state")) continue;
            currentState = resource.getProperty(string);
            if (lastState == null) continue;
            break;
        }
        if (currentState == null || lastState != null && lastState.equals(currentState)) {
            return;
        }
        for (String string : props.keySet()) {
            List propValues;
            if (!string.matches("registry\\p{Punct}.*\\p{Punct}checklist\\p{Punct}.*") || (propValues = (List)props.get(string)) == null || propValues.size() <= 2) continue;
            String value = null;
            String lifeCycleState = null;
            for (String param : propValues) {
                if (param.startsWith("status:")) {
                    lifeCycleState = param.substring(7);
                    continue;
                }
                if (!param.startsWith("value:")) continue;
                value = param.substring(6);
            }
            if (lifeCycleState == null || value == null || !lifeCycleState.equalsIgnoreCase(currentState) || !value.equalsIgnoreCase("false")) continue;
            allItemsAreChecked = false;
            break;
        }
        if (!allItemsAreChecked) {
            return;
        }
        Object var10_13 = null;
        try {
            Resource oldResource = requestContext.getRepository().get(path);
            requestContext.getRepository().put(path, resource);
            stringArray = requestContext.getRegistry().getAspectActions(path, aspectName);
            requestContext.getRepository().put(path, oldResource);
            if (stringArray == null) {
                return;
            }
        }
        catch (RegistryException e) {
            return;
        }
        if (stringArray.length > 0 && !stringArray[0].equals("promote")) {
            ApprovalNeededEvent<String> event = new ApprovalNeededEvent<String>("Approval is needed to Promote '" + path + "' from lifecycle state '" + currentState + "'.");
            event.setResourcePath(path);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), path);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Put Operation", e);
            }
        }
    }

    protected void notify(RegistryEvent event, Registry registry, String path) throws Exception {
        try {
            if (Utils.getRegistryNotificationService() == null) {
                log.debug((Object)"Eventing service is unavailable.");
                return;
            }
            if (registry == null || registry.getEventingServiceURL(path) == null) {
                Utils.getRegistryNotificationService().notify(event);
                return;
            }
            if (Utils.getDefaultNotificationServiceURL() != null) {
                if (registry.getEventingServiceURL(path).equals(Utils.getDefaultNotificationServiceURL())) {
                    Utils.getRegistryNotificationService().notify(event);
                    return;
                }
                Utils.getRegistryNotificationService().notify(event, registry.getEventingServiceURL(path));
                return;
            }
            log.error((Object)"DLCM Eventing Handler is not properly initialized");
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to send notification", (Throwable)e);
        }
        log.error((Object)"Unable to send notification");
    }

    private void handleException(String message) {
        log.error((Object)message);
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
    }
}

