/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.samples.lcm.notifications.internal;

import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.governance.samples.lcm.notifications.handlers.DLCMEventingHandler;
import org.wso2.carbon.governance.samples.lcm.notifications.internal.Utils;
import org.wso2.carbon.registry.app.RemoteRegistryService;
import org.wso2.carbon.registry.common.eventing.NotificationService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class DLCMNotificationsServiceComponent {
    private static Log log = LogFactory.getLog(DLCMNotificationsServiceComponent.class);
    private Registry registry = null;
    private ListenerManager listenerManager = null;
    private boolean initialized = false;

    protected void activate(ComponentContext context) {
        log.debug((Object)"DLCM Notifications bundle is activated ");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"DLCM Notifications bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
        this.initailize();
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Utils.setRegistryService(null);
    }

    protected void setRegistryNotificationService(NotificationService notificationService) {
        Utils.setRegistryNotificationService(notificationService);
        this.initailize();
    }

    protected void unsetRegistryNotificationService(NotificationService notificationService) {
        Utils.setRegistryNotificationService(null);
    }

    protected void setListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        this.initailize();
    }

    protected void unsetListenerManager(ListenerManager listenerManager) {
        this.listenerManager = null;
    }

    private void initailize() {
        RegistryService registryService = Utils.getRegistryService();
        if (!this.initialized && this.listenerManager != null && registryService != null && Utils.getRegistryNotificationService() != null) {
            if (registryService instanceof RemoteRegistryService) {
                this.initialized = true;
                log.warn((Object)"Eventing is not available on Remote Registry");
                return;
            }
            this.initialized = true;
            try {
                UserRegistry userRegistry = registryService.getConfigSystemRegistry();
                if (this.registry != null && this.registry == userRegistry) {
                    return;
                }
                this.registry = userRegistry;
                if (this.registry == null || this.registry.getRegistryContext() == null || this.registry.getRegistryContext().getHandlerManager() == null) {
                    String msg = "Error Initializing DLCM Eventing Handler";
                    log.error((Object)msg);
                } else {
                    URLMatcher filter = new URLMatcher();
                    filter.setPutPattern(".*");
                    filter.setInvokeAspectPattern(".*");
                    DLCMEventingHandler handler = new DLCMEventingHandler();
                    this.registry.getRegistryContext().getHandlerManager().addHandler(null, (Filter)filter, (Handler)handler);
                    handler.init(this.registry.getEventingServiceURL(null));
                    log.info((Object)"Successfully Initialized the DLCM Eventing Handler");
                }
            }
            catch (Exception e) {
                String msg = "Error Initializing Notifications for DLCM";
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
    }
}

